/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.network;

import com.android.ddmlib.Client;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.network.NetworkSampler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.concurrent.Future;
import javax.swing.JComponent;

public class NetworkMonitorView
extends BaseMonitorView<NetworkSampler>
implements DeviceContext.DeviceSelectionListener {
    private static final int SAMPLE_FREQUENCY_MS = 500;
    private static final float TIMELINE_BUFFER_TIME = 0.75f;
    private static final float TIMELINE_INITIAL_MAX = 5.0f;
    private static final float TIMELINE_ABSOLUTE_MAX = Float.MAX_VALUE;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 1.0f;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final String MISSING_LABEL = "Network monitoring is not available on your device.";
    private static final String STARTING_LABEL = "Starting... If it is not finished within seconds, the device may not be properly connected, please reconnect.";
    private Future<?> checkStatsFileFuture;

    public NetworkMonitorView(Project project, DeviceContext deviceContext) {
        super(project, deviceContext, new NetworkSampler(500), 0.75f, 5.0f, Float.MAX_VALUE, 1.0f);
        this.myTimelineComponent.configureUnits("KB/s");
        this.myTimelineComponent.configureStream(0, "Rx", (Color)new JBColor(0xFF8000, 0xFF8000));
        this.myTimelineComponent.configureStream(1, "Tx", (Color)new JBColor(0xFFCC99, 0xFFCC99));
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.addOverlayText(MISSING_LABEL, 0);
        this.addOverlayText("This monitor is disabled.", 1);
        this.addOverlayText(STARTING_LABEL, 2);
        this.setViewComponent((JComponent)this.myTimelineComponent);
        deviceContext.addListener(this, (Disposable)project);
    }

    @Override
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        return group;
    }

    @Override
    public void clientSelected(final Client c) {
        ((NetworkSampler)this.mySampler).setClient(c);
        if (this.checkStatsFileFuture != null) {
            if (!this.checkStatsFileFuture.isDone()) {
                this.checkStatsFileFuture.cancel(true);
            }
            this.checkStatsFileFuture = null;
        }
        this.setOverlayEnabled(STARTING_LABEL, c != null);
        this.setOverlayEnabled(MISSING_LABEL, false);
        if (c != null) {
            this.checkStatsFileFuture = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final int networkStatsFileState = ((NetworkSampler)NetworkMonitorView.this.mySampler).checkStatsFile(c);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (c == NetworkMonitorView.this.myDeviceContext.getSelectedClient()) {
                                NetworkMonitorView.this.setOverlayEnabled(NetworkMonitorView.STARTING_LABEL, networkStatsFileState == 0);
                                NetworkMonitorView.this.setOverlayEnabled(NetworkMonitorView.MISSING_LABEL, networkStatsFileState < 0);
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public String getDescription() {
        return "network data usage";
    }
}

