/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;

public class AndroidBuildScriptNode
extends PsiFileNode {
    public static final String MODULE_PREFIX = "Module: ";
    public static final String PROJECT_PREFIX = "Project: ";
    private final String myQualifier;

    public AndroidBuildScriptNode(Project project, PsiFile value, ViewSettings viewSettings, String qualifier) {
        super(project, value, viewSettings);
        this.myQualifier = qualifier;
    }

    public void update(PresentationData data) {
        super.update(data);
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile == null || !psiFile.isValid()) {
            return;
        }
        String fileName = psiFile.getName();
        data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(fileName);
        if (this.myQualifier != null) {
            data.addText(" (" + this.myQualifier + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public Comparable getSortKey() {
        String priority;
        if (this.myQualifier != null) {
            priority = this.myQualifier.startsWith(PROJECT_PREFIX) ? "1-" : (this.myQualifier.startsWith(MODULE_PREFIX) ? "2-" : "3-");
            priority = priority + this.myQualifier + "-";
        } else {
            priority = "4-";
        }
        PsiFile f = (PsiFile)this.getValue();
        return f == null ? priority : priority + f.getName();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        String fileName = ((PsiFile)this.getValue()).getName();
        return fileName + (this.myQualifier == null ? "" : " (" + this.myQualifier + ")");
    }
}

