/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class AndroidManifestFileNode
extends PsiFileNode
implements DirectoryGroupNode {
    private final AndroidFacet myFacet;

    public AndroidManifestFileNode(Project project, PsiFile psiFile, ViewSettings settings, AndroidFacet facet) {
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(PresentationData data) {
        super.update(data);
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return;
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myFacet, file);
        if (sourceProvider != null && !"main".equals(sourceProvider.getName())) {
            data.addText(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + sourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            data.setPresentableText(file.getName());
        }
    }

    public static IdeaSourceProvider getSourceProvider(AndroidFacet facet, PsiFile file) {
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(facet)) {
            if (!file.getVirtualFile().equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    public Comparable getSortKey() {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myFacet, file);
        if (sourceProvider == null || "main".equals(sourceProvider.getName())) {
            return "";
        }
        return sourceProvider.getName();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    public PsiDirectory[] getDirectories() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(file.getName());
        sb.append(" (");
        sb.append(AndroidManifestFileNode.getSourceProvider(this.myFacet, (PsiFile)this.getValue()).getName());
        sb.append(")");
        return sb.toString();
    }
}

