/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.AndroidSourceTypeNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class AndroidModuleNode
extends ProjectViewModuleNode {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidModuleNode(Project project, Module module, ViewSettings settings, AndroidProjectViewPane projectViewPane) {
        super(project, module, settings);
        this.myProjectViewPane = projectViewPane;
    }

    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            return super.getChildren();
        }
        return AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet));
    }

    public static Collection<AbstractTreeNode> getChildren(AndroidFacet facet, ViewSettings settings, AndroidProjectViewPane pane, List<IdeaSourceProvider> providers) {
        Project project = facet.getModule().getProject();
        ArrayList result = Lists.newArrayList();
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers);
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.MANIFEST) {
                result.add(new AndroidManifestsGroupNode(project, facet, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES) {
                result.add(new AndroidResFolderNode(project, facet, settings, sourcesByType.get((Object)sourceType), pane));
                continue;
            }
            result.add(new AndroidSourceTypeNode(project, facet, settings, sourceType, sourcesByType.get((Object)sourceType), pane));
        }
        return result;
    }

    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(List<IdeaSourceProvider> providers) {
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet allSources = Sets.newHashSet();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources = AndroidModuleNode.getSources(sourceType, providers);
            if (sources.isEmpty()) continue;
            if (SetUtil.intersect((Set)allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        return sourcesByType;
    }

    private static Set<VirtualFile> getSources(AndroidSourceType sourceType, Iterable<IdeaSourceProvider> providers) {
        HashSet sources = Sets.newHashSet();
        for (IdeaSourceProvider provider : providers) {
            sources.addAll(sourceType.getSources(provider));
        }
        return sources;
    }

    public Comparable getSortKey() {
        return ((Module)this.getValue()).getName();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        Module module = (Module)this.getValue();
        return String.format("%1$s (Android)", module.getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

