/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.AndroidResGroupNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidResFolderTypeNode
extends ProjectViewNode<List<PsiDirectory>>
implements DirectoryGroupNode {
    private final AndroidFacet myFacet;
    private final ResourceFolderType myFolderType;
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidResFolderTypeNode(Project project, AndroidFacet facet, List<PsiDirectory> folders, ViewSettings settings, ResourceFolderType folderType, AndroidProjectViewPane projectViewPane) {
        super(project, folders, settings);
        this.myFacet = facet;
        this.myFolderType = folderType;
        this.myProjectViewPane = projectViewPane;
    }

    @Override
    public PsiDirectory[] getDirectories() {
        List dirs = (List)this.getValue();
        return dirs.toArray(new PsiDirectory[dirs.size()]);
    }

    public boolean contains(VirtualFile file) {
        for (PsiDirectory psiDirectory : (List)this.getValue()) {
            VirtualFile folder = psiDirectory.getVirtualFile();
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public Collection<? extends AbstractTreeNode> getChildren() {
        List folders = (List)this.getValue();
        HashMultimap multimap = HashMultimap.create();
        for (PsiDirectory res : folders) {
            for (PsiFile file : res.getFiles()) {
                String resName = file.getName();
                multimap.put((Object)resName, (Object)file);
            }
        }
        ArrayList children = Lists.newArrayListWithExpectedSize((int)multimap.size());
        for (String resName : multimap.keySet()) {
            ArrayList files = Lists.newArrayList((Iterable)multimap.get((Object)resName));
            if (files.size() > 1) {
                children.add(new AndroidResGroupNode(this.myProject, this.myFacet, files, resName, this.getSettings()));
                continue;
            }
            children.add(new AndroidResFileNode(this.myProject, (PsiFile)files.get(0), this.getSettings(), this.myFacet));
        }
        return children;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.myFolderType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(this.myFolderType.getName());
    }

    public Comparable getSortKey() {
        return this.myFolderType;
    }

    public Comparable getTypeSortKey() {
        return this.myFolderType;
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        return this.myFolderType.getName();
    }
}

