/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.assetstudiolib.ActionBarIconGenerator;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.LauncherIconGenerator;
import com.android.assetstudiolib.NotificationIconGenerator;
import com.android.assetstudiolib.TextRenderUtil;
import com.android.assetstudiolib.VectorIconGenerator;
import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.Density;
import com.android.tools.idea.npw.TemplateWizardContextAdapter;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AssetStudioAssetGenerator
implements GraphicGeneratorContext {
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_SCALING = "scaling";
    public static final String ATTR_SHAPE = "shape";
    public static final String ATTR_PADDING = "padding";
    public static final String ATTR_TRIM = "trim";
    public static final String ATTR_DOGEAR = "dogear";
    public static final String ATTR_FONT = "font";
    public static final String ATTR_FONT_SIZE = "fontSize";
    public static final String ATTR_SOURCE_TYPE = "sourceType";
    public static final String ATTR_IMAGE_PATH = "imagePath";
    public static final String ATTR_CLIPART_NAME = "clipartPath";
    public static final String ATTR_VECTOR_LIB_ICON_PATH = "vectorLibIconPath";
    public static final String ATTR_FOREGROUND_COLOR = "foregroundColor";
    public static final String ATTR_BACKGROUND_COLOR = "backgroundColor";
    public static final String ATTR_ASSET_TYPE = "assetType";
    public static final String ATTR_ASSET_THEME = "assetTheme";
    public static final String ATTR_ASSET_NAME = "assetName";
    public static final String ATTR_ERROR_LOG = "errorLog";
    public static final String ATTR_VECTOR_DRAWBLE_WIDTH = "vectorDrawableWidth";
    public static final String ATTR_VECTOR_DRAWBLE_HEIGHT = "vectorDrawableHeight";
    public static final String ATTR_ORIGINAL_WIDTH = "originalWidth";
    public static final String ATTR_ORIGINAL_HEIGHT = "originalHeight";
    public static final String ATTR_VECTOR_DRAWBLE_OPACTITY = "vectorDrawableOpacity";
    public static final String ATTR_VECTOR_DRAWBLE_AUTO_MIRRORED = "vectorDrawableAutoMirror";
    public static final String ATTR_VALID_PREVIEW = "validPreview";
    public static final String ERROR_MESSAGE_EMPTY_PREVIEW_IMAGE = "Empty preview image!";
    private static final Logger LOG = Logger.getInstance((String)("#" + AssetStudioAssetGenerator.class.getName()));
    private static final String OUTPUT_DIRECTORY = "src/main/";
    private static Cache<String, BufferedImage> ourImageCache = CacheBuilder.newBuilder().build();
    private final ActionBarIconGenerator myActionBarIconGenerator;
    private final NotificationIconGenerator myNotificationIconGenerator;
    private final LauncherIconGenerator myLauncherIconGenerator;
    private final VectorIconGenerator myVectorIconGenerator;
    private AssetStudioContext myContext;
    public static final int SVG_PREVIEW_WIDTH = 256;

    public AssetStudioAssetGenerator(AssetStudioContext context) {
        this(context, new ActionBarIconGenerator(), new NotificationIconGenerator(), new LauncherIconGenerator(), new VectorIconGenerator());
    }

    public AssetStudioAssetGenerator(TemplateWizardState state) {
        this(new TemplateWizardContextAdapter(state), new ActionBarIconGenerator(), new NotificationIconGenerator(), new LauncherIconGenerator(), new VectorIconGenerator());
    }

    AssetStudioAssetGenerator(AssetStudioContext context, ActionBarIconGenerator actionBarIconGenerator, NotificationIconGenerator notificationIconGenerator, LauncherIconGenerator launcherIconGenerator, VectorIconGenerator vectorIconGenerator) {
        this.myContext = context;
        this.myActionBarIconGenerator = actionBarIconGenerator != null ? actionBarIconGenerator : new ActionBarIconGenerator();
        this.myNotificationIconGenerator = notificationIconGenerator != null ? notificationIconGenerator : new NotificationIconGenerator();
        this.myLauncherIconGenerator = launcherIconGenerator != null ? launcherIconGenerator : new LauncherIconGenerator();
        this.myVectorIconGenerator = vectorIconGenerator != null ? vectorIconGenerator : new VectorIconGenerator();
        this.myContext.setText("Aa");
        this.myContext.setFont("Arial Black");
        this.myContext.setScaling(Scaling.CROP);
        this.myContext.setShape(GraphicGenerator.Shape.NONE);
        this.myContext.setFontSize(144);
        this.myContext.setSourceType(SourceType.IMAGE);
        this.myContext.setClipartName("android.png");
        this.myContext.setForegroundColor(Color.BLUE);
        this.myContext.setBackgroundColor(Color.WHITE);
        this.myContext.setTrim(false);
        this.myContext.setDogear(false);
        this.myContext.setPadding(0);
    }

    public BufferedImage loadImageResource(final String path) {
        try {
            return (BufferedImage)ourImageCache.get((Object)path, (Callable)new Callable<BufferedImage>(){

                @Override
                public BufferedImage call() throws Exception {
                    return AssetStudioAssetGenerator.getImage(path, true);
                }
            });
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public Map<String, Map<String, BufferedImage>> generateImages(boolean previewOnly) throws ImageGeneratorException {
        LinkedHashMap<String, Map<String, BufferedImage>> categoryMap = new LinkedHashMap<String, Map<String, BufferedImage>>();
        this.generateImages(categoryMap, false, previewOnly);
        return categoryMap;
    }

    public void generateImages(Map<String, Map<String, BufferedImage>> categoryMap, boolean clearMap, boolean previewOnly) throws ImageGeneratorException {
        AssetType type;
        if (clearMap) {
            categoryMap.clear();
        }
        if ((type = this.myContext.getAssetType()) == null) {
            return;
        }
        boolean trim = this.myContext.isTrim();
        boolean dogEar = this.myContext.isDogear();
        int padding = this.myContext.getPadding();
        SourceType sourceType = this.myContext.getSourceType();
        if (sourceType == null) {
            return;
        }
        BufferedImage sourceImage = null;
        switch (sourceType) {
            case SVG: 
            case VECTORDRAWABLE: {
                StringBuilder errorLog = new StringBuilder();
                sourceImage = this.getSvgImage(errorLog, sourceType);
                if (sourceImage == null) {
                    return;
                }
                this.myContext.setErrorLog(errorLog.toString());
                break;
            }
            case IMAGE: {
                String path = this.myContext.getImagePath();
                if (path == null || path.isEmpty()) {
                    throw new ImageGeneratorException("Path to image is empty.");
                }
                try {
                    sourceImage = AssetStudioAssetGenerator.getImage(path, false);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new ImageGeneratorException("Image file not found: " + path);
                }
                catch (IOException e) {
                    throw new ImageGeneratorException("Unable to load image file: " + path);
                }
            }
            case CLIPART: {
                String clipartName = this.myContext.getClipartName();
                try {
                    sourceImage = GraphicGenerator.getClipartImage((String)clipartName);
                }
                catch (IOException e) {
                    throw new ImageGeneratorException("Unable to load clip art image: " + clipartName);
                }
                if (!type.needsColors()) break;
                Color paint = this.myContext.getForegroundColor();
                sourceImage = AssetUtil.filledImage((BufferedImage)sourceImage, (Paint)paint);
                break;
            }
            case TEXT: {
                TextRenderUtil.Options options = new TextRenderUtil.Options();
                options.font = Font.decode(this.myContext.getFont() + " " + this.myContext.getFontSize());
                options.foregroundColor = type.needsColors() ? this.myContext.getForegroundColor().getRGB() : -1;
                sourceImage = TextRenderUtil.renderTextImage((String)this.myContext.getText(), (int)1, (TextRenderUtil.Options)options);
                break;
            }
        }
        if (trim) {
            sourceImage = AssetStudioAssetGenerator.crop(sourceImage);
        }
        if (padding != 0) {
            sourceImage = AssetUtil.paddedImage((BufferedImage)sourceImage, (int)padding);
        }
        VectorIconGenerator generator = null;
        VectorIconGenerator.VectorIconOptions options = null;
        String baseName = Strings.nullToEmpty((String)this.myContext.getAssetName());
        if (sourceType == SourceType.SVG || sourceType == SourceType.VECTORDRAWABLE) {
            generator = this.myVectorIconGenerator;
            options = new VectorIconGenerator.VectorIconOptions();
            options.density = Density.ANYDPI;
        } else {
            switch (type) {
                case LAUNCHER: {
                    generator = this.myLauncherIconGenerator;
                    LauncherIconGenerator.LauncherOptions launcherOptions = new LauncherIconGenerator.LauncherOptions();
                    launcherOptions.shape = this.myContext.getShape();
                    launcherOptions.crop = Scaling.CROP.equals((Object)this.myContext.getScaling());
                    launcherOptions.style = GraphicGenerator.Style.SIMPLE;
                    launcherOptions.backgroundColor = this.myContext.getBackgroundColor().getRGB();
                    boolean bl = launcherOptions.isWebGraphic = !previewOnly;
                    if (dogEar) {
                        launcherOptions.isDogEar = true;
                    }
                    options = launcherOptions;
                    break;
                }
                case ACTIONBAR: {
                    ActionBarIconGenerator.Theme theme;
                    generator = this.myActionBarIconGenerator;
                    ActionBarIconGenerator.ActionBarOptions actionBarOptions = new ActionBarIconGenerator.ActionBarOptions();
                    String themeName = this.myContext.getAssetTheme();
                    if (!StringUtil.isEmpty((String)themeName) && (theme = ActionBarIconGenerator.Theme.valueOf((String)themeName)) != null) {
                        switch (theme) {
                            case HOLO_DARK: {
                                actionBarOptions.theme = ActionBarIconGenerator.Theme.HOLO_DARK;
                                break;
                            }
                            case HOLO_LIGHT: {
                                actionBarOptions.theme = ActionBarIconGenerator.Theme.HOLO_LIGHT;
                                break;
                            }
                            case CUSTOM: {
                                actionBarOptions.theme = ActionBarIconGenerator.Theme.CUSTOM;
                                actionBarOptions.customThemeColor = this.myContext.getForegroundColor().getRGB();
                            }
                        }
                    }
                    actionBarOptions.sourceIsClipart = sourceType == SourceType.CLIPART;
                    options = actionBarOptions;
                    break;
                }
                case NOTIFICATION: {
                    generator = this.myNotificationIconGenerator;
                    NotificationIconGenerator.NotificationOptions notificationOptions = new NotificationIconGenerator.NotificationOptions();
                    notificationOptions.version = NotificationIconGenerator.Version.V11;
                    options = notificationOptions;
                }
            }
        }
        options.sourceImage = sourceImage;
        generator.generate(null, categoryMap, (GraphicGeneratorContext)this, (GraphicGenerator.Options)options, baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputImagesIntoVariantRoot(File variantDir) {
        try {
            Map<String, Map<String, BufferedImage>> images = this.generateImages(false);
            for (Map<String, BufferedImage> density : images.values()) {
                for (Map.Entry<String, BufferedImage> image : density.entrySet()) {
                    File file = new File(variantDir, image.getKey());
                    try {
                        VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
                        VirtualFile imageFile = directory.findChild(file.getName());
                        if (imageFile == null || !imageFile.exists()) {
                            imageFile = directory.createChildData((Object)this, file.getName());
                        }
                        OutputStream outputStream = imageFile.getOutputStream((Object)this);
                        try {
                            ImageIO.write((RenderedImage)image.getValue(), "PNG", outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void outputImagesIntoDefaultVariant(File contentRoot) {
        File directory = new File(contentRoot, OUTPUT_DIRECTORY);
        this.outputImagesIntoVariantRoot(directory);
    }

    public static Document parseVdStringIntoDocument(String xmlFileContent, StringBuilder errorLog) {
        Document document;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new InputSource(new StringReader(xmlFileContent)));
        }
        catch (Exception e) {
            if (errorLog != null) {
                errorLog.append("Exception while parsing XML file:\n").append(e.getMessage());
            }
            return null;
        }
        return document;
    }

    private BufferedImage getSvgImage(StringBuilder errorLog, SourceType sourceType) {
        String xmlFileContent;
        if (sourceType == SourceType.SVG) {
            xmlFileContent = AssetStudioAssetGenerator.generateVectorXml(new File(this.myContext.getImagePath()), errorLog);
        } else {
            assert (sourceType == SourceType.VECTORDRAWABLE);
            xmlFileContent = AssetStudioAssetGenerator.readXmlFile(this.myContext.getVectorLibIconPath());
        }
        if (xmlFileContent == null) {
            return null;
        }
        BufferedImage image = null;
        Document vdDocument = AssetStudioAssetGenerator.parseVdStringIntoDocument(xmlFileContent, errorLog);
        if (vdDocument != null) {
            String overrideContent;
            VdPreview.SourceSize vdSrcSize = VdPreview.getVdOriginalSize((Document)vdDocument);
            int vdWidth = vdSrcSize.getWidth();
            int vdHeight = vdSrcSize.getHeight();
            if (vdWidth > 0 && vdHeight > 0) {
                this.myContext.setOriginalWidth(vdWidth);
                this.myContext.setOriginalHeight(vdHeight);
            }
            if ((overrideContent = this.overrideXmlFileContent(vdDocument, errorLog)) != null) {
                xmlFileContent = overrideContent;
            }
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)256);
            image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xmlFileContent, (StringBuilder)errorLog);
        }
        if (image == null) {
            image = new BufferedImage(1, 1, 2);
            errorLog.insert(0, "Empty preview image!\n");
            this.myContext.setValidPreview(false);
        } else {
            this.myContext.setValidPreview(true);
        }
        return image;
    }

    private String overrideXmlFileContent(Document vdDocument, StringBuilder errorLog) {
        int targetWidth = 0;
        int targetHeight = 0;
        try {
            targetWidth = Integer.parseInt(this.myContext.getVectorWidth());
            targetHeight = Integer.parseInt(this.myContext.getVectorHeight());
        }
        catch (NumberFormatException e) {
            errorLog.append("Invalid size " + this.myContext.getVectorWidth() + " X " + this.myContext.getVectorHeight());
            return null;
        }
        if (targetWidth <= 0 || targetHeight <= 0) {
            errorLog.append("Size must be positive!");
            return null;
        }
        if (targetWidth > 4096 || targetHeight > 4096) {
            errorLog.append("Size can't be bigger than 4096");
            return null;
        }
        VdOverrideInfo info = new VdOverrideInfo(targetWidth, targetHeight, this.myContext.getVectorOpacity(), this.myContext.getVectorAutoMirrored());
        String xmlFileContent = VdPreview.overrideXmlContent((Document)vdDocument, (VdOverrideInfo)info, (StringBuilder)errorLog);
        return xmlFileContent;
    }

    private static String readXmlFile(URL url) {
        String xmlFileContent = null;
        if (url != null) {
            try {
                xmlFileContent = UrlUtil.loadText((URL)url);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return xmlFileContent;
    }

    public void outputXmlToRes(File targetResDir) {
        String xmlFileContent;
        SourceType sourceType = this.myContext.getSourceType();
        if (sourceType == SourceType.SVG) {
            String currentFilePath = this.myContext.getImagePath();
            xmlFileContent = AssetStudioAssetGenerator.generateVectorXml(new File(currentFilePath), null);
        } else {
            assert (sourceType == SourceType.VECTORDRAWABLE);
            xmlFileContent = AssetStudioAssetGenerator.readXmlFile(this.myContext.getVectorLibIconPath());
        }
        Document vdDocument = AssetStudioAssetGenerator.parseVdStringIntoDocument(xmlFileContent, null);
        if (vdDocument == null) {
            LOG.error("Error in parsing vector drawable's XML");
            return;
        }
        String overrideContent = this.overrideXmlFileContent(vdDocument, null);
        if (overrideContent != null) {
            xmlFileContent = overrideContent;
        }
        String xmlFileName = this.myContext.getAssetName();
        File file = new File(targetResDir, "drawable" + File.separator + xmlFileName + ".xml");
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile xmlFile = directory.findChild(file.getName());
            if (xmlFile == null || !xmlFile.exists()) {
                xmlFile = directory.createChildData((Object)this, file.getName());
            }
            VfsUtil.saveText((VirtualFile)xmlFile, (String)xmlFileContent);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String generateVectorXml(File inputSvgFile, StringBuilder error) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        String parseError = Svg2Vector.parseSvgToXml((File)inputSvgFile, (OutputStream)outStream);
        if (error != null) {
            error.append(Strings.nullToEmpty((String)parseError));
        }
        String vectorXmlContent = ((Object)outStream).toString();
        return vectorXmlContent;
    }

    protected static BufferedImage getImage(String path, boolean isPluginRelative) throws IOException {
        BufferedImage image = isPluginRelative ? GraphicGenerator.getStencilImage((String)path) : ImageIO.read(new File(path));
        if (image == null) {
            image = new BufferedImage(1, 1, 2);
        }
        return image;
    }

    protected static BufferedImage crop(BufferedImage sourceImage) {
        BufferedImage cropped = ImageUtils.cropBlank(sourceImage, null, 2);
        return cropped != null ? cropped : sourceImage;
    }

    public static enum AssetType {
        LAUNCHER("Launcher Icons", "ic_launcher"),
        ACTIONBAR("Action Bar and Tab Icons", "ic_action_%s"),
        NOTIFICATION("Notification Icons", "ic_stat_%s");

        private final String myDisplayName;
        private String myDefaultNameFormat;

        private AssetType(String displayName, String defaultNameFormat) {
            this.myDisplayName = displayName;
            this.myDefaultNameFormat = defaultNameFormat;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getDefaultNameFormat() {
            return this.myDefaultNameFormat;
        }

        public boolean needsForegroundScaling() {
            return this == LAUNCHER;
        }

        public boolean needsShape() {
            return this == LAUNCHER;
        }

        public boolean needsColors() {
            return this == LAUNCHER;
        }

        public boolean needsEffects() {
            return this == LAUNCHER;
        }

        public boolean needsTheme() {
            return this == ACTIONBAR;
        }
    }

    public static enum Scaling {
        CENTER,
        CROP;

    }

    public static enum SourceType {
        IMAGE,
        CLIPART,
        TEXT,
        SVG,
        VECTORDRAWABLE;

    }

    public static class ImageGeneratorException
    extends Exception {
        public ImageGeneratorException(String message) {
            super(message);
        }
    }

    public static interface AssetStudioContext {
        public int getPadding();

        public void setPadding(int var1);

        public SourceType getSourceType();

        public void setSourceType(SourceType var1);

        public AssetType getAssetType();

        public boolean isTrim();

        public void setTrim(boolean var1);

        public boolean isDogear();

        public void setDogear(boolean var1);

        public String getImagePath();

        public String getText();

        public void setText(String var1);

        public String getClipartName();

        public void setClipartName(String var1);

        public URL getVectorLibIconPath();

        public Color getForegroundColor();

        public void setForegroundColor(Color var1);

        public String getFont();

        public void setFont(String var1);

        public int getFontSize();

        public void setFontSize(int var1);

        public Scaling getScaling();

        public void setScaling(Scaling var1);

        public String getAssetName();

        public GraphicGenerator.Shape getShape();

        public void setShape(GraphicGenerator.Shape var1);

        public Color getBackgroundColor();

        public void setBackgroundColor(Color var1);

        public String getAssetTheme();

        public void setErrorLog(String var1);

        public String getVectorWidth();

        public String getVectorHeight();

        public int getVectorOpacity();

        public boolean getVectorAutoMirrored();

        public void setOriginalWidth(int var1);

        public void setOriginalHeight(int var1);

        public void setValidPreview(boolean var1);
    }
}

