/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.ConfigureAndroidModuleStep;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.CommonBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;

public class ChooseAndroidAndJavaSdkStep
extends ModuleWizardStep {
    private JdkComboBox myJavaSdkCombo;
    private TextFieldWithBrowseButton myAndroidSdkLocationField;
    private JPanel myPanel;
    private JButton myNewButton;
    private ProjectSdksModel mySdksModel;

    public ChooseAndroidAndJavaSdkStep() {
        this.$$$setupUI$$$();
        this.myAndroidSdkLocationField.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(false, true, false, false, false, false)));
        this.myJavaSdkCombo.setSetupButton(this.myNewButton, null, this.mySdksModel, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.NoneJdkComboBoxItem(), null, false);
    }

    private String getAndroidSdkLocation() {
        return this.myAndroidSdkLocationField.getText().trim();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        final String location = this.getAndroidSdkLocation();
        if (location != null) {
            final Sdk javaSdk = this.myJavaSdkCombo.getSelectedJdk();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    IdeSdks.setAndroidSdkPath(new File(location), javaSdk, null);
                }
            });
        }
    }

    public boolean validate() throws ConfigurationException {
        if (this.myJavaSdkCombo.getSelectedJdk() == null) {
            throw new ConfigurationException("Specify Java SDK");
        }
        this.mySdksModel.apply(null, true);
        String location = this.getAndroidSdkLocation();
        if (location != null) {
            if (location.length() == 0) {
                throw new ConfigurationException("Specify Android SDK location");
            }
            File fileLocation = new File(FileUtil.toSystemIndependentName((String)location));
            if (!fileLocation.isDirectory()) {
                throw new ConfigurationException(location + " is not directory");
            }
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(fileLocation, true);
            if (sdkData == null) {
                throw new ConfigurationException("Invalid Android SDK");
            }
            if (ConfigureAndroidModuleStep.getCompilationTargets(sdkData).length == 0) {
                int result = Messages.showOkCancelDialog((Component)this.myPanel, (String)"This Android SDK doesn't contain any platform targets installed.\nPlease launch SDK manager to install the platforms.", (String)CommonBundle.getErrorTitle(), (String)"Launch SDK manager", (String)Messages.CANCEL_BUTTON, (Icon)Messages.getErrorIcon());
                if (result == 0) {
                    RunAndroidSdkManagerAction.runSpecificSdkManager(null, fileLocation);
                }
                return false;
            }
        }
        return true;
    }

    public boolean isStepVisible() {
        return IdeSdks.getJdk() == null || IdeSdks.getAndroidSdkPath() == null;
    }

    private void createUIComponents() {
        this.mySdksModel = new ProjectSdksModel();
        this.mySdksModel.reset(null);
        this.myJavaSdkCombo = new JdkComboBox(this.mySdksModel, (Condition)new Condition<SdkTypeId>(){

            public boolean value(SdkTypeId id) {
                return JavaSdk.getInstance().equals((Object)id);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Java SDK:");
        jBLabel.setDisplayedMnemonic('J');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JdkComboBox jdkComboBox = this.myJavaSdkCombo;
        jPanel.add((Component)jdkComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Android SDK location:");
        jBLabel2.setDisplayedMnemonic('A');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAndroidSdkLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myNewButton = jButton = new JButton();
        jButton.setText("New");
        jButton.setMnemonic('N');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)jdkComboBox);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

