/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.npw.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.ConfigureFormFactorStep;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.sdk.wizard.SmwOldApiDirectInstall;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class ConfigureAndroidProjectPath
extends DynamicWizardPath {
    private static final Logger LOG = Logger.getInstance(ConfigureAndroidProjectPath.class);
    private final Disposable myParentDisposable;

    public ConfigureAndroidProjectPath(Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
    }

    @Override
    protected void init() {
        ConfigureAndroidProjectPath.putSdkDependentParams(this.myState);
        this.addStep(new ConfigureAndroidProjectStep(this.myParentDisposable));
        this.addStep(new ConfigureFormFactorStep(this.myParentDisposable));
        this.addStep(new LicenseAgreementStep(this.myParentDisposable));
        this.addStep(new SmwOldApiDirectInstall(this.myParentDisposable));
    }

    @Override
    public boolean validate() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            this.setErrorHtml("<html>Your Android SDK is missing, out of date, or is missing templates. Please ensure you are using SDK version " + VersionCheck.MIN_TOOLS_REV + " or later.<br>" + "You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>");
            return false;
        }
        return true;
    }

    @Override
    public String getPathName() {
        return "Configure Android Project";
    }

    public static void putSdkDependentParams(ScopedStateStore state) {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        BuildToolInfo buildTool = sdkData != null ? sdkData.getLatestBuildTool() : null;
        FullRevision minimumRequiredBuildToolVersion = FullRevision.parseRevision((String)"19.1.0");
        if (buildTool != null && buildTool.getRevision().compareTo(minimumRequiredBuildToolVersion) >= 0) {
            state.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, buildTool.getRevision().toString());
        } else {
            state.listPush(WizardConstants.INSTALL_REQUESTS_KEY, PkgDesc.Builder.newBuildTool((FullRevision)minimumRequiredBuildToolVersion).create());
            state.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, minimumRequiredBuildToolVersion.toString());
        }
        if (sdkData != null) {
            state.put(WizardConstants.SDK_HOME_KEY, FileUtil.toSystemIndependentName((String)sdkData.getPath()));
        }
    }

    @Override
    public boolean performFinishingActions() {
        try {
            Project project = this.getProject();
            assert (project != null);
            File projectRoot = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
            Template projectTemplate = Template.createFromName("gradle-projects", "NewAndroidProject");
            projectTemplate.render(projectRoot, projectRoot, this.myState.flatten(), project);
            ConfigureAndroidProjectPath.setGradleWrapperExecutable(projectRoot);
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    protected static DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings buildConfigurationHeader() {
        return DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader("New Project");
    }

    public static void setGradleWrapperExecutable(File projectRoot) throws IOException {
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(projectRoot, "gradlew");
            if (!gradlewFile.isFile()) {
                LOG.error("Could not find gradle wrapper. Command line builds may not work properly.");
            } else {
                FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
            }
        }
    }
}

