/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.WrapArchiveWizardPath;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CreateModuleFromArchiveAction
extends WriteCommandAction<Object> {
    private Project myProject;
    private GradleSettingsFile mySettingsFile;
    private String myGradlePath;
    private File myArchivePath;
    private boolean myMove;
    private Module[] myModulesToAddDependency;

    public CreateModuleFromArchiveAction(Project project, GradleSettingsFile settingsFile, String gradlePath, File archivePath, boolean move, Module[] modulesToAddDependency) {
        super(project, String.format("create module %1$s", gradlePath), new PsiFile[]{settingsFile != null ? settingsFile.getPsiFile() : null});
        this.myProject = project;
        this.mySettingsFile = settingsFile;
        this.myGradlePath = gradlePath;
        this.myArchivePath = archivePath;
        this.myMove = move;
        this.myModulesToAddDependency = modulesToAddDependency;
    }

    protected static String getBuildGradleText(File jarName) {
        return String.format("configurations.create(\"default\")\nartifacts.add(\"default\", file('%1$s'))", jarName.getName());
    }

    private void addDependency(Module module, String gradlePath) throws IOException {
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile == null) {
            throw new IOException("Missing build.gradle");
        }
        List<BuildFileStatement> dependencies = buildFile.getDependencies();
        ArrayList newDeps = Lists.newArrayListWithCapacity((int)(dependencies.size() + 1));
        File moduleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getFile().getParent());
        for (BuildFileStatement dependency : dependencies) {
            Dependency newDep = this.filterDependencyStatement((Dependency)dependency, moduleRoot);
            if (newDep == null) continue;
            newDeps.add(newDep);
        }
        newDeps.add(new Dependency(Dependency.Scope.COMPILE, Dependency.Type.MODULE, gradlePath));
        buildFile.setValue(BuildFileKey.DEPENDENCIES, newDeps);
    }

    private Dependency filterDependencyStatement(Dependency dependency, File moduleRoot) {
        Object rawArguments = dependency.data;
        if (dependency.type == Dependency.Type.FILES && rawArguments != null) {
            String[] stringArray;
            if (rawArguments instanceof String[]) {
                stringArray = (String[])rawArguments;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = rawArguments.toString();
            }
            String[] data = stringArray;
            ArrayList list = Lists.newArrayListWithCapacity((int)data.length);
            for (String jarFile : data) {
                File path = new File(jarFile);
                if (!path.isAbsolute()) {
                    path = new File(moduleRoot, jarFile);
                }
                if (FileUtil.filesEqual((File)path, (File)this.myArchivePath)) continue;
                list.add(jarFile);
            }
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return new Dependency(dependency.scope, dependency.type, list.get(0));
            }
            return new Dependency(dependency.scope, dependency.type, Iterables.toArray((Iterable)list, String.class));
        }
        return dependency;
    }

    protected void run(Result<Object> result) throws Throwable {
        File moduleLocation = GradleUtil.getModuleDefaultPath(this.myProject.getBaseDir(), this.myGradlePath);
        try {
            VirtualFile moduleRoot = VfsUtil.createDirectoryIfMissing((String)moduleLocation.getAbsolutePath());
            VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)this.myArchivePath, (boolean)true);
            if (sourceFile != null && moduleRoot != null) {
                if (this.myMove) {
                    sourceFile.move((Object)this, moduleRoot);
                } else {
                    VfsUtil.copy((Object)((Object)this), (VirtualFile)sourceFile, (VirtualFile)moduleRoot);
                }
                VirtualFile buildGradle = moduleRoot.createChildData((Object)this, "build.gradle");
                VfsUtil.saveText((VirtualFile)buildGradle, (String)CreateModuleFromArchiveAction.getBuildGradleText(this.myArchivePath));
                if (this.mySettingsFile == null) {
                    this.mySettingsFile = GradleSettingsFile.getOrCreate(this.myProject);
                }
                this.mySettingsFile.addModule(this.myGradlePath, VfsUtilCore.virtualToIoFile((VirtualFile)moduleRoot));
                for (Module module : this.myModulesToAddDependency) {
                    this.addDependency(module, this.myGradlePath);
                }
            }
        }
        catch (IOException e) {
            Logger.getInstance(WrapArchiveWizardPath.class).error((Throwable)e);
        }
    }

    protected boolean isGlobalUndoAction() {
        return true;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }
}

