/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.ui.ComboBoxItemWithApiTag;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public final class FormFactorApiComboBox
extends JComboBox {
    private static final Logger LOG = Logger.getInstance(FormFactorApiComboBox.class);
    private static final Set<AndroidVersion> ourInstalledVersions = Sets.newHashSet();
    private static final List<AndroidTargetComboBoxItem> ourTargets = Lists.newArrayList();
    private static IAndroidTarget ourHighestInstalledApiTarget;
    private FormFactorUtils.FormFactor myFormFactor;
    private IPkgDesc myInstallRequest;
    private ScopedStateStore.Key<String> myBuildApiKey;
    private ScopedStateStore.Key<Integer> myBuildApiLevelKey;
    private ScopedStateStore.Key<Integer> myTargetApiLevelKey;
    private ScopedStateStore.Key<String> myTargetApiStringKey;
    private ScopedStateStore.Key<AndroidTargetComboBoxItem> myTargetComboBoxKey;
    private ScopedStateStore.Key<Boolean> myInclusionKey;
    static final ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox> TARGET_COMBO_BINDING;

    public FormFactorApiComboBox(FormFactorUtils.FormFactor formFactor, int minSdkLevel) {
        this.init(formFactor, minSdkLevel);
    }

    public FormFactorApiComboBox() {
    }

    public void init(FormFactorUtils.FormFactor formFactor, int minSdkLevel) {
        this.myFormFactor = formFactor;
        FormFactorApiComboBox.loadTargets();
        FormFactorApiComboBox.loadInstalledVersions();
        this.myBuildApiKey = FormFactorUtils.getBuildApiKey(formFactor);
        this.myBuildApiLevelKey = FormFactorUtils.getBuildApiLevelKey(formFactor);
        this.myTargetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(formFactor);
        this.myTargetApiStringKey = FormFactorUtils.getTargetApiStringKey(formFactor);
        this.myTargetComboBoxKey = FormFactorUtils.getTargetComboBoxKey(formFactor);
        this.myInclusionKey = FormFactorUtils.getInclusionKey(formFactor);
        this.populateComboBox(formFactor, minSdkLevel);
        this.loadSavedApi();
    }

    public void register(ScopedDataBinder binder) {
        assert (this.myFormFactor != null) : "register() called on FormFactorApiComboBox before init()";
        binder.register(FormFactorUtils.getTargetComboBoxKey(this.myFormFactor), this, TARGET_COMBO_BINDING);
    }

    public void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        this.setSelectedItem(savedApiLevel);
        if (this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void deriveValues(ScopedStateStore stateStore, Set<ScopedStateStore.Key> modified) {
        if (modified.contains(this.myTargetComboBoxKey) || modified.contains(this.myInclusionKey)) {
            AndroidSdkData sdkData;
            AndroidTargetComboBoxItem targetItem = stateStore.get(this.myTargetComboBoxKey);
            if (targetItem == null) {
                return;
            }
            stateStore.put(FormFactorUtils.getMinApiKey(this.myFormFactor), targetItem.id.toString());
            stateStore.put(FormFactorUtils.getMinApiLevelKey(this.myFormFactor), targetItem.apiLevel);
            IAndroidTarget target = targetItem.target;
            if (target != null && (target.getVersion().isPreview() || !target.isPlatform())) {
                this.populateApiLevels(targetItem.apiLevel, target, stateStore);
            } else {
                int targetApiLevel = ourHighestInstalledApiTarget != null ? ourHighestInstalledApiTarget.getVersion().getFeatureLevel() : 0;
                this.populateApiLevels(targetApiLevel, ourHighestInstalledApiTarget, stateStore);
            }
            if (this.myInstallRequest != null) {
                stateStore.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, this.myInstallRequest);
            }
            if (target == null) {
                AndroidVersion androidVersion = new AndroidVersion(targetItem.apiLevel, null);
                if (ourHighestInstalledApiTarget == null || androidVersion.getApiLevel() > ourHighestInstalledApiTarget.getVersion().getApiLevel() && !ourInstalledVersions.contains(androidVersion) && stateStore.get(this.myInclusionKey).booleanValue()) {
                    IPkgDesc platformDescription = PkgDesc.Builder.newPlatform((AndroidVersion)androidVersion, (MajorRevision)new MajorRevision(1), (FullRevision)FullRevision.NOT_SPECIFIED).create();
                    stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformDescription);
                    this.myInstallRequest = platformDescription;
                    this.populateApiLevels(androidVersion.getApiLevel(), ourHighestInstalledApiTarget, stateStore);
                }
            }
            PropertiesComponent.getInstance().setValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), targetItem.id.toString());
            String javaVersion = null;
            if (ourHighestInstalledApiTarget != null && ourHighestInstalledApiTarget.getVersion().getFeatureLevel() >= 21 && (sdkData = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
                JavaSdkVersion version;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    javaVersion = JavaSdkVersion.JDK_1_7.getDescription();
                }
            }
            stateStore.put(FormFactorUtils.getLanguageLevelKey(this.myFormFactor), javaVersion);
        }
    }

    public void setSelectedItem(String item) {
        ScopedDataBinder.setSelectedItem(this, item);
    }

    private void populateComboBox(FormFactorUtils.FormFactor formFactor, int minSdk) {
        for (AndroidTargetComboBoxItem target : Iterables.filter(ourTargets, FormFactorUtils.getMinSdkComboBoxFilter(formFactor, minSdk))) {
            if (target.apiLevel < minSdk && (target.target == null || !target.target.getVersion().isPreview())) continue;
            this.addItem(target);
        }
    }

    private static void loadTargets() {
        ourTargets.clear();
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(knownVersions[i], i + 1);
                ourTargets.add(targetInfo);
            }
        }
        for (IAndroidTarget target : targets) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourTargets.add(targetInfo);
        }
    }

    public static void loadInstalledVersions() {
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        IAndroidTarget highestInstalledTarget = null;
        ourInstalledVersions.clear();
        for (IAndroidTarget target : targets) {
            if (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview()) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourInstalledVersions.add(targetInfo.target.getVersion());
        }
        ourHighestInstalledApiTarget = highestInstalledTarget;
    }

    private static IAndroidTarget[] getCompilationTargets() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            return new IAndroidTarget[0];
        }
        return FormFactorApiComboBox.getCompilationTargets(sdkData);
    }

    public static IAndroidTarget[] getCompilationTargets(AndroidSdkData sdkData) {
        IAndroidTarget[] targets = sdkData.getTargets();
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() && target.getOptionalLibraries().isEmpty()) continue;
            list.add(target);
        }
        return list.toArray(new IAndroidTarget[list.size()]);
    }

    public void populateApiLevels(int apiLevel, IAndroidTarget apiTarget, ScopedStateStore state) {
        if (apiLevel >= 1) {
            if (apiTarget == null) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
            } else if (!apiTarget.isPlatform()) {
                state.put(this.myBuildApiKey, AndroidTargetHash.getTargetHashString((IAndroidTarget)apiTarget));
            } else {
                state.put(this.myBuildApiKey, TemplateMetadata.getBuildApiString(apiTarget.getVersion()));
            }
            state.put(this.myBuildApiLevelKey, apiLevel);
            if (apiLevel >= 23 || apiTarget != null && apiTarget.getVersion().isPreview()) {
                state.put(this.myTargetApiLevelKey, apiLevel);
                if (apiTarget != null) {
                    state.put(this.myTargetApiStringKey, apiTarget.getVersion().getApiString());
                } else {
                    state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
                }
            } else if (ourHighestInstalledApiTarget != null) {
                state.put(this.myTargetApiLevelKey, ourHighestInstalledApiTarget.getVersion().getApiLevel());
                state.put(this.myTargetApiStringKey, ourHighestInstalledApiTarget.getVersion().getApiString());
            }
            if (apiTarget != null && apiLevel > apiTarget.getVersion().getApiLevel() && !apiTarget.getVersion().isPreview()) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
                state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
            }
        }
    }

    static {
        TARGET_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox>(){

            @Override
            public void setValue(AndroidTargetComboBoxItem newValue, JComboBox component) {
                component.setSelectedItem(newValue);
            }

            @Override
            public AndroidTargetComboBoxItem getValue(JComboBox component) {
                return (AndroidTargetComboBoxItem)component.getItemAt(component.getSelectedIndex());
            }

            @Override
            public void addActionListener(ActionListener listener, JComboBox component) {
                component.addActionListener(listener);
            }
        };
    }

    public static class AndroidTargetComboBoxItem
    extends ComboBoxItemWithApiTag {
        public int apiLevel = -1;
        public IAndroidTarget target = null;

        public AndroidTargetComboBoxItem(String label, int apiLevel) {
            super(Integer.toString(apiLevel), label, 1, 1);
            this.apiLevel = apiLevel;
        }

        public AndroidTargetComboBoxItem(IAndroidTarget target) {
            super(AndroidTargetComboBoxItem.getId(target), AndroidTargetComboBoxItem.getLabel(target), 1, 1);
            this.target = target;
            this.apiLevel = target.getVersion().getFeatureLevel();
        }

        private static String getLabel(IAndroidTarget target) {
            if (target.isPlatform() && target.getVersion().getApiLevel() <= 23) {
                if (target.getVersion().isPreview()) {
                    return target.getVersion().getApiString() + ": " + target.getName();
                }
                String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
                if (name == null) {
                    return "API " + Integer.toString(target.getVersion().getApiLevel());
                }
                return name;
            }
            return AndroidSdkUtils.getTargetLabel(target);
        }

        private static String getId(IAndroidTarget target) {
            return target.getVersion().getApiString();
        }

        @Override
        public String toString() {
            return this.label;
        }
    }
}

