/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.sdklib.repository.descriptors.IPkgDescAddon;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FormFactorUtils {
    public static final String INCLUDE_FORM_FACTOR = "included";
    public static final String ATTR_MODULE_NAME = "projectName";

    public static ScopedStateStore.Key<FormFactorApiComboBox.AndroidTargetComboBoxItem> getTargetComboBoxKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "minApi" + "combo", ScopedStateStore.Scope.STEP, FormFactorApiComboBox.AndroidTargetComboBoxItem.class);
    }

    public static ScopedStateStore.Key<Integer> getMinApiLevelKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "minApiLevel", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    public static ScopedStateStore.Key<String> getMinApiKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "minApi", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<String> getBuildApiKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "buildApiString", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<Integer> getTargetApiLevelKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "targetApi", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    public static ScopedStateStore.Key<String> getTargetApiStringKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "targetApiString", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<Integer> getBuildApiLevelKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "buildApi", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    public static ScopedStateStore.Key<String> getLanguageLevelKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "javaVersion", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<Boolean> getInclusionKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + INCLUDE_FORM_FACTOR, ScopedStateStore.Scope.WIZARD, Boolean.class);
    }

    public static ScopedStateStore.Key<String> getModuleNameKey(FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + ATTR_MODULE_NAME, ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static Map<String, Object> scrubFormFactorPrefixes(FormFactor formFactor, Map<String, Object> values) {
        HashMap toReturn = Maps.newHashMapWithExpectedSize((int)values.size());
        for (String key : values.keySet()) {
            if (key.startsWith(formFactor.id)) {
                toReturn.put(key.substring(formFactor.id.length()), values.get(key));
                continue;
            }
            toReturn.put(key, values.get(key));
        }
        return toReturn;
    }

    public static String getPropertiesComponentMinSdkKey(FormFactor formFactor) {
        return formFactor.id + "minApi";
    }

    public static String getModuleName(FormFactor formFactor) {
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        String name = formFactor.id.replaceAll("[/\\\\?%*:|\"<>!;]", "");
        name = name.replaceAll("\\s", "_");
        return name.toLowerCase();
    }

    public static Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem> getMinSdkComboBoxFilter(final FormFactor formFactor, final int minSdkLevel) {
        return new Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem>(){

            public boolean apply(FormFactorApiComboBox.AndroidTargetComboBoxItem input) {
                if (input == null) {
                    return false;
                }
                return FormFactorUtils.doFilter(formFactor, minSdkLevel, input.target != null ? input.target.getName() : null, input.apiLevel) || input.target != null && input.target.getVersion().isPreview();
            }
        };
    }

    public static Predicate<RemotePkgInfo> getMinSdkPackageFilter(final FormFactor formFactor, final int minSdkLevel) {
        return new Predicate<RemotePkgInfo>(){

            public boolean apply(RemotePkgInfo input) {
                if (input == null) {
                    return false;
                }
                if (input.getPkgDesc().getType() == PkgType.PKG_ADDON) {
                    IPkgDescAddon addon = (IPkgDescAddon)input.getPkgDesc();
                    return FormFactorUtils.doFilter(formFactor, minSdkLevel, addon.getName().getId(), addon.getAndroidVersion().getFeatureLevel());
                }
                return false;
            }
        };
    }

    private static boolean doFilter(FormFactor formFactor, int minSdkLevel, String inputName, int targetSdkLevel) {
        if (!formFactor.myApiWhitelist.isEmpty()) {
            for (String filterItem : formFactor.myApiWhitelist) {
                if (!FormFactorUtils.matches(filterItem, inputName, targetSdkLevel)) continue;
                return true;
            }
            return false;
        }
        for (String filterItem : formFactor.myApiBlacklist) {
            if (!FormFactorUtils.matches(filterItem, inputName, targetSdkLevel)) continue;
            return false;
        }
        return targetSdkLevel >= minSdkLevel;
    }

    private static boolean matches(String filterItem, String inputName, int inputVersion) {
        if (Integer.toString(inputVersion).equals(filterItem)) {
            return true;
        }
        return inputName != null && inputName.contains(filterItem);
    }

    public static Icon getFormFactorsImage(JComponent component, boolean requireEmulator) {
        int width = 0;
        int height = 0;
        for (DeviceMenuAction.FormFactor formFactor : DeviceMenuAction.FormFactor.values()) {
            Icon icon = formFactor.getLargeIcon();
            height = icon.getIconHeight();
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            width += formFactor.getLargeIcon().getIconWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        for (DeviceMenuAction.FormFactor formFactor : DeviceMenuAction.FormFactor.values()) {
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            Icon icon = formFactor.getLargeIcon();
            icon.paintIcon(component, graphics, x, 0);
            x += icon.getIconWidth();
        }
        if (graphics != null) {
            graphics.dispose();
            return new ImageIcon(image);
        }
        return null;
    }

    public static class FormFactor
    implements Comparable<FormFactor> {
        public static final FormFactor MOBILE = new FormFactor("Mobile", DeviceMenuAction.FormFactor.MOBILE, "Phone and Tablet", 15, Lists.newArrayList((Object[])new String[]{"20", "Glass", "Google APIs"}), null, 0, null);
        public static final FormFactor WEAR = new FormFactor("Wear", DeviceMenuAction.FormFactor.WEAR, "Wear", 21, null, Lists.newArrayList((Object[])new String[]{"20", "21", "22"}), 1, null);
        public static final FormFactor TV = new FormFactor("TV", DeviceMenuAction.FormFactor.TV, "TV", 21, Lists.newArrayList((Object[])new String[]{"20"}), null, 2, null);
        public static final FormFactor CAR = new FormFactor("Car", DeviceMenuAction.FormFactor.CAR, "Android Auto", 21, null, null, 3, MOBILE);
        public static final FormFactor GLASS = new FormFactor("Glass", DeviceMenuAction.FormFactor.GLASS, "Glass", 19, null, Lists.newArrayList((Object[])new String[]{"Glass", "google_gdk"}), 4, null);
        private static final Map<String, FormFactor> myFormFactors = new ImmutableMap.Builder().put((Object)FormFactor.MOBILE.id, (Object)MOBILE).put((Object)FormFactor.WEAR.id, (Object)WEAR).put((Object)FormFactor.TV.id, (Object)TV).put((Object)FormFactor.CAR.id, (Object)CAR).put((Object)FormFactor.GLASS.id, (Object)GLASS).build();
        public final String id;
        private String myDisplayName;
        public final int defaultApi;
        private final List<String> myApiBlacklist;
        private final List<String> myApiWhitelist;
        private final DeviceMenuAction.FormFactor myEnumValue;
        private final int relativeOrder;
        public final FormFactor baseFormFactor;

        FormFactor(String id, DeviceMenuAction.FormFactor enumValue, String displayName, int defaultApi, List<String> apiBlacklist, List<String> apiWhitelist, int relativeOrder, FormFactor baseFormFactor) {
            this.id = id;
            this.myEnumValue = enumValue;
            this.myDisplayName = displayName;
            this.defaultApi = defaultApi;
            this.relativeOrder = relativeOrder;
            this.myApiBlacklist = apiBlacklist != null ? apiBlacklist : Collections.emptyList();
            this.myApiWhitelist = apiWhitelist != null ? apiWhitelist : Collections.emptyList();
            this.baseFormFactor = baseFormFactor;
        }

        public static FormFactor get(String id) {
            if (myFormFactors.containsKey(id)) {
                return myFormFactors.get(id);
            }
            return new FormFactor(id, DeviceMenuAction.FormFactor.MOBILE, id, 1, null, null, myFormFactors.size(), null);
        }

        public DeviceMenuAction.FormFactor getEnumValue() {
            return this.myEnumValue;
        }

        public String toString() {
            return this.myDisplayName == null ? this.id : this.myDisplayName;
        }

        public Icon getIcon() {
            return this.myEnumValue.getIcon64();
        }

        public static Iterator<FormFactor> iterator() {
            return myFormFactors.values().iterator();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof FormFactor && ((FormFactor)obj).id.equals(this.id);
        }

        @Override
        public int compareTo(FormFactor formFactor) {
            return this.relativeOrder - formFactor.relativeOrder;
        }
    }
}

