/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.builder.model.SourceProvider;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.npw.AssetStudioAssetGenerator;
import com.android.tools.idea.npw.ScopedStateStoreAdapter;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.ComboBoxItemWithApiTag;
import com.android.tools.idea.ui.ImageComponent;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.RadioButtonGroupBinding;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class IconStep
extends DynamicWizardStepWithDescription
implements Disposable {
    public static final ScopedStateStore.Key<String> ATTR_ASSET_NAME = ScopedStateStore.createKey("assetName", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<String> ATTR_CLIPART_NAME = ScopedStateStore.createKey("clipartPath", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<URL> ATTR_VECTOR_LIB_ICON_PATH = ScopedStateStore.createKey("vectorLibIconPath", ScopedStateStore.Scope.PATH, URL.class);
    public static final ScopedStateStore.Key<String> ATTR_TEXT = ScopedStateStore.createKey("text", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<String> ATTR_FONT = ScopedStateStore.createKey("font", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<AssetStudioAssetGenerator.AssetType> ATTR_ASSET_TYPE = ScopedStateStore.createKey("assetType", ScopedStateStore.Scope.PATH, AssetStudioAssetGenerator.AssetType.class);
    public static final ScopedStateStore.Key<String> ATTR_ASSET_THEME = ScopedStateStore.createKey("assetTheme", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<AssetStudioAssetGenerator.Scaling> ATTR_SCALING = ScopedStateStore.createKey("scaling", ScopedStateStore.Scope.PATH, AssetStudioAssetGenerator.Scaling.class);
    public static final ScopedStateStore.Key<GraphicGenerator.Shape> ATTR_SHAPE = ScopedStateStore.createKey("shape", ScopedStateStore.Scope.PATH, GraphicGenerator.Shape.class);
    public static final ScopedStateStore.Key<AssetStudioAssetGenerator.SourceType> ATTR_SOURCE_TYPE = ScopedStateStore.createKey("sourceType", ScopedStateStore.Scope.PATH, AssetStudioAssetGenerator.SourceType.class);
    public static final ScopedStateStore.Key<Boolean> ATTR_TRIM = ScopedStateStore.createKey("trim", ScopedStateStore.Scope.PATH, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> ATTR_DOGEAR = ScopedStateStore.createKey("dogear", ScopedStateStore.Scope.PATH, Boolean.class);
    public static final ScopedStateStore.Key<Integer> ATTR_PADDING = ScopedStateStore.createKey("padding", ScopedStateStore.Scope.PATH, Integer.class);
    public static final ScopedStateStore.Key<Color> ATTR_FOREGROUND_COLOR = ScopedStateStore.createKey("foregroundColor", ScopedStateStore.Scope.PATH, Color.class);
    public static final ScopedStateStore.Key<Color> ATTR_BACKGROUND_COLOR = ScopedStateStore.createKey("backgroundColor", ScopedStateStore.Scope.PATH, Color.class);
    public static final ScopedStateStore.Key<String> ATTR_IMAGE_PATH = ScopedStateStore.createKey("imagePath", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<String> ATTR_ICON_RESOURCE = ScopedStateStore.createKey("icon_resource", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<Integer> ATTR_FONT_SIZE = ScopedStateStore.createKey("fontSize", ScopedStateStore.Scope.PATH, Integer.class);
    public static final ScopedStateStore.Key<File> ATTR_OUTPUT_FOLDER = ScopedStateStore.createKey("outputFolder", ScopedStateStore.Scope.STEP, File.class);
    public static final ScopedStateStore.Key<String> ATTR_ERROR_LOG = ScopedStateStore.createKey("errorLog", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<String> ATTR_VECTOR_DRAWBLE_WIDTH = ScopedStateStore.createKey("vectorDrawableWidth", ScopedStateStore.Scope.STEP, String.class);
    public static final ScopedStateStore.Key<String> ATTR_VECTOR_DRAWBLE_HEIGHT = ScopedStateStore.createKey("vectorDrawableHeight", ScopedStateStore.Scope.STEP, String.class);
    public static final ScopedStateStore.Key<Integer> ATTR_ORIGINAL_WIDTH = ScopedStateStore.createKey("originalWidth", ScopedStateStore.Scope.STEP, Integer.class);
    public static final ScopedStateStore.Key<Integer> ATTR_ORIGINAL_HEIGHT = ScopedStateStore.createKey("originalHeight", ScopedStateStore.Scope.STEP, Integer.class);
    public static final ScopedStateStore.Key<Integer> ATTR_VECTOR_DRAWBLE_OPACTITY = ScopedStateStore.createKey("vectorDrawableOpacity", ScopedStateStore.Scope.STEP, Integer.class);
    public static final ScopedStateStore.Key<Boolean> ATTR_VECTOR_DRAWBLE_AUTO_MIRRORED = ScopedStateStore.createKey("vectorDrawableAutoMirror", ScopedStateStore.Scope.STEP, Boolean.class);
    public static final ScopedStateStore.Key<Boolean> ATTR_VALID_PREVIEW = ScopedStateStore.createKey("validPreview", ScopedStateStore.Scope.STEP, Boolean.class);
    private static final Logger LOG = Logger.getInstance(IconStep.class);
    private static final int CLIPART_ICON_SIZE = JBUI.scale((int)32);
    private static final int CLIPART_DIALOG_BORDER = JBUI.scale((int)10);
    private static final int DIALOG_HEADER = JBUI.scale((int)20);
    private static final String V11 = "V11";
    private static final String V9 = "V9";
    private final StringEvaluator myStringEvaluator;
    private final MergingUpdateQueue myUpdateQueue;
    private final Map<String, Map<String, BufferedImage>> myImageMap;
    private final ScopedStateStore.Key<TemplateEntry> myTemplateKey;
    private final ScopedStateStore.Key<SourceProvider> mySourceProviderKey;
    private AssetStudioAssetGenerator myAssetGenerator;
    private JPanel myPanel;
    private JRadioButton myImageRadioButton;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myTextRadioButton;
    private JButton myChooseClipart;
    private JCheckBox myTrimBlankSpace;
    private JTextField myText;
    private JComboBox myFontFamily;
    private TextFieldWithBrowseButton myImageFile;
    private ColorPanel myBackgroundColor;
    private ColorPanel myForegroundColor;
    private ImageComponent myMdpiPreview;
    private ImageComponent myHdpiPreview;
    private ImageComponent myXHdpiPreview;
    private JSlider myPaddingSlider;
    private ImageComponent myXXHdpiPreview;
    private JLabel myForegroundColorLabel;
    private JTextField myResourceNameField;
    private ImageComponent myV9XHdpiPreview;
    private ImageComponent myV9XXHdpiPreview;
    private ImageComponent myV9MdpiPreview;
    private ImageComponent myV9HdpiPreview;
    private ImageComponent myV11MdpiPreview;
    private ImageComponent myV11HdpiPreview;
    private ImageComponent myV11XHdpiPreview;
    private ImageComponent myV11XXHdpiPreview;
    private JTextField myPaddingTextField;
    private JPanel myPageBook;
    private JLabel mySourceSetLabel;
    private JComboBox mySourceSetComboBox;
    private JPanel myAssetSourceCardPanel;
    private String myDefaultName;

    public IconStep(ScopedStateStore.Key<TemplateEntry> templateKey, ScopedStateStore.Key<SourceProvider> sourceProviderKey, Disposable disposable) {
        super(disposable);
        this.$$$setupUI$$$();
        this.myStringEvaluator = new StringEvaluator();
        this.myImageMap = new ConcurrentHashMap<String, Map<String, BufferedImage>>();
        this.myTemplateKey = templateKey;
        this.mySourceProviderKey = sourceProviderKey;
        this.myUpdateQueue = new MergingUpdateQueue("asset.studio", 200, true, null, (Disposable)this, null, false);
        this.myImageFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myForegroundColor.setSelectedColor(Color.BLUE);
        this.myBackgroundColor.setSelectedColor(Color.WHITE);
        for (String font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.myFontFamily.addItem(new ComboBoxItemWithApiTag(font, font, 1, 1));
            if (!font.equals(this.myState.get(ATTR_FONT))) continue;
            this.myFontFamily.setSelectedIndex(this.myFontFamily.getItemCount() - 1);
        }
        this.myChooseClipart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IconStep.this.displayClipartDialog();
            }
        });
        this.setBodyComponent(this.myPanel);
    }

    private static Icon getClipartIcon(String clipartName) {
        if (StringUtil.isEmpty((String)clipartName)) {
            return null;
        }
        BufferedImage icon = null;
        try {
            icon = GraphicGenerator.getClipartIcon((String)clipartName);
        }
        catch (IOException e) {
            Logger.getInstance(IconStep.class).error((Throwable)e);
        }
        return new ImageIcon(icon, clipartName);
    }

    private static void show(JComponent ... components) {
        for (JComponent component : components) {
            component.setVisible(true);
            component.getParent().invalidate();
        }
    }

    private static void hide(JComponent ... components) {
        for (JComponent component : components) {
            component.setVisible(false);
            component.getParent().invalidate();
        }
    }

    private static void setIconOrClear(ImageComponent component, BufferedImage image) {
        if (image == null) {
            component.setIcon(null);
        } else {
            component.setIcon(new ImageIcon(image));
        }
    }

    private static BufferedImage getImage(Map<String, Map<String, BufferedImage>> map, String name) {
        Map<String, BufferedImage> images = map.get(name);
        if (images == null) {
            return null;
        }
        Collection<BufferedImage> values = images.values();
        return values.isEmpty() ? null : values.iterator().next();
    }

    private static BufferedImage getImage(Map<String, Map<String, BufferedImage>> map, String category, Density density) {
        String densityString = density.getResourceValue();
        Map<String, BufferedImage> images = map.get(category);
        if (images == null) {
            return null;
        }
        for (String key : images.keySet()) {
            if (!key.contains(densityString)) continue;
            return images.get(key);
        }
        return null;
    }

    private static String getResourceDirLabel(Module module, File directory) {
        if (module == null) {
            return directory.getName();
        }
        String filePath = module.getModuleFilePath();
        String parent = new File(filePath).getParent();
        String path = directory.getPath();
        return path.startsWith(parent) ? path.substring(parent.length() + 1) : directory.getName();
    }

    @Override
    public void init() {
        super.init();
        this.myAssetGenerator = new AssetStudioAssetGenerator(new ScopedStateStoreAdapter(this.myState));
        this.myState.put(ATTR_ASSET_TYPE, AssetStudioAssetGenerator.AssetType.LAUNCHER);
        String relativeTemplatePath = FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule", "root", "res", "mipmap-xhdpi", "ic_launcher.png"});
        this.myState.put(ATTR_IMAGE_PATH, new File(TemplateManager.getTemplateRootFolder(), relativeTemplatePath).getAbsolutePath());
        this.register(ATTR_OUTPUT_FOLDER, this.mySourceSetComboBox);
        this.register(ATTR_IMAGE_PATH, this.myImageFile);
        this.register(ATTR_TEXT, this.myText);
        this.register(ATTR_PADDING, this.myPaddingSlider);
        this.register(ATTR_PADDING, this.myPaddingTextField, new ScopedDataBinder.ComponentBinding<Integer, JTextField>(){

            @Override
            public void setValue(Integer newValue, JTextField component) {
                component.setText(newValue == null ? "" : String.valueOf(newValue));
            }

            @Override
            public Integer getValue(JTextField component) {
                try {
                    return Math.max(0, Math.min(Integer.parseInt(component.getText()), 100));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }

            @Override
            public void addActionListener(ActionListener listener, JTextField component) {
                component.addActionListener(listener);
            }

            @Override
            public Document getDocument(JTextField component) {
                return component.getDocument();
            }
        });
        this.register(ATTR_TRIM, this.myTrimBlankSpace);
        this.register(ATTR_FONT, this.myFontFamily);
        this.register((ScopedStateStore.Key)ATTR_SOURCE_TYPE, (Map)ImmutableMap.of((Object)this.myImageRadioButton, (Object)((Object)AssetStudioAssetGenerator.SourceType.IMAGE), (Object)this.myClipartRadioButton, (Object)((Object)AssetStudioAssetGenerator.SourceType.CLIPART), (Object)this.myTextRadioButton, (Object)((Object)AssetStudioAssetGenerator.SourceType.TEXT)));
        this.register(ATTR_FOREGROUND_COLOR, this.myForegroundColor);
        this.register(ATTR_BACKGROUND_COLOR, this.myBackgroundColor);
        this.register(ATTR_ASSET_NAME, this.myResourceNameField);
        this.register(ATTR_CLIPART_NAME, this.myChooseClipart, new ScopedDataBinder.ComponentBinding<String, JButton>(){

            @Override
            public void setValue(String newValue, JButton component) {
                component.setIcon(IconStep.getClipartIcon(newValue));
                component.setText(newValue);
            }
        });
    }

    private void updateDirectoryCombo() {
        boolean showLabelAndCombo;
        List<File> folders = this.getResourceFolders();
        File res = this.myState.get(ATTR_OUTPUT_FOLDER);
        if (!folders.isEmpty()) {
            if (res == null || !folders.contains(res)) {
                res = folders.get(0);
                this.myState.put(ATTR_OUTPUT_FOLDER, res);
            }
            showLabelAndCombo = folders.size() > 1;
            this.mySourceSetComboBox.removeAllItems();
            if (showLabelAndCombo) {
                ComboBoxItemWithApiTag selected = null;
                for (File directory : folders) {
                    ComboBoxItemWithApiTag item = new ComboBoxItemWithApiTag(directory, IconStep.getResourceDirLabel(this.getModule(), directory), 0, 0);
                    if (Objects.equal((Object)directory, (Object)res)) {
                        selected = item;
                    }
                    this.mySourceSetComboBox.addItem(item);
                }
                this.mySourceSetComboBox.setSelectedItem(selected);
            }
        } else {
            showLabelAndCombo = false;
        }
        this.mySourceSetComboBox.setVisible(showLabelAndCombo);
        this.mySourceSetLabel.setVisible(showLabelAndCombo);
    }

    private List<File> getResourceFolders() {
        SourceProvider provider = this.myState.get(this.mySourceProviderKey);
        if (provider == null) {
            return Collections.emptyList();
        }
        LinkedList dirs = Lists.newLinkedList();
        dirs.addAll(provider.getResDirectories());
        return dirs;
    }

    private <E> void register(ScopedStateStore.Key<E> key, Map<JRadioButton, E> buttonsToValues) {
        RadioButtonGroupBinding<E> binding = new RadioButtonGroupBinding<E>(buttonsToValues);
        for (JRadioButton button : buttonsToValues.keySet()) {
            this.register(key, button, binding);
        }
    }

    @Override
    public boolean isStepVisible() {
        TemplateMetadata templateMetadata;
        TemplateEntry templateEntry = this.myState.get(this.myTemplateKey);
        boolean isVisible = false;
        if (templateEntry != null && (templateMetadata = templateEntry.getMetadata()).getIconType() != null) {
            isVisible = true;
        }
        return isVisible;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        String name;
        AssetStudioAssetGenerator.AssetType assetType;
        super.deriveValues(modified);
        AssetStudioAssetGenerator.AssetType iconType = null;
        TemplateEntry templateEntry = this.myState.get(this.myTemplateKey);
        if (templateEntry != null) {
            iconType = templateEntry.getMetadata().getIconType();
        }
        this.finalizeAssetType(iconType);
        this.updateDirectoryCombo();
        this.myState.put(ATTR_ICON_RESOURCE, this.myState.get(ATTR_ASSET_NAME));
        AssetStudioAssetGenerator.SourceType sourceType = this.myState.get(ATTR_SOURCE_TYPE);
        if (sourceType != null) {
            switch (sourceType) {
                case IMAGE: {
                    ((CardLayout)this.myAssetSourceCardPanel.getLayout()).show(this.myAssetSourceCardPanel, "ImageCard");
                    IconStep.hide(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
                    break;
                }
                case CLIPART: {
                    ((CardLayout)this.myAssetSourceCardPanel.getLayout()).show(this.myAssetSourceCardPanel, "ClipartCard");
                    IconStep.show(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
                    break;
                }
                case TEXT: {
                    ((CardLayout)this.myAssetSourceCardPanel.getLayout()).show(this.myAssetSourceCardPanel, "TextCard");
                    IconStep.show(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
                    this.myFontFamily.setSelectedItem(this.myState.get(ATTR_FONT));
                }
            }
        }
        if ((assetType = this.myState.get(ATTR_ASSET_TYPE)) != null && ((name = this.myState.get(ATTR_ASSET_NAME)) == null || Objects.equal((Object)this.myDefaultName, (Object)name))) {
            this.myDefaultName = this.computeResourceName(assetType);
            this.myState.put(ATTR_ASSET_NAME, this.myDefaultName);
        }
        String assetTheme = this.myState.get(ATTR_ASSET_THEME);
        this.requestPreviewUpdate();
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        String assetName = this.myState.get(ATTR_ASSET_NAME);
        boolean canProceed = true;
        String error = null;
        if (StringUtil.isEmpty((String)assetName)) {
            canProceed = false;
            error = "Missing resource name";
        } else if (this.drawableExists(assetName)) {
            error = String.format("A drawable resource named %s already exists and will be overwritten.", assetName);
        }
        this.setErrorHtml(error);
        return canProceed;
    }

    private void requestPreviewUpdate() {
        this.myUpdateQueue.cancelAllUpdates();
        this.myUpdateQueue.queue(new Update("update"){

            public void run() {
                try {
                    if (IconStep.this.myAssetGenerator == null) {
                        return;
                    }
                    IconStep.this.myAssetGenerator.generateImages(IconStep.this.myImageMap, true, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IconStep.this.updatePreviewImages();
                        }
                    });
                }
                catch (AssetStudioAssetGenerator.ImageGeneratorException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IconStep.this.setErrorHtml(e.getMessage());
                        }
                    });
                }
            }
        });
    }

    private void updatePreviewImages() {
        AssetStudioAssetGenerator.AssetType assetType = this.myState.get(ATTR_ASSET_TYPE);
        if (assetType == null || this.myImageMap.isEmpty()) {
            return;
        }
        if (assetType.equals((Object)AssetStudioAssetGenerator.AssetType.NOTIFICATION)) {
            BufferedImage v9_mdpi = IconStep.getImage(this.myImageMap, V9, Density.MEDIUM);
            BufferedImage v9_hdpi = IconStep.getImage(this.myImageMap, V9, Density.HIGH);
            BufferedImage v9_xhdpi = IconStep.getImage(this.myImageMap, V9, Density.XHIGH);
            BufferedImage v9_xxhdpi = IconStep.getImage(this.myImageMap, V9, Density.XXHIGH);
            IconStep.setIconOrClear(this.myV9MdpiPreview, v9_mdpi);
            IconStep.setIconOrClear(this.myV9HdpiPreview, v9_hdpi);
            IconStep.setIconOrClear(this.myV9XHdpiPreview, v9_xhdpi);
            IconStep.setIconOrClear(this.myV9XXHdpiPreview, v9_xxhdpi);
            BufferedImage v11_mdpi = IconStep.getImage(this.myImageMap, V11, Density.MEDIUM);
            BufferedImage v11_hdpi = IconStep.getImage(this.myImageMap, V11, Density.HIGH);
            BufferedImage v11_xhdpi = IconStep.getImage(this.myImageMap, V11, Density.XHIGH);
            BufferedImage v11_xxhdpi = IconStep.getImage(this.myImageMap, V11, Density.XXHIGH);
            IconStep.setIconOrClear(this.myV11MdpiPreview, v11_mdpi);
            IconStep.setIconOrClear(this.myV11HdpiPreview, v11_hdpi);
            IconStep.setIconOrClear(this.myV11XHdpiPreview, v11_xhdpi);
            IconStep.setIconOrClear(this.myV11XXHdpiPreview, v11_xxhdpi);
        } else {
            BufferedImage mdpi = IconStep.getImage(this.myImageMap, Density.MEDIUM.getResourceValue());
            BufferedImage hdpi = IconStep.getImage(this.myImageMap, Density.HIGH.getResourceValue());
            BufferedImage xhdpi = IconStep.getImage(this.myImageMap, Density.XHIGH.getResourceValue());
            BufferedImage xxhdpi = IconStep.getImage(this.myImageMap, Density.XXHIGH.getResourceValue());
            IconStep.setIconOrClear(this.myMdpiPreview, mdpi);
            IconStep.setIconOrClear(this.myHdpiPreview, hdpi);
            IconStep.setIconOrClear(this.myXHdpiPreview, xhdpi);
            IconStep.setIconOrClear(this.myXXHdpiPreview, xxhdpi);
        }
        ((CardLayout)this.myPageBook.getLayout()).show(this.myPageBook, assetType == AssetStudioAssetGenerator.AssetType.NOTIFICATION ? "versions" : "DPI");
    }

    private void displayClipartDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        final JDialog dialog = new JDialog(window, Dialog.ModalityType.DOCUMENT_MODAL);
        FlowLayout layout = new FlowLayout();
        dialog.getRootPane().setLayout(layout);
        int count = 0;
        Iterator iter = GraphicGenerator.getResourcesNames((String)"images/clipart/big/", (String)".png");
        while (iter.hasNext()) {
            final String name = (String)iter.next();
            try {
                JButton btn = new JButton();
                btn.setIcon(new ImageIcon(GraphicGenerator.getClipartIcon((String)name)));
                Dimension d = new Dimension(CLIPART_ICON_SIZE, CLIPART_ICON_SIZE);
                btn.setMaximumSize(d);
                btn.setPreferredSize(d);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IconStep.this.myState.put(ATTR_CLIPART_NAME, name);
                        dialog.setVisible(false);
                    }
                });
                dialog.getRootPane().add(btn);
                ++count;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        int size = (int)(Math.sqrt(count) + 1.0) * (CLIPART_ICON_SIZE + layout.getHgap()) + CLIPART_DIALOG_BORDER * 2;
        dialog.setSize(size, size + DIALOG_HEADER);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    public void finalizeAssetType(AssetStudioAssetGenerator.AssetType type) {
        this.myState.put(ATTR_ASSET_TYPE, type);
    }

    private String computeResourceName(AssetStudioAssetGenerator.AssetType assetType) {
        String nameExpression;
        String resourceName = null;
        TemplateEntry templateEntry = this.myState.get(this.myTemplateKey);
        if (templateEntry != null && !StringUtil.isEmpty((String)(nameExpression = templateEntry.getMetadata().getIconName()))) {
            Set<ScopedStateStore.Key> allKeys = this.myState.getAllKeys();
            HashMap parameters = Maps.newHashMapWithExpectedSize((int)allKeys.size());
            for (ScopedStateStore.Key key : allKeys) {
                parameters.put(key.name, this.myState.get(key));
            }
            resourceName = this.myStringEvaluator.evaluate(nameExpression, parameters);
        }
        if (resourceName == null) {
            resourceName = String.format(assetType.getDefaultNameFormat(), "name");
        }
        if (this.drawableExists(resourceName) && assetType != AssetStudioAssetGenerator.AssetType.LAUNCHER) {
            int i = 2;
            while (this.drawableExists(resourceName + Integer.toString(i))) {
                ++i;
            }
            resourceName = resourceName + Integer.toString(i);
        }
        return resourceName;
    }

    public void createAssets() {
        if (this.isStepVisible()) {
            File destination = this.myState.get(ATTR_OUTPUT_FOLDER);
            assert (destination != null);
            this.myAssetGenerator.outputImagesIntoVariantRoot(destination.getParentFile());
        }
    }

    private boolean drawableExists(String resourceName) {
        File resDir = this.myState.get(ATTR_OUTPUT_FOLDER);
        if (resDir != null) {
            return Parameter.existsResourceFile(resDir, ResourceFolderType.DRAWABLE, resourceName);
        }
        return Parameter.existsResourceFile(this.getModule(), ResourceType.DRAWABLE, resourceName);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myImageRadioButton;
    }

    @Override
    public String getStepName() {
        return "Asset Studio";
    }

    @Override
    protected String getStepTitle() {
        return "Asset Studio";
    }

    @Override
    protected String getStepDescription() {
        return null;
    }

    @Override
    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ImageComponent imageComponent;
        ImageComponent imageComponent2;
        ImageComponent imageComponent3;
        ImageComponent imageComponent4;
        ImageComponent imageComponent5;
        ImageComponent imageComponent6;
        ImageComponent imageComponent7;
        ImageComponent imageComponent8;
        ImageComponent imageComponent9;
        ImageComponent imageComponent10;
        ImageComponent imageComponent11;
        ImageComponent imageComponent12;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JSlider jSlider;
        JComboBox jComboBox;
        JLabel jLabel;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        JLabel jLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JButton jButton;
        JComboBox jComboBox2;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JTextField jTextField3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Resource name:");
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        this.myResourceNameField = jTextField3 = new JTextField();
        jTextField3.setText("");
        jPanel4.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(11, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 24), null));
        this.myAssetSourceCardPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, "ImageCard");
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Image file:");
        jPanel5.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, new Dimension(120, -1), null));
        this.myImageFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 1, 1, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, "TextCard");
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Text:");
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myText = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Font face:");
        jPanel6.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        this.myFontFamily = jComboBox2 = new JComboBox();
        jPanel6.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, "ClipartCard");
        JLabel jLabel7 = new JLabel();
        jLabel7.setVerticalAlignment(1);
        jLabel7.setText("Clipart:");
        jPanel7.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, new Dimension(120, -1), null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myChooseClipart = jButton = new JButton();
        jButton.setText("Choose...");
        jPanel7.add((Component)jButton, new GridConstraints(0, 1, 1, 2, 1, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Asset");
        jPanel4.add((Component)titledSeparator, new GridConstraints(6, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Foreground:");
        jPanel4.add((Component)jLabel8, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel4.add((Component)jPanel8, new GridConstraints(7, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClipartRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Clipart");
        jPanel8.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myTextRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Text");
        jPanel8.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Image");
        jPanel8.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myForegroundColorLabel = jLabel2 = new JLabel();
        jLabel2.setText("Foreground color:");
        jPanel4.add((Component)jLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        this.myForegroundColor = colorPanel2 = new ColorPanel();
        jPanel4.add((Component)colorPanel2, new GridConstraints(8, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Background color:");
        jPanel4.add((Component)jLabel9, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        this.myBackgroundColor = colorPanel = new ColorPanel();
        jPanel4.add((Component)colorPanel, new GridConstraints(9, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.mySourceSetLabel = jLabel = new JLabel();
        jLabel.setText("Target directory:");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        this.mySourceSetComboBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Layout");
        jPanel4.add((Component)titledSeparator2, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Padding:");
        jPanel4.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel9, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPaddingSlider = jSlider = new JSlider();
        jSlider.setValue(0);
        jSlider.setMinimum(0);
        jSlider.setMaximum(100);
        jPanel9.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myPaddingTextField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jTextField.setHorizontalAlignment(0);
        jPanel9.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        this.myTrimBlankSpace = jCheckBox = new JCheckBox();
        jCheckBox.setText("Trim surrounding blank space");
        jPanel4.add((Component)jCheckBox, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPageBook = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, "versions");
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Older Versions");
        jPanel10.add((Component)jLabel11, new GridConstraints(2, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("API 11+");
        jPanel10.add((Component)jLabel12, new GridConstraints(4, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        this.myV9XHdpiPreview = imageComponent12 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent12), new GridConstraints(1, 2, 1, 1, 0, 0, 3, 1, new Dimension(32, 50), new Dimension(32, 50), null));
        this.myV9XXHdpiPreview = imageComponent11 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent11), new GridConstraints(1, 3, 1, 1, 0, 0, 3, 1, new Dimension(48, 75), new Dimension(48, 75), null));
        this.myV9MdpiPreview = imageComponent10 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent10), new GridConstraints(1, 0, 1, 1, 0, 0, 3, 1, new Dimension(16, 25), new Dimension(16, 25), null));
        this.myV9HdpiPreview = imageComponent9 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent9), new GridConstraints(1, 1, 1, 1, 0, 0, 3, 1, new Dimension(24, 38), new Dimension(24, 38), null));
        this.myV11XHdpiPreview = imageComponent8 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent8), new GridConstraints(3, 2, 1, 1, 0, 0, 3, 3, new Dimension(48, 48), new Dimension(48, 48), null));
        this.myV11XXHdpiPreview = imageComponent7 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent7), new GridConstraints(3, 3, 1, 1, 0, 0, 3, 3, new Dimension(72, 72), new Dimension(72, 72), null));
        this.myV11MdpiPreview = imageComponent6 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent6), new GridConstraints(3, 0, 1, 1, 0, 0, 3, 3, new Dimension(24, 24), new Dimension(24, 24), null));
        this.myV11HdpiPreview = imageComponent5 = new ImageComponent();
        jPanel10.add((Component)((Object)imageComponent5), new GridConstraints(3, 1, 1, 1, 0, 0, 3, 3, new Dimension(36, 36), new Dimension(36, 36), null));
        Spacer spacer7 = new Spacer();
        jPanel10.add((Component)spacer7, new GridConstraints(5, 3, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel10.add((Component)spacer8, new GridConstraints(0, 3, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel11, "DPI");
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("MDPI");
        jPanel11.add((Component)jLabel13, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel11.add((Component)spacer9, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("XHDPI");
        jPanel11.add((Component)jLabel14, new GridConstraints(4, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myMdpiPreview = imageComponent4 = new ImageComponent();
        jPanel11.add((Component)((Object)imageComponent4), new GridConstraints(1, 0, 1, 1, 0, 0, 1, 3, new Dimension(48, 48), new Dimension(48, 48), null));
        this.myXHdpiPreview = imageComponent3 = new ImageComponent();
        jPanel11.add((Component)((Object)imageComponent3), new GridConstraints(3, 0, 1, 1, 0, 0, 1, 3, new Dimension(96, 96), new Dimension(96, 96), null));
        this.myHdpiPreview = imageComponent2 = new ImageComponent();
        jPanel11.add((Component)((Object)imageComponent2), new GridConstraints(1, 1, 1, 1, 0, 0, 1, 3, new Dimension(72, 72), new Dimension(72, 72), null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("HDPI");
        jPanel11.add((Component)jLabel15, new GridConstraints(2, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myXXHdpiPreview = imageComponent = new ImageComponent();
        jPanel11.add((Component)((Object)imageComponent), new GridConstraints(3, 1, 1, 1, 0, 0, 1, 3, new Dimension(144, 144), new Dimension(144, 144), null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("XXHDPI");
        jPanel11.add((Component)jLabel16, new GridConstraints(4, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel11.add((Component)spacer10, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer11 = new Spacer();
        jPanel3.add((Component)spacer11, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 1, null, new Dimension(36, -1), null));
        Spacer spacer12 = new Spacer();
        jPanel3.add((Component)spacer12, new GridConstraints(2, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer13 = new Spacer();
        jPanel3.add((Component)spacer13, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 64), null, 1));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

