/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;

public class ImportUIUtil {
    private ImportUIUtil() {
    }

    public static String formatElementListString(Iterable<String> values, String oneElementMessage, String twoOrThreeElementsMessage, String moreThenThreeElementsMessage) {
        int size = Iterables.size(values);
        if (size <= 1) {
            return String.format(oneElementMessage, Iterables.getFirst(values, (Object)"<validation error>"));
        }
        if (size <= 3) {
            return String.format(twoOrThreeElementsMessage, ImportUIUtil.atMostTwo(values, size), Iterables.getLast(values));
        }
        return String.format(moreThenThreeElementsMessage, ImportUIUtil.atMostTwo(values, size), size - 2);
    }

    private static String atMostTwo(Iterable<String> names, int size) {
        return Joiner.on((String)", ").join(Iterables.limit(names, (int)Math.min(size - 1, 2)));
    }

    public static String makeHtmlString(String templateDescription) {
        if (!StringUtil.isEmpty((String)templateDescription) && !templateDescription.startsWith("<html>")) {
            templateDescription = String.format("<html>%1$s</html>", templateDescription.trim());
        }
        return templateDescription;
    }

    static String getRelativePath(VirtualFile baseFile, VirtualFile file) {
        if (file == null) {
            return "";
        }
        String path = file.getPath();
        if (baseFile == null) {
            return path;
        }
        if (file.equals(baseFile)) {
            return ".";
        }
        if (!baseFile.isDirectory()) {
            return ImportUIUtil.getRelativePath(baseFile.getParent(), file);
        }
        String basePath = baseFile.getPath();
        if (path.startsWith(basePath + "/")) {
            return path.substring(basePath.length() + 1);
        }
        if (file.getFileSystem().equals(baseFile.getFileSystem())) {
            StringBuilder builder = new StringBuilder(basePath.length());
            String prefix = Strings.commonPrefix((CharSequence)path, (CharSequence)basePath);
            if (!prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.lastIndexOf("/") + 1);
            }
            if (!path.startsWith(basePath)) {
                Iterable segments = Splitter.on((String)"/").split((CharSequence)basePath.substring(prefix.length()));
                Joiner.on((String)"/").appendTo(builder, Iterables.transform((Iterable)segments, (Function)Functions.constant((Object)"..")));
                builder.append("/");
            }
            builder.append(path.substring(prefix.length()));
            return builder.toString();
        }
        return path;
    }
}

