/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.AbstractModuleTemplate;
import com.android.tools.idea.npw.ChooseTemplateStep;
import com.android.tools.idea.npw.ImportSourceModulePath;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.npw.NewModuleWizardState;
import com.android.tools.idea.npw.WizardPath;
import com.android.tools.idea.npw.WrapArchiveWizardPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.options.ConfigurationException;
import icons.AndroidIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class LegacyPathWrapper
implements NewModuleDynamicPath {
    private final NewModuleWizardState myWizardState;
    private final WizardPath myWizardPath;
    private final List<ModuleWizardStep> mySteps;
    private final Iterable<ModuleTemplate> myTemplates;
    private DynamicWizard myWizard;
    private int myCurrentStep;

    public LegacyPathWrapper(NewModuleWizardState wizardState, WizardPath wizardPath) {
        this.myTemplates = LegacyPathWrapper.getModuleTemplates(wizardPath);
        this.myWizardState = wizardState;
        this.myWizardPath = wizardPath;
        this.mySteps = ImmutableList.copyOf(this.myWizardPath.getSteps());
    }

    private static boolean isStepValid(ModuleWizardStep currentStep) {
        if (currentStep == null) {
            return true;
        }
        try {
            return currentStep.validate();
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    static Iterable<ModuleTemplate> getModuleTemplates(WizardPath wizardPath) {
        Collection<ChooseTemplateStep.MetadataListItem> templates = wizardPath.getBuiltInTemplates();
        if (wizardPath instanceof ImportSourceModulePath) {
            ChooseTemplateStep.MetadataListItem template = (ChooseTemplateStep.MetadataListItem)Iterables.getFirst(templates, null);
            assert (template != null);
            LegacyModuleTemplate importEclipse = new LegacyModuleTemplate(template, "Import Eclipse ADT Project", "Import an existing Eclipse ADT project as a module", AndroidIcons.ModuleTemplates.EclipseModule);
            LegacyModuleTemplate importGradle = new LegacyModuleTemplate(template, "Import Gradle Project", "Import an existing Gradle project as a module", AndroidIcons.ModuleTemplates.GradleModule);
            return ImmutableList.of((Object)importGradle, (Object)importEclipse);
        }
        if (wizardPath instanceof WrapArchiveWizardPath) {
            ChooseTemplateStep.MetadataListItem template = (ChooseTemplateStep.MetadataListItem)Iterables.getFirst(templates, null);
            assert (template != null);
            return Collections.singleton(new LegacyModuleTemplate(template, "Import .JAR/.AAR Package", "Import an existing JAR or AAR package as a new project module", AndroidIcons.ModuleTemplates.Android));
        }
        ImmutableList.Builder templatesBuilder = ImmutableList.builder();
        for (ChooseTemplateStep.MetadataListItem template : templates) {
            templatesBuilder.add((Object)new LegacyModuleTemplate(template, null));
        }
        return templatesBuilder.build();
    }

    @Override
    public void onPathStarted(boolean fromBeginning) {
        if (fromBeginning) {
            ModuleTemplate moduleTemplate = this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            if (moduleTemplate instanceof LegacyModuleTemplate) {
                this.myWizardState.setTemplateLocation(((LegacyModuleTemplate)moduleTemplate).getLocation());
            }
            this.myCurrentStep = this.findNext(-1, 1);
        } else {
            this.myCurrentStep = this.findNext(this.mySteps.size(), -1);
        }
        this.updateWizard();
    }

    private int findNext(int currentStep, int direction) {
        boolean isWithinBounds;
        int stepCount = this.mySteps.size();
        do {
            boolean bl = isWithinBounds = (currentStep += direction) >= 0 && currentStep < stepCount;
        } while (isWithinBounds && !this.myWizardPath.isStepVisible(this.mySteps.get(currentStep)));
        return !isWithinBounds ? -1 : currentStep;
    }

    public ModuleWizardStep getCurrentStep() {
        return this.myCurrentStep < 0 ? null : this.mySteps.get(this.myCurrentStep);
    }

    public List<ModuleWizardStep> getAllSteps() {
        return this.mySteps;
    }

    @Override
    public boolean hasNext() {
        return this.findNext(this.myCurrentStep, 1) >= 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.findNext(this.myCurrentStep, -1) >= 0;
    }

    @Override
    public boolean canGoPrevious() {
        return true;
    }

    @Override
    public boolean canGoNext() {
        return LegacyPathWrapper.isStepValid(this.getCurrentStep()) && this.hasNext();
    }

    @Override
    public boolean containsStep(String stepName, boolean visibleOnly) {
        for (ModuleWizardStep step : this.mySteps) {
            if (!stepName.equals(step.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void navigateToNamedStep(String stepName, boolean requireVisible) {
        for (ModuleWizardStep step : this.mySteps) {
            if (!stepName.equals(step.getName())) continue;
            this.myCurrentStep = this.mySteps.indexOf(step);
            this.updateWizard();
            return;
        }
    }

    @Override
    public boolean isPathVisible() {
        ModuleTemplate moduleTemplate = this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        return moduleTemplate != null && Iterables.contains(this.myTemplates, (Object)moduleTemplate);
    }

    @Override
    public int getVisibleStepCount() {
        int count = 0;
        for (ModuleWizardStep step : this.mySteps) {
            if (!this.myWizardPath.isStepVisible(step)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void attachToWizard(DynamicWizard dynamicWizard) {
        this.myWizard = dynamicWizard;
    }

    @Override
    public DynamicWizard getWizard() {
        return this.myWizard;
    }

    @Override
    public boolean isPathRequired() {
        return true;
    }

    @Override
    public Step next() {
        return this.navigate(1);
    }

    private Step navigate(int direction) {
        this.myCurrentStep = this.findNext(this.myCurrentStep, direction);
        if (this.myCurrentStep < 0) {
            return null;
        }
        assert (this.myCurrentStep >= 0);
        this.updateWizard();
        return (Step)this.mySteps.get(this.myCurrentStep);
    }

    @Override
    public Step previous() {
        return this.navigate(-1);
    }

    @Override
    public boolean performFinishingActions() {
        this.myWizardPath.createModule();
        return true;
    }

    @Override
    public void updateCurrentStep() {
    }

    @Override
    public void setErrorHtml(String errorMessage) {
    }

    @Override
    public Iterable<ModuleTemplate> getModuleTemplates() {
        return this.myTemplates;
    }

    public void updateWizard() {
        if (this.isPathVisible()) {
            for (ModuleWizardStep step : this.myWizardPath.getSteps()) {
                step.updateStep();
            }
            this.myWizard.updateButtons(true, this.canGoNext(), true, !this.canGoNext() && LegacyPathWrapper.isStepValid(this.getCurrentStep()));
        }
    }

    @Override
    public boolean readyToLeavePath() {
        return true;
    }

    private static final class LegacyModuleTemplate
    extends AbstractModuleTemplate {
        private final File myLocation;

        public LegacyModuleTemplate(ChooseTemplateStep.MetadataListItem listItem, String name, String description, Icon icon) {
            super(name, description, null, icon);
            this.myLocation = listItem.getTemplateFile();
        }

        public LegacyModuleTemplate(ChooseTemplateStep.MetadataListItem listItem, Icon icon) {
            this(listItem, listItem.toString(), listItem.getDescription(), icon);
        }

        public File getLocation() {
            return this.myLocation;
        }

        @Override
        public void updateWizardState(ScopedStateStore state) {
        }
    }
}

