/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.LegacyPathWrapper;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.npw.NewModuleDynamicPathFactory;
import com.android.tools.idea.npw.TemplateWizardModuleBuilder;
import com.android.tools.idea.npw.WizardPath;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class LegacyWizardPathProvider
implements NewModuleDynamicPathFactory {
    @Override
    public Collection<NewModuleDynamicPath> createWizardPaths(Project project, Disposable disposable) {
        LegacyWizardModuleBuilder builder = new LegacyWizardModuleBuilder(project, disposable);
        Collection<LegacyPathWrapper> wrappers = builder.getWrappers();
        return ImmutableSet.copyOf(wrappers);
    }

    private static class LegacyWizardModuleBuilder
    extends TemplateWizardModuleBuilder {
        private final Collection<LegacyPathWrapper> myWrappers = this.wrapPaths();

        public LegacyWizardModuleBuilder(Project project, Disposable disposable) {
            super(null, null, project, null, (List<ModuleWizardStep>)Lists.newLinkedList(), disposable, false);
        }

        private Collection<LegacyPathWrapper> wrapPaths() {
            LinkedList wrappers = ContainerUtil.newLinkedList();
            for (WizardPath wizardPath : this.getPaths()) {
                if (wizardPath.getClass().getAnnotation(Migrated.class) != null) continue;
                wrappers.add(new LegacyPathWrapper(this.myWizardState, wizardPath));
            }
            return wrappers;
        }

        public Collection<LegacyPathWrapper> getWrappers() {
            return this.myWrappers;
        }

        @Override
        public void update() {
            super.update();
            if (this.myWrappers != null) {
                for (LegacyPathWrapper wrapper : this.myWrappers) {
                    if (!wrapper.isPathVisible()) continue;
                    wrapper.updateWizard();
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Migrated {
    }
}

