/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.sdklib.BuildToolInfo;
import com.android.tools.idea.npw.WizardPath;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

@Deprecated
public class NewModuleWizardState
extends TemplateWizardState {
    private static final Logger LOG = Logger.getInstance(NewModuleWizardState.class);
    public static final String ATTR_CREATE_ACTIVITY = "createActivity";
    public static final String ATTR_PROJECT_LOCATION = "projectLocation";
    public static final String APP_NAME = "app";
    public static final String LIB_NAME = "lib";
    public static final String MODULE_IMPORT_NAME = "Import Existing Project";
    public static final String ARCHIVE_IMPORT_NAME = "Import .JAR or .AAR Package";
    protected final TemplateWizardState myActivityTemplateState;
    private Map<String, VirtualFile> myModulesToImport;
    private Map<String, WizardPath> myTemplateToPathMap = new HashMap<String, WizardPath>();
    private WizardPath myActiveWizardPath;
    private WizardPath myDefaultPath;

    public NewModuleWizardState() {
        this.myActivityTemplateState = new TemplateWizardState();
        this.myHidden.add(ATTR_PROJECT_LOCATION);
        this.myHidden.remove("isLibraryProject");
        this.put("isLauncher", false);
        this.put("createIcons", false);
        this.put("isNewProject", true);
        this.put(ATTR_CREATE_ACTIVITY, true);
        this.put("isLibraryProject", false);
        this.putSdkDependentParams();
        try {
            this.myActivityTemplateState.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
        }
        this.myActivityTemplateState.myHidden.add("packageName");
        this.myActivityTemplateState.myHidden.add("appTitle");
        this.myActivityTemplateState.myHidden.add("minApi");
        this.myActivityTemplateState.myHidden.add("minApiLevel");
        this.myActivityTemplateState.myHidden.add("targetApi");
        this.myActivityTemplateState.myHidden.add("targetApiString");
        this.myActivityTemplateState.myHidden.add("buildApi");
        this.myActivityTemplateState.myHidden.add("buildApiString");
        this.myActivityTemplateState.myHidden.add("copyIcons");
        this.myActivityTemplateState.myHidden.add("isLauncher");
        this.myActivityTemplateState.myHidden.add("parentActivityClass");
        this.myActivityTemplateState.myHidden.add("activityTitle");
        this.updateParameters();
    }

    public static boolean isAndroidTemplate(TemplateMetadata templateMetadata) {
        return templateMetadata != null && templateMetadata.getParameter("minApi") != null;
    }

    public void setDefaultWizardPath(WizardPath defaultPath) {
        this.myDefaultPath = defaultPath;
    }

    public void templateChanged(Project project, String templateName) {
        this.setTemplateName(templateName);
        if (templateName.equals("Android Library")) {
            this.put("isLibraryProject", true);
            this.put("isLauncher", false);
            this.put("createIcons", false);
            this.myHidden.add("createIcons");
        } else if (templateName.equals("Android Application")) {
            this.put("isLibraryProject", false);
            this.put("isLauncher", true);
            this.put("createIcons", true);
            this.myHidden.remove("createIcons");
        }
        if (this.myHidden.contains("appTitle")) {
            assert (project != null) : "Cannot be adding a module to a unknown project";
            this.put("appTitle", project.getName());
        }
    }

    private void setTemplateName(String templateName) {
        this.myActiveWizardPath = this.myTemplateToPathMap.get(templateName);
    }

    public WizardPath getActiveWizardPath() {
        return this.myActiveWizardPath != null ? this.myActiveWizardPath : this.myDefaultPath;
    }

    public void putSdkDependentParams() {
        BuildToolInfo buildTool;
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        BuildToolInfo buildToolInfo = buildTool = sdkData != null ? sdkData.getLatestBuildTool() : null;
        if (buildTool != null) {
            this.put("buildToolsVersion", buildTool.getRevision().toString());
        }
        if (sdkData != null) {
            this.put("sdkDir", FileUtil.toSystemIndependentName((String)sdkData.getPath()));
        }
    }

    public TemplateWizardState getActivityTemplateState() {
        return this.myActivityTemplateState;
    }

    public void updateDependencies() {
        HashSet dependencySet = new HashSet();
        if (this.myParameters.containsKey("dependencyList")) {
            dependencySet.addAll((Collection)this.get("dependencyList"));
        }
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        if (this.get("usesFragments") != null && Boolean.parseBoolean(this.get("usesFragments").toString()) || this.get("usesNavigationDrawer") != null && Boolean.parseBoolean(this.get("usesNavigationDrawer").toString())) {
            dependencySet.add(urlManager.getLibraryCoordinate("support-v4"));
        }
        if (this.get("usesActionBar") != null && Boolean.parseBoolean(this.get("usesActionBar").toString())) {
            dependencySet.add(urlManager.getLibraryCoordinate("appcompat-v7"));
        }
        if (this.get("usesGridLayout") != null && Boolean.parseBoolean(this.get("usesGridLayout").toString())) {
            dependencySet.add(urlManager.getLibraryCoordinate("gridlayout-v7"));
        }
        this.put("dependencyList", new LinkedList(dependencySet));
    }

    public void updateParameters() {
        this.put("copyIcons", !Boolean.parseBoolean(this.get("createIcons").toString()));
        this.copyParameters(this.myParameters, this.myActivityTemplateState.myParameters, "packageName", "appTitle", "minApi", "minApiLevel", "targetApi", "targetApiString", "buildApiString", "buildApi", "copyIcons", "isNewProject", "isLauncher", ATTR_CREATE_ACTIVITY, "createIcons", "isGradle", "topOut", "projectOut", "srcOut", "testOut", "resOut", "manifestOut");
    }

    protected void copyParameters(Map<String, Object> from, Map<String, Object> to, String ... keys) {
        for (String key : keys) {
            to.put(key, from.get(key));
        }
    }

    public Map<String, VirtualFile> getModulesToImport() {
        return this.myModulesToImport;
    }

    public void setModulesToImport(Map<String, VirtualFile> modulesToImport) {
        this.myModulesToImport = modulesToImport;
    }

    public void associateTemplateWithPath(String templateName, WizardPath path) {
        this.myTemplateToPathMap.put(templateName, path);
        if (this.myActiveWizardPath == null) {
            this.myActiveWizardPath = path;
        }
    }

    public boolean isOnDefaultWizardPath() {
        return this.myActiveWizardPath == this.myDefaultPath;
    }
}

