/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.npw.ChooseSourceSetStep;
import com.android.tools.idea.npw.ChooseTemplateStep;
import com.android.tools.idea.npw.RasterAssetSetStep;
import com.android.tools.idea.npw.TemplateParameterStep;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.template.TemplateWizard;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;

@Deprecated
public class NewTemplateObjectWizard
extends TemplateWizard
implements TemplateWizardStep.UpdateListener,
ChooseTemplateStep.TemplateChangeListener,
ChooseSourceSetStep.SourceProviderSelectedListener {
    private static final Logger LOG = Logger.getInstance((String)("#" + NewTemplateObjectWizard.class.getName()));
    protected TemplateWizardState myWizardState;
    protected Project myProject;
    protected Module myModule;
    private String myTemplateCategory;
    private String myTemplateName;
    private VirtualFile myTargetFolder;
    private Set<String> myExcluded;
    RasterAssetSetStep myAssetSetStep;
    ChooseTemplateStep myChooseTemplateStep;
    private List<SourceProvider> mySourceProviders;
    private AndroidModel myAndroidModel;
    protected TemplateParameterStep myTemplateParameterStep;
    protected ChooseSourceSetStep myChooseSourceSetStep;
    private File myTemplateFile;

    public NewTemplateObjectWizard(Project project, Module module, VirtualFile invocationTarget, String templateCategory) {
        this(project, module, invocationTarget, templateCategory, null, null);
        this.init();
    }

    public NewTemplateObjectWizard(Project project, Module module, VirtualFile invocationTarget, String title, File templateFile) {
        this(project, module, invocationTarget, null, title, null);
        if (templateFile != null) {
            this.myWizardState.setTemplateLocation(templateFile);
            this.myTemplateFile = templateFile;
        }
        this.init();
    }

    public NewTemplateObjectWizard(Project project, Module module, VirtualFile invocationTarget, String title, List<File> templateFiles) {
        this(project, module, invocationTarget, null, title, null);
        this.init();
        this.myChooseTemplateStep.setListData(ChooseTemplateStep.getTemplateList(this.myWizardState, templateFiles, null));
    }

    private NewTemplateObjectWizard(Project project, Module module, VirtualFile invocationTarget, String templateCategory, String templateName, Set<String> excluded) {
        super("New " + (templateName != null ? templateName : templateCategory), project);
        this.myProject = project;
        this.myModule = module;
        this.myTemplateCategory = templateCategory;
        this.myTemplateName = templateName;
        this.myTargetFolder = invocationTarget == null ? null : (invocationTarget.isDirectory() ? invocationTarget : invocationTarget.getParent());
        this.myExcluded = excluded;
        this.myWizardState = new TemplateWizardState();
    }

    @Override
    protected void init() {
        File templateFile;
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        assert (platform != null);
        AndroidVersion version = platform.getTarget().getVersion();
        this.myWizardState.put("buildApi", version.getFeatureLevel());
        this.myWizardState.put("buildApiString", TemplateMetadata.getBuildApiString(version));
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            this.myAndroidModel = androidModel;
            this.mySourceProviders = IdeaSourceProvider.getSourceProvidersForFile(facet, this.myTargetFolder, facet.getMainSourceProvider());
            SourceProvider sourceProvider = this.mySourceProviders.get(0);
            this.selectSourceProvider(sourceProvider, androidModel);
        }
        int minSdkVersion = moduleInfo.getMinSdkVersion().getFeatureLevel();
        String minSdkName = moduleInfo.getMinSdkVersion().getApiString();
        this.myWizardState.put("minApi", minSdkName);
        this.myWizardState.put("minApiLevel", minSdkVersion);
        this.myWizardState.put("targetApi", moduleInfo.getTargetSdkVersion().getFeatureLevel());
        this.myWizardState.put("targetApiString", moduleInfo.getTargetSdkVersion().getApiString());
        this.myWizardState.put("isLibraryProject", facet.isLibraryProject());
        try {
            this.myWizardState.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getDebugKeystore(facet)));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            this.myWizardState.put("debugKeystoreSha1", "");
        }
        File file = templateFile = this.myTemplateFile != null ? this.myTemplateFile : TemplateManager.getInstance().getTemplateFile(this.myTemplateCategory, this.myTemplateName);
        if (this.myTemplateName == null || templateFile == null) {
            this.myChooseTemplateStep = new ChooseTemplateStep(this.myWizardState, this.myTemplateCategory, this.myProject, this.myModule, null, this, this, this.myExcluded);
            this.mySteps.add(this.myChooseTemplateStep);
        } else {
            this.myWizardState.setTemplateLocation(templateFile);
        }
        if (this.mySourceProviders != null && this.mySourceProviders.size() != 1) {
            this.myChooseSourceSetStep = new ChooseSourceSetStep(this.myWizardState, this.myProject, this.myModule, null, this, this, this.mySourceProviders);
            this.mySteps.add(this.myChooseSourceSetStep);
        }
        this.myTemplateParameterStep = new TemplateParameterStep(this.myWizardState, this.myProject, this.myModule, null, this);
        this.mySteps.add(this.myTemplateParameterStep);
        this.myAssetSetStep = new RasterAssetSetStep(this.myWizardState, this.myProject, this.myModule, null, this, this.myTargetFolder);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myAssetSetStep);
        this.mySteps.add(this.myAssetSetStep);
        this.myAssetSetStep.setVisible(false);
        this.myWizardState.put("projectLocation", this.myProject.getBasePath());
        String moduleName = new File(this.myModule.getModuleFilePath()).getParentFile().getName();
        this.myWizardState.put("projectName", moduleName);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            super.init();
            Dimension preferredSize = this.getContentPanel().getPreferredSize();
            this.getContentPanel().setPreferredSize(new Dimension(Math.max(JBUI.scale((int)800), preferredSize.width), Math.max(JBUI.scale((int)640), preferredSize.height)));
        }
    }

    private void selectSourceProvider(SourceProvider sourceProvider, AndroidModel androidModel) {
        File aidlDir;
        File manifestDir;
        File resDir;
        File moduleDirPath = androidModel.getRootDirPath();
        File javaDir = NewTemplateObjectWizard.findSrcDirectory(sourceProvider);
        if (javaDir != null) {
            String javaPath = FileUtil.getRelativePath((File)moduleDirPath, (File)javaDir);
            if (javaPath != null) {
                javaPath = FileUtil.toSystemIndependentName((String)javaPath);
            }
            this.myWizardState.put("srcDir", javaPath);
        }
        if ((resDir = NewTemplateObjectWizard.findResDirectory(sourceProvider)) != null) {
            String resPath = FileUtil.getRelativePath((File)moduleDirPath, (File)resDir);
            if (resPath != null) {
                resPath = FileUtil.toSystemIndependentName((String)resPath);
            }
            this.myWizardState.put("resDir", resPath);
            this.myWizardState.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = NewTemplateObjectWizard.findManifestDirectory(sourceProvider)) != null) {
            String manifestPath = FileUtil.getRelativePath((File)moduleDirPath, (File)manifestDir);
            this.myWizardState.put("manifestDir", manifestPath);
            this.myWizardState.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = NewTemplateObjectWizard.findAidlDir(sourceProvider)) != null) {
            String aidlPath = FileUtil.getRelativePath((File)moduleDirPath, (File)aidlDir);
            this.myWizardState.put("aidlDir", aidlPath);
            this.myWizardState.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        String applicationPackageName = ManifestInfo.get(this.myModule, false).getPackage();
        String packageName = null;
        if (this.myTargetFolder != null && IdeaSourceProvider.containsFile(sourceProvider, VfsUtilCore.virtualToIoFile((VirtualFile)this.myTargetFolder)) && (packageName = NewTemplateObjectWizard.getPackageFromDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)this.myTargetFolder), sourceProvider, this.myModule, this.myWizardState)) != null && !packageName.equals(applicationPackageName)) {
            this.myWizardState.put("applicationPackage", applicationPackageName);
            this.myWizardState.myFinal.add("applicationPackage");
        }
        if (packageName == null) {
            packageName = applicationPackageName;
        } else {
            this.myWizardState.myHidden.add("packageName");
            this.myWizardState.myFinal.add("packageName");
            if (javaDir != null) {
                String packagePath = FileUtil.toSystemDependentName((String)packageName.replace('.', '/'));
                File packageRoot = new File(javaDir, packagePath);
                this.myWizardState.put("packageRoot", FileUtil.toSystemIndependentName((String)packageRoot.getPath()));
                this.myWizardState.myFinal.add("packageRoot");
            }
        }
        if (javaDir != null) {
            File srcOut = new File(javaDir, packageName.replace('.', File.separatorChar));
            this.myWizardState.put("srcOut", FileUtil.toSystemIndependentName((String)srcOut.getPath()));
        }
        this.myWizardState.put("packageName", packageName);
        this.myWizardState.put("sourceProviderName", sourceProvider.getName());
        this.myWizardState.setSourceProvider(sourceProvider);
    }

    public static File findSrcDirectory(SourceProvider sourceProvider) {
        Collection javaDirectories = sourceProvider.getJavaDirectories();
        return javaDirectories.isEmpty() ? null : (File)javaDirectories.iterator().next();
    }

    public static File findResDirectory(SourceProvider sourceProvider) {
        Collection resDirectories = sourceProvider.getResDirectories();
        File resDir = null;
        if (!resDirectories.isEmpty()) {
            resDir = (File)resDirectories.iterator().next();
        }
        return resDir;
    }

    public static File findAidlDir(SourceProvider sourceProvider) {
        Collection aidlDirectories = sourceProvider.getAidlDirectories();
        File resDir = null;
        if (!aidlDirectories.isEmpty()) {
            resDir = (File)aidlDirectories.iterator().next();
        }
        return resDir;
    }

    public static File findManifestDirectory(SourceProvider sourceProvider) {
        File manifestFile = sourceProvider.getManifestFile();
        File manifestDir = manifestFile.getParentFile();
        if (manifestDir != null) {
            return manifestDir;
        }
        return null;
    }

    public static String getPackageFromDirectory(File directory, SourceProvider sourceProvider, Module module, TemplateWizardState wizardState) {
        String packageName;
        File javaSourcePackageRoot;
        File javaDir = NewTemplateObjectWizard.findSrcDirectory(sourceProvider);
        File javaSourceRoot = javaDir == null ? new File(AndroidRootUtil.getModuleDirPath(module), FileUtil.toSystemDependentName((String)wizardState.getString("srcDir"))) : new File(javaDir.getPath());
        if (!FileUtil.isAncestor((File)javaSourceRoot, (File)(javaSourcePackageRoot = new File(directory.getPath())), (boolean)true)) {
            return null;
        }
        String relativePath = FileUtil.getRelativePath((File)javaSourceRoot, (File)javaSourcePackageRoot);
        String string = packageName = relativePath != null ? FileUtil.toSystemIndependentName((String)relativePath).replace('/', '.') : null;
        if (packageName == null || !AndroidUtils.isValidJavaPackageName(packageName)) {
            return null;
        }
        return packageName;
    }

    public void exclude(String templateName) {
        this.myExcluded.add(templateName);
    }

    public void createTemplateObject(final boolean openEditors) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    NewTemplateObjectWizard.this.myWizardState.populateDirectoryParameters();
                    NewTemplateObjectWizard.this.myWizardState.populateRelativePackage(NewTemplateObjectWizard.this.myModule);
                    File projectRoot = new File(NewTemplateObjectWizard.this.myProject.getBasePath());
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)NewTemplateObjectWizard.this.myModule);
                    VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
                    if (contentRoots.length > 0) {
                        VirtualFile rootDir = contentRoots[0];
                        File moduleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)rootDir);
                        NewTemplateObjectWizard.this.myWizardState.myTemplate.render(projectRoot, moduleRoot, NewTemplateObjectWizard.this.myWizardState.myParameters, NewTemplateObjectWizard.this.myProject);
                        if (NewTemplateObjectWizard.this.myAssetSetStep.isStepVisible()) {
                            NewTemplateObjectWizard.this.myAssetSetStep.createAssets(NewTemplateObjectWizard.this.myModule);
                        }
                        if (openEditors) {
                            TemplateUtils.openEditors(NewTemplateObjectWizard.this.myProject, NewTemplateObjectWizard.this.myWizardState.myTemplate.getFilesToOpen(), true);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public void createTemplateObject() {
        this.createTemplateObject(true);
    }

    @Override
    public void templateChanged(String templateName) {
        if (this.myChooseTemplateStep != null) {
            TemplateMetadata chosenTemplateMetadata = this.myChooseTemplateStep.getSelectedTemplateMetadata();
            this.updateAssetSetStep(chosenTemplateMetadata);
        }
    }

    protected void updateAssetSetStep(TemplateMetadata chosenTemplateMetadata) {
        if (chosenTemplateMetadata != null && chosenTemplateMetadata.getIconType() != null) {
            this.myAssetSetStep.finalizeAssetType(chosenTemplateMetadata.getIconType());
            this.myWizardState.put("iconName", chosenTemplateMetadata.getIconName());
            this.myAssetSetStep.setVisible(true);
        } else {
            this.myAssetSetStep.setVisible(false);
        }
    }

    @Override
    public void sourceProviderSelected(SourceProvider sourceProvider) {
        if (this.myAndroidModel != null) {
            this.selectSourceProvider(sourceProvider, this.myAndroidModel);
        }
    }

    protected boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        TemplateMetadata metadata = this.myWizardState.getTemplateMetadata();
        int minApi = this.myWizardState.getInt("minApiLevel");
        if (metadata != null && metadata.getMinSdk() > minApi) {
            ((TemplateWizardStep)this.getCurrentStepObject()).setErrorHtml("This template requires a minimum API level of " + metadata.getMinSdk());
            return false;
        }
        return true;
    }
}

