/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.assetstudiolib.ActionBarIconGenerator;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.resources.Density;
import com.android.tools.idea.npw.AssetStudioAssetGenerator;
import com.android.tools.idea.npw.CommonAssetSetStep;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.ui.ComboBoxItemWithApiTag;
import com.android.tools.idea.ui.ImageComponent;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class RasterAssetSetStep
extends CommonAssetSetStep {
    private static final Logger LOG = Logger.getInstance(RasterAssetSetStep.class);
    private static final int CLIPART_ICON_SIZE = JBUI.scale((int)32);
    private static final int CLIPART_DIALOG_BORDER = JBUI.scale((int)10);
    private static final int DIALOG_HEADER = JBUI.scale((int)20);
    public static final String ATTR_ICON_RESOURCE = "icon_resource";
    private static final String V11 = "V11";
    private static final String V9 = "V9";
    public static final String IMAGES_CLIPART_BIG = "images/clipart/big/";
    private JPanel myPanel;
    private JRadioButton myImageRadioButton;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myTextRadioButton;
    private JRadioButton myCropRadioButton;
    private JRadioButton myCenterRadioButton;
    private JRadioButton myCircleRadioButton;
    private JRadioButton mySquareRadioButton;
    private JRadioButton myNoneRadioButton;
    private JButton myChooseClipart;
    private JLabel myError;
    private JLabel myDescription;
    private JCheckBox myTrimBlankSpace;
    private JTextField myText;
    private JComboBox myFontFamily;
    private TextFieldWithBrowseButton myImageFile;
    private ColorPanel myBackgroundColor;
    private ColorPanel myForegroundColor;
    private ImageComponent myMdpiPreview;
    private ImageComponent myHdpiPreview;
    private ImageComponent myXHdpiPreview;
    private JSlider myPaddingSlider;
    private ImageComponent myXXHdpiPreview;
    private JLabel myImageFileLabel;
    private JLabel myTextLabel;
    private JLabel myFontFamilyLabel;
    private JLabel myChooseClipartLabel;
    private JLabel myBackgroundColorLabel;
    private JLabel myForegroundColorLabel;
    private JComboBox myAssetTypeComboBox;
    private JLabel myAssetTypeLabel;
    private JComboBox myChooseThemeComboBox;
    private JLabel myChooseThemeLabel;
    private JLabel myForegroundScalingLabel;
    private JLabel myShapeLabel;
    private JPanel myShapePanel;
    private JPanel myScalingPanel;
    private JTextField myResourceNameField;
    private JLabel myResourceNameLabel;
    private JPanel myVersionPanel;
    private ImageComponent myV9XHdpiPreview;
    private ImageComponent myV9XXHdpiPreview;
    private ImageComponent myV9MdpiPreview;
    private ImageComponent myV9HdpiPreview;
    private ImageComponent myV11MdpiPreview;
    private ImageComponent myV11HdpiPreview;
    private ImageComponent myV11XHdpiPreview;
    private ImageComponent myV11XXHdpiPreview;
    private ImageComponent myXXXHdpiPreview;
    private JRadioButton myVerticalRadioButton;
    private JRadioButton myHorizontalRadioButton;
    private JLabel myXXXHDPILabel;
    private JCheckBox myDogEarEffectCheckBox;
    private JBScrollPane myScrollPane;
    private final StringEvaluator myStringEvaluator;

    public RasterAssetSetStep(TemplateWizardState state, Project project, Module module, Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, VirtualFile invocationTarget) {
        super(state, project, module, sidePanelIcon, updateListener, invocationTarget);
        this.$$$setupUI$$$();
        this.myStringEvaluator = new StringEvaluator();
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.register("text", this.myText);
        this.register("scaling", this.myCropRadioButton, (Object)AssetStudioAssetGenerator.Scaling.CROP);
        this.register("scaling", this.myCenterRadioButton, (Object)AssetStudioAssetGenerator.Scaling.CENTER);
        this.register("shape", this.myCircleRadioButton, GraphicGenerator.Shape.CIRCLE);
        this.register("shape", this.myNoneRadioButton, GraphicGenerator.Shape.NONE);
        this.register("shape", this.mySquareRadioButton, GraphicGenerator.Shape.SQUARE);
        this.register("shape", this.myVerticalRadioButton, GraphicGenerator.Shape.VRECT);
        this.register("shape", this.myHorizontalRadioButton, GraphicGenerator.Shape.HRECT);
        this.register("dogear", this.myDogEarEffectCheckBox);
        this.register("padding", this.myPaddingSlider);
        this.register("trim", this.myTrimBlankSpace);
        this.register("font", this.myFontFamily);
        this.register("sourceType", this.myImageRadioButton, (Object)AssetStudioAssetGenerator.SourceType.IMAGE);
        this.register("sourceType", this.myClipartRadioButton, (Object)AssetStudioAssetGenerator.SourceType.CLIPART);
        this.register("sourceType", this.myTextRadioButton, (Object)AssetStudioAssetGenerator.SourceType.TEXT);
        this.register("foregroundColor", this.myForegroundColor);
        this.register("backgroundColor", this.myBackgroundColor);
        this.register("assetType", this.myAssetTypeComboBox);
        this.register("assetTheme", this.myChooseThemeComboBox);
        this.register("assetName", this.myResourceNameField);
        this.myImageFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myForegroundColor.setSelectedColor(Color.BLUE);
        this.myBackgroundColor.setSelectedColor(Color.WHITE);
        for (String font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.myFontFamily.addItem(new ComboBoxItemWithApiTag(font, font, 1, 1));
            if (!font.equals(this.myTemplateState.get("font"))) continue;
            this.myFontFamily.setSelectedIndex(this.myFontFamily.getItemCount() - 1);
        }
        this.myChooseClipart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RasterAssetSetStep.this.displayClipartDialog();
            }
        });
        RasterAssetSetStep.populateComboBox(this.myAssetTypeComboBox, AssetStudioAssetGenerator.AssetType.class);
        RasterAssetSetStep.populateComboBox(this.myChooseThemeComboBox, ActionBarIconGenerator.Theme.class);
    }

    @Override
    public void deriveValues() {
        super.deriveValues();
        this.myTemplateState.put(ATTR_ICON_RESOURCE, this.myTemplateState.getString("assetName"));
        if (this.myImageRadioButton.isSelected()) {
            this.hide(new JComponent[]{this.myChooseClipart, this.myChooseClipartLabel, this.myText, this.myTextLabel, this.myFontFamily, this.myFontFamilyLabel, this.myForegroundColor, this.myForegroundColorLabel});
            this.show(new JComponent[]{this.myImageFile, this.myImageFileLabel, this.myBackgroundColor, this.myBackgroundColorLabel});
        } else if (this.myClipartRadioButton.isSelected()) {
            this.hide(new JComponent[]{this.myText, this.myTextLabel, this.myFontFamily, this.myFontFamilyLabel, this.myImageFile, this.myImageFileLabel});
            this.show(new JComponent[]{this.myChooseClipart, this.myChooseClipartLabel, this.myBackgroundColor, this.myBackgroundColorLabel, this.myForegroundColor, this.myForegroundColorLabel});
        } else if (this.myTextRadioButton.isSelected()) {
            this.hide(new JComponent[]{this.myChooseClipart, this.myChooseClipartLabel, this.myImageFile, this.myImageFileLabel});
            this.show(new JComponent[]{this.myText, this.myTextLabel, this.myFontFamily, this.myFontFamilyLabel, this.myBackgroundColor, this.myBackgroundColorLabel, this.myForegroundColor, this.myForegroundColorLabel});
            this.myFontFamily.setSelectedItem(this.myTemplateState.getString("font"));
        }
        if (this.myTemplateState.get("assetType") != null) {
            AssetStudioAssetGenerator.AssetType selectedAssetType;
            this.mySelectedAssetType = selectedAssetType = AssetStudioAssetGenerator.AssetType.valueOf(this.myTemplateState.getString("assetType"));
            if (selectedAssetType != null) {
                switch (selectedAssetType) {
                    case LAUNCHER: {
                        this.hide(this.myChooseThemeComboBox, this.myChooseThemeLabel, this.myVersionPanel, this.myDogEarEffectCheckBox);
                        this.show(new JComponent[]{this.myForegroundScalingLabel, this.myScalingPanel, this.myShapeLabel, this.myShapePanel, this.myResourceNameLabel, this.myResourceNameField, this.myXXXHdpiPreview, this.myXXXHDPILabel, this.myScrollPane});
                        if (!this.myTemplateState.myModified.contains("assetName")) {
                            this.myTemplateState.put("assetName", "icon");
                        }
                        if (!this.mySquareRadioButton.isSelected() && !this.myVerticalRadioButton.isSelected() && !this.myHorizontalRadioButton.isSelected()) break;
                        this.show(this.myDogEarEffectCheckBox);
                        break;
                    }
                    case ACTIONBAR: {
                        this.show(this.myResourceNameField, this.myResourceNameLabel);
                        this.show(new JComponent[]{this.myChooseThemeComboBox, this.myChooseThemeLabel, this.myScrollPane});
                        this.hide(new JComponent[]{this.myForegroundScalingLabel, this.myScalingPanel, this.myShapeLabel, this.myShapePanel, this.myBackgroundColorLabel, this.myBackgroundColor, this.myVersionPanel, this.myXXXHdpiPreview, this.myXXXHDPILabel, this.myDogEarEffectCheckBox});
                        break;
                    }
                    case NOTIFICATION: {
                        this.show(this.myResourceNameField, this.myResourceNameLabel, this.myVersionPanel);
                        this.hide(new JComponent[]{this.myChooseThemeComboBox, this.myChooseThemeLabel, this.myForegroundColor, this.myForegroundColorLabel});
                        this.hide(new JComponent[]{this.myForegroundScalingLabel, this.myScalingPanel, this.myShapeLabel, this.myShapePanel, this.myBackgroundColorLabel, this.myBackgroundColor, this.myScrollPane, this.myDogEarEffectCheckBox});
                    }
                }
                if (!this.myTemplateState.myModified.contains("assetName")) {
                    this.updateDerivedValue("assetName", this.myResourceNameField, new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return RasterAssetSetStep.this.computeResourceName();
                        }
                    });
                }
            }
        }
        if (this.myChooseThemeComboBox.isVisible() && this.myTemplateState.hasAttr("assetTheme")) {
            if (ActionBarIconGenerator.Theme.valueOf((String)this.myTemplateState.getString("assetTheme")).equals((Object)ActionBarIconGenerator.Theme.CUSTOM)) {
                this.show(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
            } else {
                this.hide(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
            }
        }
    }

    @Override
    protected void updatePreviewImages() {
        if (this.mySelectedAssetType == null || this.myImageMap == null) {
            return;
        }
        if (this.mySelectedAssetType.equals((Object)AssetStudioAssetGenerator.AssetType.NOTIFICATION)) {
            BufferedImage v9_mdpi = RasterAssetSetStep.getImage(this.myImageMap, V9, Density.MEDIUM);
            BufferedImage v9_hdpi = RasterAssetSetStep.getImage(this.myImageMap, V9, Density.HIGH);
            BufferedImage v9_xhdpi = RasterAssetSetStep.getImage(this.myImageMap, V9, Density.XHIGH);
            BufferedImage v9_xxhdpi = RasterAssetSetStep.getImage(this.myImageMap, V9, Density.XXHIGH);
            RasterAssetSetStep.setIconOrClear(this.myV9MdpiPreview, v9_mdpi);
            RasterAssetSetStep.setIconOrClear(this.myV9HdpiPreview, v9_hdpi);
            RasterAssetSetStep.setIconOrClear(this.myV9XHdpiPreview, v9_xhdpi);
            RasterAssetSetStep.setIconOrClear(this.myV9XXHdpiPreview, v9_xxhdpi);
            BufferedImage v11_mdpi = RasterAssetSetStep.getImage(this.myImageMap, V11, Density.MEDIUM);
            BufferedImage v11_hdpi = RasterAssetSetStep.getImage(this.myImageMap, V11, Density.HIGH);
            BufferedImage v11_xhdpi = RasterAssetSetStep.getImage(this.myImageMap, V11, Density.XHIGH);
            BufferedImage v11_xxhdpi = RasterAssetSetStep.getImage(this.myImageMap, V11, Density.XXHIGH);
            RasterAssetSetStep.setIconOrClear(this.myV11MdpiPreview, v11_mdpi);
            RasterAssetSetStep.setIconOrClear(this.myV11HdpiPreview, v11_hdpi);
            RasterAssetSetStep.setIconOrClear(this.myV11XHdpiPreview, v11_xhdpi);
            RasterAssetSetStep.setIconOrClear(this.myV11XXHdpiPreview, v11_xxhdpi);
        } else {
            BufferedImage mdpi = RasterAssetSetStep.getImage(this.myImageMap, Density.MEDIUM.getResourceValue());
            BufferedImage hdpi = RasterAssetSetStep.getImage(this.myImageMap, Density.HIGH.getResourceValue());
            BufferedImage xhdpi = RasterAssetSetStep.getImage(this.myImageMap, Density.XHIGH.getResourceValue());
            BufferedImage xxhdpi = RasterAssetSetStep.getImage(this.myImageMap, Density.XXHIGH.getResourceValue());
            RasterAssetSetStep.setIconOrClear(this.myMdpiPreview, mdpi);
            RasterAssetSetStep.setIconOrClear(this.myHdpiPreview, hdpi);
            RasterAssetSetStep.setIconOrClear(this.myXHdpiPreview, xhdpi);
            RasterAssetSetStep.setIconOrClear(this.myXXHdpiPreview, xxhdpi);
            if (this.mySelectedAssetType.equals((Object)AssetStudioAssetGenerator.AssetType.LAUNCHER)) {
                BufferedImage xxxhdpi = RasterAssetSetStep.getImage(this.myImageMap, Density.XXXHIGH.getResourceValue());
                RasterAssetSetStep.setIconOrClear(this.myXXXHdpiPreview, xxxhdpi);
            }
        }
        this.myUpdateListener.update();
    }

    private void displayClipartDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        final JDialog dialog = new JDialog(window, Dialog.ModalityType.DOCUMENT_MODAL);
        FlowLayout layout = new FlowLayout();
        dialog.getRootPane().setLayout(layout);
        int count = 0;
        Iterator iter = GraphicGenerator.getResourcesNames((String)IMAGES_CLIPART_BIG, (String)".png");
        while (iter.hasNext()) {
            final String name = (String)iter.next();
            try {
                JButton btn = new JButton();
                btn.setIcon(new ImageIcon(GraphicGenerator.getClipartIcon((String)name)));
                Dimension d = new Dimension(CLIPART_ICON_SIZE, CLIPART_ICON_SIZE);
                btn.setMaximumSize(d);
                btn.setPreferredSize(d);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RasterAssetSetStep.this.myTemplateState.put("clipartPath", name);
                        dialog.setVisible(false);
                        RasterAssetSetStep.this.update();
                    }
                });
                dialog.getRootPane().add(btn);
                ++count;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        int size = (int)(Math.sqrt(count) + 1.0) * (CLIPART_ICON_SIZE + layout.getHgap()) + CLIPART_DIALOG_BORDER * 2;
        dialog.setSize(size, size + DIALOG_HEADER);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    public void finalizeAssetType(AssetStudioAssetGenerator.AssetType type) {
        this.mySelectedAssetType = type;
        this.myTemplateState.put("assetType", type.name());
        for (int i = 0; i < this.myAssetTypeComboBox.getItemCount(); ++i) {
            if (!((ComboBoxItemWithApiTag)this.myAssetTypeComboBox.getItemAt((int)i)).id.equals(type.name())) continue;
            this.myAssetTypeComboBox.setSelectedIndex(i);
            break;
        }
        this.hide(this.myAssetTypeComboBox, this.myAssetTypeLabel);
        this.update();
    }

    private static BufferedImage getImage(Map<String, Map<String, BufferedImage>> map, String name) {
        Map<String, BufferedImage> images = map.get(name);
        if (images == null) {
            return null;
        }
        Collection<BufferedImage> values = images.values();
        return values.isEmpty() ? null : values.iterator().next();
    }

    private static BufferedImage getImage(Map<String, Map<String, BufferedImage>> map, String category, Density density) {
        String densityString = density.getResourceValue();
        Map<String, BufferedImage> images = map.get(category);
        if (images == null) {
            return null;
        }
        for (String key : images.keySet()) {
            if (!key.contains(densityString)) continue;
            return images.get(key);
        }
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    public String getHelpId() {
        return "Android-Gradle_Screen_Configuration_Page";
    }

    @Override
    protected void initialize() {
        this.myTemplateState.put("imagePath", new File(TemplateManager.getTemplateRootFolder(), FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule", "root", "res", "mipmap-xhdpi", "ic_launcher.png"})).getAbsolutePath());
        this.register("imagePath", this.myImageFile);
    }

    @Override
    protected String computeResourceName() {
        String resourceName = null;
        if (this.myTemplateState.get("iconName") != null) {
            resourceName = this.myStringEvaluator.evaluate(this.myTemplateState.getString("iconName"), this.myTemplateState.getParameters());
        }
        if (resourceName == null) {
            resourceName = String.format(this.mySelectedAssetType.getDefaultNameFormat(), "name");
        }
        if (this.drawableExists(resourceName) && this.mySelectedAssetType != AssetStudioAssetGenerator.AssetType.LAUNCHER) {
            int i = 2;
            while (this.drawableExists(resourceName + Integer.toString(i))) {
                ++i;
            }
            resourceName = resourceName + Integer.toString(i);
        }
        return resourceName;
    }

    @Override
    protected void generateAssetFiles(File targetResDir) {
        File targetVariantDir = targetResDir.getParentFile();
        this.myAssetGenerator.outputImagesIntoVariantRoot(targetVariantDir);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myImageRadioButton;
    }

    @Override
    protected JLabel getDescription() {
        return this.myDescription;
    }

    @Override
    protected JLabel getError() {
        return this.myError;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JSlider jSlider;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel7;
        JLabel jLabel8;
        JButton jButton;
        JLabel jLabel9;
        JLabel jLabel10;
        JLabel jLabel11;
        JComboBox jComboBox3;
        JTextField jTextField2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JPanel jPanel2;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JRadioButton jRadioButton10;
        JLabel jLabel12;
        JLabel jLabel13;
        JCheckBox jCheckBox2;
        ImageComponent imageComponent;
        ImageComponent imageComponent2;
        JLabel jLabel14;
        ImageComponent imageComponent3;
        ImageComponent imageComponent4;
        ImageComponent imageComponent5;
        JBScrollPane jBScrollPane;
        ImageComponent imageComponent6;
        ImageComponent imageComponent7;
        ImageComponent imageComponent8;
        ImageComponent imageComponent9;
        ImageComponent imageComponent10;
        ImageComponent imageComponent11;
        ImageComponent imageComponent12;
        ImageComponent imageComponent13;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myVersionPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 1, 2, 1, 0, 3, 1, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 2, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("Older Versions");
        jPanel3.add((Component)jLabel15, new GridConstraints(1, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("API 11+");
        jPanel3.add((Component)jLabel16, new GridConstraints(3, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        this.myV9XHdpiPreview = imageComponent13 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent13), new GridConstraints(0, 2, 1, 1, 0, 0, 1, 1, new Dimension(32, 50), new Dimension(32, 50), null));
        this.myV9XXHdpiPreview = imageComponent12 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent12), new GridConstraints(0, 3, 1, 1, 0, 0, 3, 1, new Dimension(48, 75), new Dimension(48, 75), null));
        this.myV9MdpiPreview = imageComponent11 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent11), new GridConstraints(0, 0, 1, 1, 0, 0, 3, 1, new Dimension(16, 25), new Dimension(16, 25), null));
        this.myV9HdpiPreview = imageComponent10 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent10), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 1, new Dimension(24, 38), new Dimension(24, 38), null));
        this.myV11XHdpiPreview = imageComponent9 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent9), new GridConstraints(2, 2, 1, 1, 0, 0, 1, 3, new Dimension(48, 48), new Dimension(48, 48), null));
        this.myV11XXHdpiPreview = imageComponent8 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent8), new GridConstraints(2, 3, 1, 1, 0, 0, 3, 3, new Dimension(72, 72), new Dimension(72, 72), null));
        this.myV11MdpiPreview = imageComponent7 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent7), new GridConstraints(2, 0, 1, 1, 0, 0, 3, 3, new Dimension(24, 24), new Dimension(24, 24), null));
        this.myV11HdpiPreview = imageComponent6 = new ImageComponent();
        jPanel3.add((Component)((Object)imageComponent6), new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, new Dimension(36, 36), new Dimension(36, 36), null));
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("Preview");
        jPanel5.add((Component)jLabel17, new GridConstraints(0, 0, 1, 2, 0, 0, 0, 0, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel5.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 1, 1, 2, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel6);
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("MDPI");
        jPanel6.add((Component)jLabel18, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("HDPI");
        jPanel6.add((Component)jLabel19, new GridConstraints(3, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("XHDPI");
        jPanel6.add((Component)jLabel20, new GridConstraints(5, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("XXHDPI");
        jPanel6.add((Component)jLabel21, new GridConstraints(7, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myHdpiPreview = imageComponent5 = new ImageComponent();
        jPanel6.add((Component)((Object)imageComponent5), new GridConstraints(2, 0, 1, 1, 0, 0, 1, 3, new Dimension(72, 72), new Dimension(72, 72), null));
        this.myXHdpiPreview = imageComponent4 = new ImageComponent();
        jPanel6.add((Component)((Object)imageComponent4), new GridConstraints(4, 0, 1, 1, 0, 0, 1, 3, new Dimension(96, 96), new Dimension(96, 96), null));
        this.myXXHdpiPreview = imageComponent3 = new ImageComponent();
        jPanel6.add((Component)((Object)imageComponent3), new GridConstraints(6, 0, 1, 1, 0, 0, 1, 3, new Dimension(144, 144), new Dimension(144, 144), null));
        this.myXXXHDPILabel = jLabel14 = new JLabel();
        jLabel14.setText("XXXHDPI");
        jPanel6.add((Component)jLabel14, new GridConstraints(9, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myXXXHdpiPreview = imageComponent2 = new ImageComponent();
        jPanel6.add((Component)((Object)imageComponent2), new GridConstraints(8, 0, 1, 1, 0, 0, 1, 3, new Dimension(192, 192), new Dimension(192, 192), null));
        this.myMdpiPreview = imageComponent = new ImageComponent();
        jPanel6.add((Component)((Object)imageComponent), new GridConstraints(0, 0, 1, 1, 0, 0, 1, 3, new Dimension(48, 48), new Dimension(48, 48), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(17, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Foreground:");
        jPanel7.add((Component)jLabel22, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTrimBlankSpace = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Trim surrounding blank space");
        jPanel7.add((Component)jCheckBox2, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundScalingLabel = jLabel13 = new JLabel();
        jLabel13.setText("Foreground scaling:");
        jPanel7.add((Component)jLabel13, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShapeLabel = jLabel12 = new JLabel();
        jLabel12.setText("Shape:");
        jPanel7.add((Component)jLabel12, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(47, 36), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myImageRadioButton = jRadioButton10 = new JRadioButton();
        jRadioButton10.setText("Image");
        jPanel8.add((Component)jRadioButton10, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myClipartRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setText("Clipart");
        jPanel8.add((Component)jRadioButton9, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myTextRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("Text");
        jPanel8.add((Component)jRadioButton8, new GridConstraints(0, 2, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myScalingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(8, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCropRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Crop");
        jPanel2.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCenterRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Center");
        jPanel2.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShapePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(9, 1, 1, 1, 8, 2, 3, 3, null, new Dimension(456, 36), null));
        this.myCircleRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Circle");
        jPanel.add((Component)jRadioButton5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNoneRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("None");
        jPanel.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVerticalRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Vertical");
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHorizontalRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Horizontal");
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySquareRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Square");
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myText = jTextField2 = new JTextField();
        jPanel7.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFontFamily = jComboBox3 = new JComboBox();
        jPanel7.add(jComboBox3, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTextLabel = jLabel11 = new JLabel();
        jLabel11.setText("Text:");
        jPanel7.add((Component)jLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFontFamilyLabel = jLabel10 = new JLabel();
        jLabel10.setText("Font:");
        jPanel7.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundColorLabel = jLabel9 = new JLabel();
        jLabel9.setText("Foreground color:");
        jPanel7.add((Component)jLabel9, new GridConstraints(13, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myChooseClipart = jButton = new JButton();
        jButton.setText("Choose");
        jPanel7.add((Component)jButton, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImageFileLabel = jLabel8 = new JLabel();
        jLabel8.setText("Image file:");
        jPanel7.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myChooseClipartLabel = jLabel7 = new JLabel();
        jLabel7.setText("Clipart:");
        jPanel7.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myBackgroundColor = colorPanel2 = new ColorPanel();
        jPanel7.add((Component)colorPanel2, new GridConstraints(12, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForegroundColor = colorPanel = new ColorPanel();
        jPanel7.add((Component)colorPanel, new GridConstraints(13, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("Additional padding:");
        jPanel7.add((Component)jLabel23, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(7, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPaddingSlider = jSlider = new JSlider();
        jSlider.setValue(0);
        jSlider.setMinimum(0);
        jSlider.setMaximum(100);
        jPanel9.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel10).setEnabled(true);
        jPanel7.add((Component)jPanel10, new GridConstraints(16, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        this.myDescription = jLabel6 = new JLabel();
        jLabel6.setText("");
        ((Component)jLabel6).setVisible(false);
        jPanel10.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myError = jLabel5 = new JLabel();
        jLabel5.setVerticalTextPosition(3);
        jLabel5.setText(" ");
        jPanel10.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(15, 0, 1, 2, 0, 2, 1, 6, new Dimension(1, 1), null, null));
        this.myAssetTypeLabel = jLabel4 = new JLabel();
        jLabel4.setText("Asset Type:");
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAssetTypeComboBox = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel7.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myChooseThemeComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel2);
        ((Component)jComboBox).setVisible(true);
        jPanel7.add(jComboBox, new GridConstraints(11, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myChooseThemeLabel = jLabel3 = new JLabel();
        jLabel3.setText("Theme:");
        ((Component)jLabel3).setVisible(true);
        jPanel7.add((Component)jLabel3, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourceNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Resource name:");
        jPanel7.add((Component)jLabel2, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel7.add((Component)jTextField, new GridConstraints(14, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDogEarEffectCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Dog-ear effect");
        jPanel7.add((Component)jCheckBox, new GridConstraints(10, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundColorLabel = jLabel = new JLabel();
        jLabel.setText("Background color:");
        jPanel7.add((Component)jLabel, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton10);
        buttonGroup.add(jRadioButton9);
        buttonGroup.add(jRadioButton8);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

