/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

class TemplateListProvider
extends ScopedDataBinder.ValueDeriver<TemplateEntry[]> {
    private final TemplateEntry[] myTemplates;

    public TemplateListProvider(String formFactor, Set<String> categories, Set<String> excluded) {
        ArrayList templates = Lists.newArrayList();
        for (String category : categories) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, category, excluded)));
        }
        if (FormFactorUtils.FormFactor.WEAR.id.equals(formFactor)) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, "Wear", excluded)));
        }
        if (FormFactorUtils.FormFactor.CAR.id.equals(formFactor)) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, "Android Auto", excluded)));
        }
        Collections.sort(templates, new Comparator<TemplateEntry>(){

            @Override
            public int compare(TemplateEntry o1, TemplateEntry o2) {
                TemplateMetadata m1 = o1.getMetadata();
                TemplateMetadata m2 = o2.getMetadata();
                return StringUtil.naturalCompare((String)m1.getTitle(), (String)m2.getTitle());
            }
        });
        this.myTemplates = templates.toArray(new TemplateEntry[templates.size()]);
    }

    private static TemplateEntry[] getTemplateList(String formFactor, String category, Set<String> excluded) {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplatesInCategory(category);
        ArrayList<TemplateEntry> metadataList = new ArrayList<TemplateEntry>(templates.size());
        for (File template : templates) {
            TemplateMetadata metadata = manager.getTemplate(template);
            if (metadata == null || !metadata.isSupported() || excluded != null && excluded.contains(metadata.getTitle()) || formFactor != null && !formFactor.equalsIgnoreCase(metadata.getFormFactor())) continue;
            metadataList.add(new TemplateEntry(template, metadata));
        }
        return (TemplateEntry[])ArrayUtil.toObjectArray(metadataList, TemplateEntry.class);
    }

    @Override
    public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
        return ImmutableSet.of(AddAndroidActivityPath.KEY_IS_LAUNCHER);
    }

    @Override
    public TemplateEntry[] deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, TemplateEntry[] currentValue) {
        Boolean isLauncher = state.get(AddAndroidActivityPath.KEY_IS_LAUNCHER);
        if (!Boolean.TRUE.equals(isLauncher)) {
            return this.myTemplates;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.myTemplates.length);
        for (TemplateEntry entry : Arrays.asList(this.myTemplates)) {
            if (entry.getMetadata().getParameter("isLauncher") == null) continue;
            list.add(entry);
        }
        return (TemplateEntry[])ArrayUtil.toObjectArray((Collection)list, TemplateEntry.class);
    }
}

