/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.AsyncValidator;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardStep;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class WrapArchiveOptionsStep
extends ModuleWizardStep
implements AndroidStudioWizardStep {
    private static final Set<String> SUPPORTED_EXTENSIONS = ImmutableSet.of((Object)"jar", (Object)"aar");
    private final Project myProject;
    private final TemplateWizardState myWizardState;
    private AsyncValidator<ValidationStatus> myValidator;
    private JPanel myPanel;
    private JTextField myGradlePath;
    private TextFieldWithBrowseButton myArchivePath;
    private JBLabel myValidationStatus;
    private JCheckBox myRemoveOriginalFileCheckBox;
    private JCheckBox myReplaceFileDependencyWithCheckBox;
    private ValidationStatus myResult = ValidationStatus.EMPTY_PATH;
    private boolean myIsFirstUIUpdate = true;
    private Icon mySidePanelIcon;

    public WrapArchiveOptionsStep(Project project, TemplateWizardState state, Icon sidePanelIcon) {
        this.mySidePanelIcon = sidePanelIcon;
        this.$$$setupUI$$$();
        this.centerControls();
        this.myProject = project;
        this.myWizardState = state;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                String extension = file.getExtension();
                return extension != null && SUPPORTED_EXTENSIONS.contains(extension.toLowerCase());
            }
        };
        this.myArchivePath.addBrowseFolderListener("Select Package", "Select jar or aar package to import as a new module", project, descriptor);
        this.myArchivePath.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                WrapArchiveOptionsStep.this.pathUpdated(WrapArchiveOptionsStep.this.myArchivePath.getText());
                WrapArchiveOptionsStep.this.updateDataModel();
            }
        });
        this.myGradlePath.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                WrapArchiveOptionsStep.this.updateDataModel();
            }
        });
        this.myValidationStatus.setText("");
        this.myValidationStatus.setIcon(null);
        this.myValidator = new AsyncValidator<ValidationStatus>(ApplicationManager.getApplication()){

            @Override
            protected void showValidationResult(ValidationStatus result) {
                WrapArchiveOptionsStep.this.updateStep(result);
            }

            @Override
            protected ValidationStatus validate() {
                return WrapArchiveOptionsStep.this.validatePath();
            }
        };
        this.updateDataModel();
    }

    public Icon getIcon() {
        return this.mySidePanelIcon;
    }

    private void centerControls() {
        GridLayoutManager layout = (GridLayoutManager)this.myPanel.getLayout();
        int height = (int)Math.floor(this.myGradlePath.getPreferredSize().getHeight() * 3.0);
        layout.setMargin(new Insets(height, 16, 0, 0));
    }

    private void updateStep(ValidationStatus result) {
        this.myResult = result;
        String message = "";
        Icon icon = null;
        if (!this.myIsFirstUIUpdate && result.getMessageType() != MessageType.INFO) {
            message = this.getValidationMessage(result);
            icon = result.getMessageType().getDefaultIcon();
        }
        this.myIsFirstUIUpdate = false;
        this.myValidationStatus.setText(message);
        this.myValidationStatus.setIcon(icon);
        this.myRemoveOriginalFileCheckBox.setVisible(result == ValidationStatus.IN_MODULE);
        this.myReplaceFileDependencyWithCheckBox.setVisible(result == ValidationStatus.IN_MODULE);
        this.fireStateChanged();
    }

    private String getValidationMessage(ValidationStatus result) {
        String gradlePath = this.myGradlePath.getText().trim();
        switch (result) {
            case MODULE_EXISTS: {
                return String.format("Project already contains subproject with name %1$s", gradlePath);
            }
            case OK: 
            case IN_MODULE: {
                return "";
            }
            case EMPTY_PATH: {
                return "Archive file path is required";
            }
            case EMPTY_GRADLE_PATH: {
                return "Subproject name is required";
            }
            case DOES_NOT_EXIST: {
                return "File does not exist";
            }
            case INVALID_MODULE_PATH: {
                return String.format("Character %1$c is not allowed in a Gradle path", Character.valueOf(gradlePath.charAt(GradleUtil.isValidGradlePath(gradlePath))));
            }
        }
        throw new IllegalStateException(result.name());
    }

    private ValidationStatus validatePath() {
        String archive = this.myArchivePath.getText().trim();
        if (Strings.isNullOrEmpty((String)archive)) {
            return ValidationStatus.EMPTY_PATH;
        }
        File archiveFile = new File(archive);
        if (!archiveFile.isFile()) {
            return ValidationStatus.DOES_NOT_EXIST;
        }
        String gradlePath = this.myGradlePath.getText().trim();
        if (Strings.isNullOrEmpty((String)gradlePath)) {
            return ValidationStatus.EMPTY_GRADLE_PATH;
        }
        if (GradleUtil.isValidGradlePath(gradlePath) >= 0) {
            return ValidationStatus.INVALID_MODULE_PATH;
        }
        if (GradleUtil.hasModule(this.myProject, gradlePath, true)) {
            return ValidationStatus.MODULE_EXISTS;
        }
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)archiveFile, (boolean)false);
        if (vfile != null && this.getContainingModule(vfile) != null) {
            return ValidationStatus.IN_MODULE;
        }
        return ValidationStatus.OK;
    }

    private void pathUpdated(String newPath) {
        this.myGradlePath.setText(Files.getNameWithoutExtension((String)newPath));
    }

    public boolean validate() {
        return !MessageType.ERROR.equals(this.myResult.getMessageType());
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myArchivePath.getTextField();
    }

    public void updateDataModel() {
        this.myValidator.invalidate();
    }

    public void updateStep() {
        VirtualFile file;
        String filePath = this.myArchivePath.getText().trim();
        String gradlePath = this.myGradlePath.getText().trim();
        this.myWizardState.put("newmodule.wrap.archivePath", filePath);
        this.myWizardState.put("newmodule.wrap.gradlePath", gradlePath);
        boolean move = false;
        Module[] modules = new Module[]{};
        if (this.myResult == ValidationStatus.IN_MODULE && (file = VfsUtil.findFileByIoFile((File)new File(this.myArchivePath.getText()), (boolean)false)) != null) {
            move = this.myRemoveOriginalFileCheckBox.isSelected();
            modules = new Module[]{this.getContainingModule(file)};
        }
        this.myWizardState.put("newmodule.wrap.move", move);
        this.myWizardState.put("newmodule.wrap.updateDeps", modules);
    }

    private Module getContainingModule(VirtualFile file) {
        Module bestMatch = null;
        if (this.myProject != null) {
            int bestMatchValue = Integer.MAX_VALUE;
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                int value;
                String relativePath;
                VirtualFile root;
                AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
                if (facet == null) continue;
                GradleModel gradleModel = facet.getGradleModel();
                assert (gradleModel != null);
                VirtualFile buildFile = gradleModel.getBuildFile();
                if (buildFile == null || !VfsUtilCore.isAncestor((VirtualFile)(root = buildFile.getParent()), (VirtualFile)file, (boolean)true) || (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')) == null || (value = Iterables.size((Iterable)Splitter.on((char)'/').split((CharSequence)relativePath))) >= bestMatchValue) continue;
                bestMatch = module;
            }
        }
        return bestMatch;
    }

    @Override
    public boolean isValid() {
        return this.validate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(96, 16, 0, 0), -1, -1, false, false));
        this.myArchivePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGradlePath = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("File name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Subproject name:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveOriginalFileCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Remove original file");
        jPanel.add((Component)jCheckBox2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReplaceFileDependencyWithCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Replace a file dependency with the project dependency");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myValidationStatus = jBLabel = new JBLabel();
        jBLabel.setText("Some text for designer");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static enum ValidationStatus {
        OK,
        EMPTY_PATH,
        DOES_NOT_EXIST,
        INVALID_MODULE_PATH,
        MODULE_EXISTS,
        EMPTY_GRADLE_PATH,
        IN_MODULE;


        public MessageType getMessageType() {
            switch (this) {
                case OK: 
                case IN_MODULE: {
                    return MessageType.INFO;
                }
            }
            return MessageType.ERROR;
        }
    }
}

