/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.AsyncWriterDelegate;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;

public class CaptureService {
    public static final String FD_CAPTURES = "captures";
    private final Project myProject;
    private Multimap<CaptureType, Capture> myCaptures;
    private List<CaptureListener> myListeners;
    private AsyncWriterDelegate myAsyncWriterDelegate;
    private Set<CaptureHandle> myOpenCaptureHandles;

    public CaptureService(Project project) {
        this.myProject = project;
        this.myCaptures = LinkedListMultimap.create();
        this.myListeners = new LinkedList<CaptureListener>();
        this.myOpenCaptureHandles = new HashSet<CaptureHandle>();
        this.update();
    }

    public static CaptureService getInstance(Project project) {
        return (CaptureService)ServiceManager.getService((Project)project, CaptureService.class);
    }

    private static Set<VirtualFile> findCaptureFiles(VirtualFile[] files, CaptureType type) {
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            if (!type.isValidCapture(file)) continue;
            set.add(file);
        }
        return set;
    }

    public void update() {
        CaptureTypeService service = CaptureTypeService.getInstance();
        VirtualFile dir = this.getCapturesDirectory();
        LinkedListMultimap updated = LinkedListMultimap.create();
        if (dir != null) {
            VirtualFile[] children = VfsUtil.getChildren((VirtualFile)dir);
            for (CaptureType type : service.getCaptureTypes()) {
                Set<VirtualFile> files = CaptureService.findCaptureFiles(children, type);
                for (Capture capture : this.myCaptures.get((Object)type)) {
                    if (!files.remove(capture.getFile())) continue;
                    updated.put((Object)type, (Object)capture);
                }
                for (VirtualFile newFile : files) {
                    updated.put((Object)type, (Object)type.createCapture(newFile));
                }
            }
        }
        this.myCaptures = updated;
    }

    public VirtualFile createCapturesDirectory() throws IOException {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        if (projectDir != null) {
            VirtualFile dir = projectDir.findChild(FD_CAPTURES);
            if (dir == null) {
                dir = projectDir.createChildDirectory(null, FD_CAPTURES);
            }
            return dir;
        }
        throw new IOException("Unable to create the captures directory: Project directory not found.");
    }

    public VirtualFile getCapturesDirectory() {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        return projectDir != null ? projectDir.findChild(FD_CAPTURES) : null;
    }

    public Multimap<CaptureType, Capture> getCapturesByType() {
        return this.myCaptures;
    }

    public Collection<Capture> getCaptures() {
        return this.myCaptures.values();
    }

    public Collection<CaptureType> getTypes() {
        return this.myCaptures.keySet();
    }

    public CaptureHandle startCaptureFile(Class<? extends CaptureType> clazz) throws IOException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAsyncWriterDelegate == null) {
            this.myAsyncWriterDelegate = new AsyncWriterDelegate();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myAsyncWriterDelegate);
        }
        CaptureHandle handle = this.startCaptureFileSynchronous(clazz);
        this.myOpenCaptureHandles.add(handle);
        return handle;
    }

    public void appendData(CaptureHandle captureHandle, byte[] data) throws IOException {
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, Arrays.copyOf(data, data.length));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cancelCaptureFile(CaptureHandle captureHandle) {
        this.finalizeCaptureFileAsynchronous(captureHandle, null, null);
    }

    Capture finalizeCaptureFileSynchronous(CaptureHandle captureHandle) throws InterruptedException, IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        return this.createCapture(captureHandle);
    }

    public void finalizeCaptureFileAsynchronous(final CaptureHandle captureHandle, FutureCallback<Capture> onCompletion, Executor executor) {
        final ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Capture>(){

            @Override
            public Capture call() throws Exception {
                ApplicationManager.getApplication().assertIsDispatchThread();
                return CaptureService.this.createCapture(captureHandle);
            }
        });
        if (onCompletion != null) {
            assert (executor != null);
            Futures.addCallback((ListenableFuture)task, onCompletion, (Executor)executor);
        }
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)task);
            }
        });
    }

    private void closeCaptureFileInternal(CaptureHandle captureHandle, Runnable postCloseTask) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myOpenCaptureHandles.contains(captureHandle));
        assert (captureHandle.isWritable());
        assert (this.myAsyncWriterDelegate != null);
        try {
            this.myAsyncWriterDelegate.closeFileAndRunTaskAsynchronously(captureHandle, postCloseTask);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        this.myOpenCaptureHandles.remove(captureHandle);
        if (this.myOpenCaptureHandles.isEmpty()) {
            try {
                assert (this.myAsyncWriterDelegate != null);
                this.myAsyncWriterDelegate.queueExit();
                this.myAsyncWriterDelegate = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capture createCapture(Class<? extends CaptureType> clazz, byte[] data) throws IOException {
        CaptureHandle captureHandle = this.startCaptureFileSynchronous(clazz);
        try {
            CaptureService.appendDataSynchronous(captureHandle, data);
        }
        finally {
            captureHandle.closeFileOutputStream();
        }
        return this.createCapture(captureHandle);
    }

    public void addListener(CaptureListener listener) {
        this.myListeners.add(listener);
    }

    public void notifyCaptureReady(Capture capture) {
        for (CaptureListener listener : this.myListeners) {
            listener.onReady(capture);
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, capture.getFile());
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
    }

    private CaptureHandle startCaptureFileSynchronous(Class<? extends CaptureType> clazz) throws IOException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final CaptureType type = CaptureTypeService.getInstance().getType(clazz);
        assert (type != null);
        UsageTracker.getInstance().trackEvent("profiling", "captureCreated", type.getName(), null);
        File file = (File)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<File, IOException>(){

            public File compute() throws IOException {
                VirtualFile dir = CaptureService.this.createCapturesDirectory();
                return new File(dir.createChildData(null, type.createCaptureFileName()).getPath());
            }
        });
        return new CaptureHandle(file, type);
    }

    static void appendDataSynchronous(CaptureHandle captureHandle, byte[] data) throws IOException {
        FileOutputStream localFileOutputStream = captureHandle.getFileOutputStream();
        assert (localFileOutputStream != null);
        localFileOutputStream.write(data, 0, data.length);
    }

    private Capture createCapture(CaptureHandle captureHandle) throws IOException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!captureHandle.isWritable());
        final File file = captureHandle.getFile();
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return VfsUtil.findFileByIoFile((File)file, (boolean)true);
            }
        });
        if (vf == null) {
            throw new IOException("Cannot find virtual file for capture file \"" + file.getPath() + "\"");
        }
        CaptureType type = captureHandle.getCaptureType();
        Capture capture = type.createCapture(vf);
        this.myCaptures.put((Object)type, (Object)capture);
        return capture;
    }

    public static interface CaptureListener {
        public void onReady(Capture var1);
    }
}

