/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.utils.SdkUtils;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;

public abstract class FileCaptureType
extends CaptureType {
    private String myName;
    private Icon myIcon;
    private String myFileNamePrefix;
    private String myFileNameExtension;

    protected FileCaptureType(String name, Icon icon, String fileNamePrefix, String fileNameExtension) {
        this.myName = name;
        this.myIcon = icon;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameExtension = fileNameExtension;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public boolean isValidCapture(VirtualFile file) {
        return this.isValidCapture(file.getPath());
    }

    public boolean isValidCapture(String filePath) {
        return SdkUtils.endsWithIgnoreCase((String)filePath, (String)this.myFileNameExtension);
    }

    @Override
    public String createCaptureFileName() {
        return this.myFileNamePrefix + new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss").format(new Date()) + this.myFileNameExtension;
    }

    @Override
    protected Capture createCapture(VirtualFile file) {
        return new Capture(file, this);
    }
}

