/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.tools.idea.rendering.AarResourceClassGenerator;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.xml.AndroidManifest;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public class AarResourceClassRegistry
implements ProjectComponent {
    private final Map<AppResourceRepository, AarResourceClassGenerator> myGeneratorMap = Maps.newHashMap();
    private final Project myProject;
    private Collection<String> myPackages;

    public AarResourceClassRegistry(Project project) {
        this.myProject = project;
    }

    public void addLibrary(AppResourceRepository appResources, File aarDir) {
        FileResourceRepository repository;
        String path = aarDir.getPath();
        if ((path.endsWith(".aar") || path.contains("exploded-aar")) && (repository = appResources.findRepositoryFor(aarDir)) != null) {
            String pkg = AarResourceClassRegistry.getAarPackage(aarDir);
            if (pkg != null) {
                if (this.myPackages == null) {
                    this.myPackages = new HashSet();
                }
                this.myPackages.add(pkg);
            }
            if (!this.myGeneratorMap.containsKey((Object)appResources)) {
                AarResourceClassGenerator generator = AarResourceClassGenerator.create(appResources);
                this.myGeneratorMap.put(appResources, generator);
            }
        }
    }

    private static String getAarPackage(File aarDir) {
        File manifest = new File(aarDir, "AndroidManifest.xml");
        if (manifest.exists()) {
            try {
                return AndroidManifest.getPackage((IAbstractFile)new FileWrapper(manifest));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public byte[] findClassDefinition(String name, AppResourceRepository appRepo) {
        int index = name.lastIndexOf(46);
        if (index != -1 && name.charAt(index + 1) == 'R' && (index == name.length() - 2 || name.charAt(index + 2) == '$') && index > 1) {
            AarResourceClassGenerator generator;
            String pkg = name.substring(0, index);
            if (this.myPackages != null && this.myPackages.contains(pkg) && (generator = this.myGeneratorMap.get((Object)appRepo)) != null) {
                return generator.generate(name);
            }
        }
        return null;
    }

    public void clearCache() {
        this.myGeneratorMap.clear();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AppResourceRepository appResources = AppResourceRepository.getAppResources(module, false);
            if (appResources == null) continue;
            appResources.resetDynamicIds(false);
        }
    }

    void clearCache(AppResourceRepository appResources) {
        this.myGeneratorMap.remove((Object)appResources);
    }

    public static AarResourceClassRegistry get(Project project) {
        return (AarResourceClassRegistry)project.getComponent(AarResourceClassRegistry.class);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getComponentName() {
        return AarResourceClassRegistry.class.getName();
    }
}

