/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.lang.databinding.DbUtil;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;

public class AttributeSnapshot {
    public String namespace;
    public String prefix;
    public String name;
    public String value;

    AttributeSnapshot(String namespace, String prefix, String name, String value) {
        this.namespace = namespace;
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.name = name;
        this.value = value;
    }

    public static AttributeSnapshot createAttributeSnapshot(XmlAttribute psiAttribute) {
        String localName = psiAttribute.getLocalName();
        String namespace = psiAttribute.getNamespace();
        String prefix = psiAttribute.getNamespacePrefix();
        String value = psiAttribute.getValue();
        if (value != null && value.startsWith("@{") && (value = DbUtil.getBindingExprDefault(psiAttribute)) == null) {
            return null;
        }
        return new AttributeSnapshot(namespace, prefix, localName, value);
    }

    public static List<AttributeSnapshot> createAttributesForTag(XmlTag tag) {
        XmlAttribute[] psiAttributes = tag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public String toString() {
        return "AttributeSnapshot{" + this.name + "=\"" + this.value + "\"}";
    }
}

