/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.builder.model.Variant;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.rendering.DynamicResourceValueItem;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;

public class DynamicResourceValueRepository
extends LocalResourceRepository
implements GradleSyncListener,
BuildVariantView.BuildVariantSelectionChangeListener {
    private final AndroidFacet myFacet;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> mItems = Maps.newEnumMap(ResourceType.class);

    private DynamicResourceValueRepository(AndroidFacet facet) {
        super("Gradle Dynamic");
        this.myFacet = facet;
        assert (facet.requiresAndroidModel());
        facet.addListener(this);
        BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(this);
    }

    public static DynamicResourceValueRepository create(AndroidFacet facet) {
        return new DynamicResourceValueRepository(facet);
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        if (this.mItems.isEmpty()) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel == null) {
                return this.mItems;
            }
            Variant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                this.addValues(buildType.getBuildType().getResValues());
            }
            this.addValues(selectedVariant.getMergedFlavor().getResValues());
        }
        return this.mItems;
    }

    private void notifyGradleSynced() {
        this.mItems.clear();
        super.invalidateItemCaches(new ResourceType[0]);
    }

    private void addValues(Map<String, ClassField> resValues) {
        for (Map.Entry<String, ClassField> entry : resValues.entrySet()) {
            ClassField field = entry.getValue();
            String name = field.getName();
            assert (entry.getKey().equals(name)) : entry.getKey() + " vs " + name;
            ResourceType type = ResourceType.getEnum((String)field.getType());
            if (type == null) {
                LOG.warn("Ignoring field " + name + "(" + field + "): unknown type " + field.getType());
                continue;
            }
            ArrayListMultimap map = this.mItems.get(type);
            if (map == null) {
                map = ArrayListMultimap.create();
                this.mItems.put(type, (ListMultimap<String, ResourceItem>)map);
            } else if (map.containsKey((Object)name)) continue;
            DynamicResourceValueItem item = new DynamicResourceValueItem(type, field);
            map.put((Object)name, (Object)item);
        }
    }

    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap;
        if (this.mItems.isEmpty()) {
            this.getMap();
        }
        if ((multimap = this.mItems.get(type)) == null && create) {
            multimap = ArrayListMultimap.create();
            this.mItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    @Override
    public void syncStarted(Project project) {
    }

    @Override
    public void syncSucceeded(Project project) {
        this.notifyGradleSynced();
    }

    @Override
    public void syncFailed(Project project, String errorMessage) {
    }

    @Override
    public void syncSkipped(Project project) {
    }

    @Override
    public void buildVariantsConfigChanged() {
        this.notifyGradleSynced();
    }
}

