/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.res2.DuplicateDataException;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourceSet;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.tools.idea.rendering.RDotTxtParser;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SoftValueHashMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public class FileResourceRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(FileResourceRepository.class);
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myItems = Maps.newEnumMap(ResourceType.class);
    protected Collection<String> myAarDeclaredIds;
    private final File myFile;
    private File myResourceTextFile;
    private static final SoftValueHashMap<File, FileResourceRepository> ourCache = new SoftValueHashMap();

    private FileResourceRepository(File file) {
        super(file.getName());
        this.myFile = file;
    }

    static FileResourceRepository get(File file) {
        FileResourceRepository repository = (FileResourceRepository)((Object)ourCache.get((Object)file));
        if (repository == null) {
            repository = FileResourceRepository.create(file);
            ourCache.put((Object)file, (Object)repository);
        }
        return repository;
    }

    static FileResourceRepository getCached(File file) {
        return (FileResourceRepository)((Object)ourCache.get((Object)file));
    }

    private static FileResourceRepository create(File file) {
        File rDotTxt;
        FileResourceRepository repository = new FileResourceRepository(file);
        try {
            ResourceMerger resourceMerger = FileResourceRepository.createResourceMerger(file);
            resourceMerger.mergeData(repository.createMergeConsumer(), true);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize resources", (Throwable)e);
        }
        if (file.getPath().contains("exploded-aar") && (rDotTxt = new File(file.getParentFile(), "R.txt")).exists()) {
            repository.myResourceTextFile = rDotTxt;
            repository.myAarDeclaredIds = RDotTxtParser.getIdNames(rDotTxt);
        }
        return repository;
    }

    File getResourceTextFile() {
        return this.myResourceTextFile;
    }

    public static void reset() {
        ourCache.clear();
    }

    public File getResourceDirectory() {
        return this.myFile;
    }

    private static ResourceMerger createResourceMerger(File file) {
        LogWrapper logger = new LogWrapper(LOG);
        ResourceMerger merger = new ResourceMerger();
        ResourceSet resourceSet = new ResourceSet(file.getName(), false);
        resourceSet.addSource(file);
        try {
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        merger.addDataSet(resourceSet);
        return merger;
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        return this.myItems;
    }

    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap = this.myItems.get(type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.myItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    protected Collection<String> getAllDeclaredIds() {
        return this.myAarDeclaredIds;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myFile + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }
}

