/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.google.common.collect.Maps;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Function;
import icons.AndroidIcons;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FlagManager {
    private static final FlagManager ourInstance = new FlagManager();
    private final Map<String, Icon> myImageMap = Maps.newHashMap();
    private static boolean ourFlagSettingAvailable = true;
    private static Field ourLanguageFlagField;

    public static FlagManager get() {
        return ourInstance;
    }

    private FlagManager() {
    }

    public Icon getFlag(String language, String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty()) {
            assert (language != null);
            if (!FlagManager.showFlagsForLanguages()) {
                return null;
            }
            if (language.equals("ca")) {
                return this.getIcon("catalonia");
            }
            if (language.equals("gd")) {
                return this.getIcon("scotland");
            }
            if (language.equals("cy")) {
                return this.getIcon("wales");
            }
            region = LocaleManager.getLanguageRegion((String)language);
        }
        if (region == null || region.isEmpty() || region.length() == 3) {
            return null;
        }
        return this.getIcon(region);
    }

    private static boolean showFlagsForLanguages() {
        if (ourFlagSettingAvailable) {
            try {
                if (ourLanguageFlagField == null) {
                    ourLanguageFlagField = UISettings.class.getDeclaredField("LANGUAGE_FLAGS");
                }
                return ourLanguageFlagField.getBoolean(UISettings.getInstance());
            }
            catch (Throwable t) {
                ourFlagSettingAvailable = false;
                return true;
            }
        }
        return true;
    }

    public Icon getFlag(FolderConfiguration configuration) {
        return this.getFlag(configuration.getLocaleQualifier());
    }

    public Icon getFlag(LocaleQualifier locale) {
        if (locale == null) {
            return null;
        }
        String languageCode = locale.getLanguage();
        String regionCode = locale.getRegion();
        if ("__".equals(languageCode)) {
            languageCode = null;
        }
        return this.getFlag(languageCode, regionCode);
    }

    public Icon getFlagForFolderName(String folder) {
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)folder);
        if (configuration != null) {
            return FlagManager.get().getFlag(configuration);
        }
        return null;
    }

    public Icon getFlag(String region) {
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    private Icon getIcon(String base) {
        Icon flagImage = this.myImageMap.get(base);
        if (flagImage == null) {
            if (this.myImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = base.toLowerCase(Locale.US) + ".png";
            try {
                flagImage = IconLoader.findIcon((String)("/icons/flags/" + flagFileName), AndroidIcons.class);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (flagImage == null) {
                flagImage = AndroidIcons.EmptyFlag;
            }
            this.myImageMap.put(base, flagImage);
        }
        return flagImage;
    }

    public ListCellRenderer getLanguageCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getLanguageNameMapper();
        return new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)nameMapper.fun(value));
                this.setIcon(FlagManager.this.getFlag((String)value, null));
            }
        };
    }

    public ListCellRenderer getRegionCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getRegionNameMapper();
        return new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)nameMapper.fun(value));
                this.setIcon(FlagManager.this.getFlag(null, (String)value));
            }
        };
    }

    public static Function<Object, String> getLanguageNameMapper() {
        return new Function<Object, String>(){

            public String fun(Object value) {
                String languageCode = (String)value;
                if (languageCode.equals("__")) {
                    return "Any Language";
                }
                String languageName = LocaleManager.getLanguageName((String)languageCode);
                if (languageName != null && languageName.length() > 30) {
                    languageName = languageName.substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", languageCode, languageName);
            }
        };
    }

    public static Function<Object, String> getRegionNameMapper() {
        return new Function<Object, String>(){

            public String fun(Object value) {
                String regionCode = (String)value;
                if (regionCode.equals("__")) {
                    return "Any Region";
                }
                String regionName = LocaleManager.getRegionName((String)regionCode);
                if (regionName != null && regionName.length() > 30) {
                    regionName = regionName.substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", regionCode, regionName);
            }
        };
    }
}

