/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ReplaceTagFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.android.utils.SparseArray;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.android.uipreview.ChooseResourceDialog;

public class HtmlLinkManager {
    private static final String URL_EDIT_CLASSPATH = "action:classpath";
    private static final String URL_BUILD = "action:build";
    private static final String URL_SYNC = "action:sync";
    private static final String URL_SHOW_XML = "action:showXml";
    private static final String URL_ACTION_IGNORE_FRAGMENTS = "action:ignoreFragment";
    private static final String URL_RUNNABLE = "runnable:";
    private static final String URL_COMMAND = "command:";
    private static final String URL_REPLACE_TAGS = "replaceTags:";
    private static final String URL_SHOW_TAG = "showTag:";
    private static final String URL_OPEN = "open:";
    private static final String URL_CREATE_CLASS = "createClass:";
    private static final String URL_OPEN_CLASS = "openClass:";
    private static final String URL_ASSIGN_FRAGMENT_URL = "assignFragmentUrl:";
    private static final String URL_ASSIGN_LAYOUT_URL = "assignLayoutUrl:";
    private static final String URL_EDIT_ATTRIBUTE = "editAttribute:";
    private static final String URL_REPLACE_ATTRIBUTE_VALUE = "replaceAttributeValue:";
    private static final String URL_DISABLE_SANDBOX = "disableSandbox:";
    private static final String URL_REFRESH_RENDER = "refreshRender";
    static final String URL_ACTION_CLOSE = "action:close";
    private SparseArray<Runnable> myLinkRunnables;
    private SparseArray<WriteCommandAction> myLinkCommands;
    private int myNextLinkId = 0;

    public void handleUrl(String url, Module module, PsiFile file, DataContext dataContext, RenderResult result) {
        if (url.startsWith("http:") || url.startsWith("https:")) {
            BrowserLauncher.getInstance().browse(url, null, module == null ? null : module.getProject());
        } else if (url.startsWith("file:")) {
            assert (module != null);
            HtmlLinkManager.handleFileUrl(url, module);
        } else if (url.startsWith(URL_REPLACE_TAGS)) {
            assert (module != null);
            assert (file != null);
            HtmlLinkManager.handleReplaceTagsUrl(url, module, file);
        } else if (url.equals(URL_BUILD)) {
            assert (dataContext != null);
            assert (module != null);
            HtmlLinkManager.handleCompileModuleUrl(url, module);
        } else if (url.equals(URL_SYNC)) {
            assert (dataContext != null);
            assert (module != null);
            HtmlLinkManager.handleSyncProjectUrl(url, module.getProject());
        } else if (url.equals(URL_EDIT_CLASSPATH)) {
            assert (module != null);
            HtmlLinkManager.handleEditClassPathUrl(url, module);
        } else if (url.startsWith(URL_CREATE_CLASS)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleNewClassUrl(url, module);
        } else if (url.startsWith(URL_OPEN)) {
            assert (module != null);
            HtmlLinkManager.handleOpenStackUrl(url, module);
        } else if (url.startsWith(URL_OPEN_CLASS)) {
            assert (module != null);
            HtmlLinkManager.handleOpenClassUrl(url, module);
        } else if (url.equals(URL_SHOW_XML)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleShowXmlUrl(url, module, file);
        } else if (url.startsWith(URL_SHOW_TAG)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleShowTagUrl(url, module, file);
        } else if (url.startsWith(URL_ASSIGN_FRAGMENT_URL)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleAssignFragmentUrl(url, module, file);
        } else if (url.startsWith(URL_ASSIGN_LAYOUT_URL)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleAssignLayoutUrl(url, module, file);
        } else if (url.equals(URL_ACTION_IGNORE_FRAGMENTS)) {
            assert (result != null);
            HtmlLinkManager.handleIgnoreFragments(url, result);
        } else if (url.startsWith(URL_EDIT_ATTRIBUTE)) {
            assert (result != null);
            if (module != null && file != null) {
                HtmlLinkManager.handleEditAttribute(url, module, file);
            }
        } else if (url.startsWith(URL_REPLACE_ATTRIBUTE_VALUE)) {
            assert (result != null);
            if (module != null && file != null) {
                HtmlLinkManager.handleReplaceAttributeValue(url, module, file);
            }
        } else if (url.startsWith(URL_DISABLE_SANDBOX)) {
            assert (module != null);
            HtmlLinkManager.handleDisableSandboxUrl(module, result);
        } else if (url.startsWith(URL_RUNNABLE)) {
            Runnable linkRunnable = this.getLinkRunnable(url);
            if (linkRunnable != null) {
                linkRunnable.run();
            }
        } else if (url.startsWith(URL_COMMAND)) {
            WriteCommandAction command = this.getLinkCommand(url);
            if (command != null) {
                command.execute();
            }
        } else if (url.startsWith(URL_REFRESH_RENDER)) {
            HtmlLinkManager.handleRefreshRenderUrl(result);
        } else assert (false) : "Unexpected URL: " + url;
    }

    public static String createFilePositionUrl(File file, int line, int column) {
        try {
            String fileUrl = SdkUtils.fileToUrlString((File)file);
            if (line != -1) {
                if (column > 0) {
                    return fileUrl + ':' + line + ':' + column;
                }
                return fileUrl + ':' + line;
            }
            return fileUrl;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(HtmlLinkManager.class).error((Throwable)e);
            return null;
        }
    }

    private static void handleFileUrl(String url, Module module) {
        Project project = module.getProject();
        try {
            int line = -1;
            int column = 0;
            Pattern pattern = Pattern.compile(".*:(\\d+)(:(\\d+))");
            Matcher matcher = pattern.matcher(url);
            if (matcher.matches()) {
                line = Integer.parseInt(matcher.group(1));
                column = Integer.parseInt(matcher.group(3));
                url = url.substring(0, matcher.start(1) - 1);
            } else {
                matcher = Pattern.compile(".*:(\\d+)").matcher(url);
                if (matcher.matches()) {
                    line = Integer.parseInt(matcher.group(1));
                    url = url.substring(0, matcher.start(1) - 1);
                }
            }
            File ioFile = SdkUtils.urlToFile((String)url);
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file != null) {
                HtmlLinkManager.openEditor(project, file, line, column);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String createCommandLink(WriteCommandAction command) {
        String url = URL_COMMAND + this.myNextLinkId;
        if (this.myLinkCommands == null) {
            this.myLinkCommands = new SparseArray(5);
        }
        this.myLinkCommands.put(this.myNextLinkId, (Object)command);
        ++this.myNextLinkId;
        return url;
    }

    private WriteCommandAction getLinkCommand(String url) {
        if (this.myLinkCommands != null && url.startsWith(URL_COMMAND)) {
            String idString = url.substring(URL_COMMAND.length());
            int id = Integer.decode(idString);
            return (WriteCommandAction)this.myLinkCommands.get(id);
        }
        return null;
    }

    public String createRunnableLink(Runnable runnable) {
        String url = URL_RUNNABLE + this.myNextLinkId;
        if (this.myLinkRunnables == null) {
            this.myLinkRunnables = new SparseArray(5);
        }
        this.myLinkRunnables.put(this.myNextLinkId, (Object)runnable);
        ++this.myNextLinkId;
        return url;
    }

    private Runnable getLinkRunnable(String url) {
        if (this.myLinkRunnables != null && url.startsWith(URL_RUNNABLE)) {
            String idString = url.substring(URL_RUNNABLE.length());
            int id = Integer.decode(idString);
            return (Runnable)this.myLinkRunnables.get(id);
        }
        return null;
    }

    public String createReplaceTagsUrl(String from, String to) {
        return URL_REPLACE_TAGS + from + '/' + to;
    }

    private static void handleReplaceTagsUrl(String url, Module module, PsiFile file) {
        assert (url.startsWith(URL_REPLACE_TAGS)) : url;
        int start = URL_REPLACE_TAGS.length();
        int delimiterPos = url.indexOf(47, start);
        if (delimiterPos != -1) {
            String wrongTag = url.substring(start, delimiterPos);
            String rightTag = url.substring(delimiterPos + 1);
            ReplaceTagFix fix = new ReplaceTagFix(module.getProject(), (XmlFile)file, wrongTag, rightTag);
            fix.execute();
        }
    }

    public String createCompileModuleUrl() {
        return URL_BUILD;
    }

    private static void handleCompileModuleUrl(String url, Module module) {
        assert (url.equals(URL_BUILD)) : url;
        GradleProjectBuilder.getInstance(module.getProject()).compileJava();
    }

    public String createSyncProjectUrl() {
        return URL_SYNC;
    }

    private static void handleSyncProjectUrl(String url, Project project) {
        assert (url.equals(URL_SYNC)) : url;
        BuildVariantView.getInstance(project).projectImportStarted();
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }

    public String createEditClassPathUrl() {
        return URL_EDIT_CLASSPATH;
    }

    private static void handleEditClassPathUrl(String url, Module module) {
        assert (url.equals(URL_EDIT_CLASSPATH)) : url;
        ProjectSettingsService.getInstance((Project)module.getProject()).openModuleSettings(module);
    }

    public String createOpenClassUrl(String className) {
        return URL_OPEN_CLASS + className;
    }

    private static void handleOpenClassUrl(String url, Module module) {
        PsiFile containingFile;
        assert (url.startsWith(URL_OPEN_CLASS)) : url;
        String className = url.substring(URL_OPEN_CLASS.length());
        Project project = module.getProject();
        PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (clz != null && (containingFile = clz.getContainingFile()) != null) {
            HtmlLinkManager.openEditor(project, containingFile, clz.getTextOffset());
        }
    }

    public String createShowXmlUrl() {
        return URL_SHOW_XML;
    }

    private static void handleShowXmlUrl(String url, Module module, PsiFile file) {
        assert (url.equals(URL_SHOW_XML)) : url;
        HtmlLinkManager.openEditor(module.getProject(), file, 0, -1);
    }

    public String createShowTagUrl(String tag) {
        return URL_SHOW_TAG + tag;
    }

    private static void handleShowTagUrl(String url, Module module, final PsiFile file) {
        assert (url.startsWith(URL_SHOW_TAG)) : url;
        final String tagName = url.substring(URL_SHOW_TAG.length());
        XmlTag first = (XmlTag)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XmlTag>(){

            public XmlTag compute() {
                Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
                for (XmlTag tag : xmlTags) {
                    if (!tagName.equals(tag.getName())) continue;
                    return tag;
                }
                return null;
            }
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first);
        } else {
            HtmlLinkManager.openEditor(module.getProject(), file, 0, -1);
        }
    }

    public String createNewClassUrl(String className) {
        return URL_CREATE_CLASS + className;
    }

    private static void handleNewClassUrl(String url, Module module) {
        PsiFile file;
        PsiClass newClass;
        PsiDirectory targetDirectory;
        String packageName;
        String className;
        assert (url.startsWith(URL_CREATE_CLASS)) : url;
        String s = url.substring(URL_CREATE_CLASS.length());
        final Project project = module.getProject();
        String title = "Create Custom View";
        int index = s.lastIndexOf(46);
        if (index == -1) {
            className = s;
            packageName = ManifestInfo.get(module, false).getPackage();
            if (packageName == null) {
                return;
            }
        } else {
            packageName = s.substring(0, index);
            className = s.substring(index + 1);
        }
        CreateClassDialog dialog = new CreateClassDialog(project, title, className, packageName, (ClassKind)CreateClassKind.CLASS, true, module){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog.show();
        if (dialog.getExitCode() == 0 && (targetDirectory = dialog.getTargetDirectory()) != null && (newClass = (PsiClass)new WriteCommandAction<PsiClass>(project, "Create Class", new PsiFile[0]){

            protected void run(Result<PsiClass> result) throws Throwable {
                PsiClass targetClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
                PsiManager manager = PsiManager.getInstance((Project)project);
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
                PsiElementFactory factory = facade.getElementFactory();
                PsiJavaCodeReferenceElement superclassReference = factory.createReferenceElementByFQClassName("android.view.View", targetClass.getResolveScope());
                PsiReferenceList extendsList = targetClass.getExtendsList();
                if (extendsList != null) {
                    extendsList.add((PsiElement)superclassReference);
                }
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                PsiJavaFile javaFile = (PsiJavaFile)targetClass.getContainingFile();
                PsiImportList importList = javaFile.getImportList();
                if (importList != null) {
                    PsiClass attributeSetClass;
                    PsiClass contextClass = JavaPsiFacade.getInstance((Project)project).findClass("android.content.Context", scope);
                    if (contextClass != null) {
                        importList.add((PsiElement)factory.createImportStatement(contextClass));
                    }
                    if ((attributeSetClass = JavaPsiFacade.getInstance((Project)project).findClass("android.util.AttributeSet", scope)) != null) {
                        importList.add((PsiElement)factory.createImportStatement(attributeSetClass));
                    }
                }
                PsiMethod constructor = factory.createMethodFromText("public " + className + "(Context context, AttributeSet attrs, int defStyle) {\n" + "  super(context, attrs, defStyle);\n" + "}\n", (PsiElement)targetClass);
                targetClass.add((PsiElement)constructor);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                PsiFile containingFile = targetClass.getContainingFile();
                if (containingFile != null) {
                    codeStyleManager.reformat((PsiElement)javaFile);
                }
                result.setResult((Object)targetClass);
            }
        }.execute().getResultObject()) != null && (file = newClass.getContainingFile()) != null) {
            HtmlLinkManager.openEditor(project, file, newClass.getTextOffset());
        }
    }

    public String createOpenStackUrl(String className, String methodName, String fileName, int lineNumber) {
        return URL_OPEN + className + '#' + methodName + ';' + fileName + ':' + lineNumber;
    }

    private static void handleOpenStackUrl(String url, Module module) {
        Project project;
        PsiClass clz;
        int line;
        String fileName;
        String className;
        assert (url.startsWith(URL_OPEN)) : url;
        int start = URL_OPEN.length();
        int semi = url.indexOf(59, start);
        if (semi != -1) {
            className = url.substring(start, semi);
            int colon = url.indexOf(58, semi + 1);
            if (colon != -1) {
                fileName = url.substring(semi + 1, colon);
                line = Integer.decode(url.substring(colon + 1));
            } else {
                fileName = url.substring(semi + 1);
                line = -1;
            }
        } else {
            className = url.substring(start);
            fileName = null;
            line = -1;
        }
        String method = null;
        int hash = className.indexOf(35);
        if (hash != -1) {
            method = className.substring(hash + 1);
            className = className.substring(0, hash);
        }
        if ((clz = JavaPsiFacade.getInstance((Project)(project = module.getProject())).findClass(className, GlobalSearchScope.allScope((Project)project))) != null) {
            String name;
            VirtualFile virtualFile;
            PsiFile containingFile = clz.getContainingFile();
            if (fileName != null && containingFile != null && line != -1 && (virtualFile = containingFile.getVirtualFile()) != null && fileName.equals(name = virtualFile.getName())) {
                HtmlLinkManager.openEditor(project, containingFile, line - 1, -1);
                return;
            }
            if (method != null) {
                PsiMethod[] methodsByName;
                for (PsiMethod psiMethod : methodsByName = clz.findMethodsByName(method, true)) {
                    VirtualFile virtualFile2;
                    PsiFile psiFile = psiMethod.getContainingFile();
                    if (psiFile == null || (virtualFile2 = psiFile.getVirtualFile()) == null) continue;
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile2, psiMethod.getTextOffset());
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
                    return;
                }
            }
            if (fileName != null) {
                PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                for (PsiMethod psiMethod : files) {
                    if (HtmlLinkManager.openEditor(project, (PsiFile)psiMethod, line != -1 ? line - 1 : -1, -1)) break;
                }
            }
        }
    }

    private static boolean openEditor(Project project, PsiFile psiFile, int line, int column) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            return HtmlLinkManager.openEditor(project, file, line, column);
        }
        return false;
    }

    private static boolean openEditor(Project project, VirtualFile file, int line, int column) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, line, column);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor, true).isEmpty();
    }

    private static boolean openEditor(Project project, PsiFile psiFile, int offset) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            return HtmlLinkManager.openEditor(project, file, offset);
        }
        return false;
    }

    private static boolean openEditor(Project project, VirtualFile file, int offset) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, offset);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor, true).isEmpty();
    }

    public String createAssignFragmentUrl(String id) {
        return URL_ASSIGN_FRAGMENT_URL + (id != null ? id : "");
    }

    private static String getFragmentClass(final Module module, final String fqcn) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                String jvmClassName;
                Project project = module.getProject();
                JavaPsiFacade finder = JavaPsiFacade.getInstance((Project)project);
                PsiClass psiClass = finder.findClass(fqcn, module.getModuleScope());
                if (psiClass == null) {
                    psiClass = finder.findClass(fqcn, GlobalSearchScope.allScope((Project)project));
                }
                if (psiClass != null && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)psiClass)) != null) {
                    return jvmClassName.replace('/', '.');
                }
                return fqcn;
            }
        });
    }

    private static void handleAssignFragmentUrl(String url, Module module, final PsiFile file) {
        assert (url.startsWith(URL_ASSIGN_FRAGMENT_URL)) : url;
        String className = ChooseClassDialog.openDialog(module, "Fragments", true, "android.app.Fragment", "android.support.v4.app.Fragment");
        if (className == null) {
            return;
        }
        final String fragmentClass = HtmlLinkManager.getFragmentClass(module, className);
        int start = URL_ASSIGN_FRAGMENT_URL.length();
        final String id = start == url.length() ? null : LintUtils.stripIdPrefix((String)url.substring(start));
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(module.getProject(), "Assign Fragment", new PsiFile[]{file}){

            protected void run(Result<Void> result) throws Throwable {
                Collection tags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
                for (XmlTag tag : tags) {
                    String tagId;
                    if (!tag.getName().equals("fragment") || id != null && ((tagId = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")) == null || !tagId.endsWith(id) || !id.equals(LintUtils.stripIdPrefix((String)tagId))) || tag.getAttribute("name", "http://schemas.android.com/apk/res/android") != null || tag.getAttribute("class") != null) continue;
                    tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                    return;
                }
                if (id == null) {
                    for (XmlTag tag : tags) {
                        if (!tag.getName().equals("fragment")) continue;
                        tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                        break;
                    }
                }
            }
        };
        action.execute();
    }

    public String createPickLayoutUrl(String activityName) {
        return URL_ASSIGN_LAYOUT_URL + activityName;
    }

    public String createAssignLayoutUrl(String activityName, String layout) {
        return URL_ASSIGN_LAYOUT_URL + activityName + ':' + layout;
    }

    private static void handleAssignLayoutUrl(String url, Module module, PsiFile file) {
        assert (url.startsWith(URL_ASSIGN_LAYOUT_URL)) : url;
        int start = URL_ASSIGN_LAYOUT_URL.length();
        int layoutStart = url.indexOf(58, start + 1);
        Project project = module.getProject();
        XmlFile xmlFile = (XmlFile)file;
        if (layoutStart == -1) {
            String activityName = url.substring(start);
            HtmlLinkManager.pickLayout(module, xmlFile, activityName);
        } else {
            String activityName = url.substring(start, layoutStart);
            String layoutName = url.substring(layoutStart + 1);
            String layout = "@layout/" + layoutName;
            HtmlLinkManager.assignLayout(project, xmlFile, activityName, layout);
        }
    }

    private static void pickLayout(Module module, XmlFile file, String activityName) {
        String layout;
        ChooseResourceDialog dialog = new ChooseResourceDialog(module, new ResourceType[]{ResourceType.LAYOUT}, null, null){

            @Override
            protected Action[] createLeftSideActions() {
                return new Action[0];
            }
        };
        if (dialog.showAndGet() && !(layout = dialog.getResourceName()).equals("@layout/" + file.getName())) {
            HtmlLinkManager.assignLayout(module.getProject(), file, activityName, layout);
        }
    }

    private static void assignLayout(Project project, final XmlFile file, final String activityName, final String layout) {
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(project, "Assign Preview Layout", new PsiFile[]{file}){

            protected void run(Result<Void> result) throws Throwable {
                SuppressLintIntentionAction.ensureNamespaceImported(this.getProject(), file, "http://schemas.android.com/tools");
                Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
                for (XmlTag tag : xmlTags) {
                    if (!tag.getName().equals("fragment")) continue;
                    String name = tag.getAttributeValue("class");
                    if (name == null || name.isEmpty()) {
                        name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                    }
                    if (!activityName.equals(name)) continue;
                    tag.setAttribute("layout", "http://schemas.android.com/tools", layout);
                }
            }
        };
        action.execute();
    }

    public String createIgnoreFragmentsUrl() {
        return URL_ACTION_IGNORE_FRAGMENTS;
    }

    private static void handleIgnoreFragments(String url, RenderResult result) {
        assert (url.equals(URL_ACTION_IGNORE_FRAGMENTS));
        RenderLogger.ignoreFragments();
        HtmlLinkManager.requestRender(result);
    }

    public String createEditAttributeUrl(String attribute, String value) {
        return URL_EDIT_ATTRIBUTE + attribute + '/' + value;
    }

    private static void handleEditAttribute(String url, Module module, final PsiFile file) {
        assert (url.startsWith(URL_EDIT_ATTRIBUTE));
        int attributeStart = URL_EDIT_ATTRIBUTE.length();
        int valueStart = url.indexOf(47);
        final String attributeName = url.substring(attributeStart, valueStart);
        final String value = url.substring(valueStart + 1);
        XmlAttribute first = (XmlAttribute)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XmlAttribute>(){

            public XmlAttribute compute() {
                Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlAttribute.class);
                for (XmlAttribute attribute : attributes) {
                    if (!attributeName.equals(attribute.getLocalName()) || !value.equals(attribute.getValue())) continue;
                    return attribute;
                }
                return null;
            }
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first.getValueElement());
        } else {
            HtmlLinkManager.openEditor(module.getProject(), file, 0, -1);
        }
    }

    public String createReplaceAttributeValueUrl(String attribute, String oldValue, String newValue) {
        return URL_REPLACE_ATTRIBUTE_VALUE + attribute + '/' + oldValue + '/' + newValue;
    }

    private static void handleReplaceAttributeValue(String url, Module module, final PsiFile file) {
        assert (url.startsWith(URL_REPLACE_ATTRIBUTE_VALUE));
        int attributeStart = URL_REPLACE_ATTRIBUTE_VALUE.length();
        int valueStart = url.indexOf(47);
        int newValueStart = url.indexOf(47, valueStart + 1);
        final String attributeName = url.substring(attributeStart, valueStart);
        final String oldValue = url.substring(valueStart + 1, newValueStart);
        final String newValue = url.substring(newValueStart + 1);
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(module.getProject(), "Set Attribute Value", new PsiFile[]{file}){

            protected void run(Result<Void> result) throws Throwable {
                Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlAttribute.class);
                int oldValueLen = oldValue.length();
                for (XmlAttribute attribute : attributes) {
                    String attributeValue;
                    if (!attributeName.equals(attribute.getLocalName()) || (attributeValue = attribute.getValue()) == null) continue;
                    if (oldValue.equals(attributeValue)) {
                        attribute.setValue(newValue);
                        continue;
                    }
                    int index = attributeValue.indexOf(oldValue);
                    if (index == -1 || index != 0 && attributeValue.charAt(index - 1) != '|' || index + oldValueLen != attributeValue.length() && attributeValue.charAt(index + oldValueLen) != '|') continue;
                    attributeValue = attributeValue.substring(0, index) + newValue + attributeValue.substring(index + oldValueLen);
                    attribute.setValue(attributeValue);
                }
            }
        };
        action.execute();
    }

    public String createDisableSandboxUrl() {
        return URL_DISABLE_SANDBOX;
    }

    private static void handleDisableSandboxUrl(Module module, RenderResult result) {
        RenderSecurityManager.sEnabled = false;
        HtmlLinkManager.requestRender(result);
        Messages.showInfoMessage((Project)module.getProject(), (String)"The custom view rendering sandbox was disabled for this session.\n\nYou can turn it off permanently by adding\nandroid.render.sandbox=false\nto {install}/bin/idea.properties.", (String)"Disabled Rendering Sandbox");
    }

    public String createRefreshRenderUrl() {
        return URL_REFRESH_RENDER;
    }

    private static void handleRefreshRenderUrl(RenderResult result) {
        RenderContext renderContext;
        RenderTask renderTask;
        if (result != null && (renderTask = result.getRenderTask()) != null && (renderContext = renderTask.getRenderContext()) != null) {
            RefreshRenderAction.clearCache(renderContext);
        }
    }

    private static void requestRender(RenderResult result) {
        RenderContext renderContext;
        RenderTask renderTask;
        if (result != null && (renderTask = result.getRenderTask()) != null && (renderContext = renderTask.getRenderContext()) != null) {
            renderContext.requestRender();
        }
    }
}

