/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageUtils {
    public static final double EPSILON = 1.0E-5;
    private static boolean ourRetinaCapable = true;

    public static BufferedImage rotateByRightAngle(BufferedImage source, int degrees) {
        int h1;
        int w1;
        assert (degrees % 90 == 0);
        int w = source.getWidth();
        int h = source.getHeight();
        switch (degrees %= 360) {
            case 90: 
            case 270: {
                w1 = h;
                h1 = w;
                break;
            }
            default: {
                w1 = w;
                h1 = h;
            }
        }
        BufferedImage rotated = new BufferedImage(w1, h1, source.getType());
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int y1;
                int x1;
                int v = source.getRGB(x, y);
                switch (degrees) {
                    case 90: {
                        x1 = h - y - 1;
                        y1 = x;
                        break;
                    }
                    case 180: {
                        x1 = w - x - 1;
                        y1 = h - y - 1;
                        break;
                    }
                    case 270: {
                        x1 = y;
                        y1 = w - x - 1;
                        break;
                    }
                    default: {
                        x1 = x;
                        y1 = y;
                    }
                }
                rotated.setRGB(x1, y1, v);
            }
        }
        return rotated;
    }

    public static boolean isRetinaImage(BufferedImage image) {
        if (image == null) {
            return false;
        }
        return image instanceof JBHiDPIScaledImage || SystemInfo.isAppleJvm && UIUtil.isAppleRetina() && BufferedImage.class != image.getClass();
    }

    public static BufferedImage createDipImage(int width, int height, int type) {
        return UIUtil.createImage((int)width, (int)height, (int)type);
    }

    public static boolean supportsRetina() {
        return ourRetinaCapable;
    }

    public static BufferedImage convertToRetina(BufferedImage image) {
        int scale = 2;
        if (image.getWidth() < 2 || image.getHeight() < 2) {
            return null;
        }
        try {
            Image retina = RetinaImage.createFrom((Image)image, (int)2, null);
            if (!(retina instanceof BufferedImage)) {
                ourRetinaCapable = false;
                return null;
            }
            return (BufferedImage)retina;
        }
        catch (Throwable t) {
            ourRetinaCapable = false;
            return null;
        }
    }

    public static void drawDipImage(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    public static BufferedImage addMargin(BufferedImage source, int marginSize) {
        int destWidth = source.getWidth() + 2 * marginSize;
        int destHeight = source.getHeight() + 2 * marginSize;
        int type = source.getColorModel().hasAlpha() ? source.getType() : 2;
        BufferedImage expanded = new BufferedImage(destWidth, destHeight, type);
        Graphics2D g2 = expanded.createGraphics();
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth, destHeight);
        g2.drawImage((Image)source, marginSize, marginSize, null);
        g2.dispose();
        return expanded;
    }

    public static BufferedImage scale(BufferedImage source, double xScale, double yScale) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0);
    }

    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, Shape clip) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0, clip);
    }

    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin) {
        return ImageUtils.scale(source, xScale, yScale, rightMargin, bottomMargin, null);
    }

    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin, Shape clip) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        if (xScale > 0.5 && yScale > 0.5) {
            BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
            Graphics2D g2 = scaled.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, true));
            g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
            if (clip != null) {
                g2.setClip(clip);
            }
            if (xScale == 1.0 && yScale == 1.0) {
                g2.drawImage((Image)source, 0, 0, null);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
            }
            g2.dispose();
            return scaled;
        }
        int iterations = 0;
        int nearestWidth = destWidth;
        int nearestHeight = destHeight;
        while (nearestWidth < sourceWidth / 2) {
            nearestWidth *= 2;
            nearestHeight *= 2;
            ++iterations;
        }
        if (iterations == 0) {
            nearestWidth += rightMargin;
            nearestHeight += bottomMargin;
        }
        BufferedImage scaled = new BufferedImage(nearestWidth, nearestHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source, 0, 0, nearestWidth, nearestHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        sourceWidth = nearestWidth;
        sourceHeight = nearestHeight;
        source = scaled;
        for (int iteration = iterations - 1; iteration >= 0; --iteration) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            if (iteration == 0) {
                scaled = new BufferedImage(halfWidth + rightMargin, halfHeight + bottomMargin, imageType);
                g2 = scaled.createGraphics();
                if (clip != null) {
                    g2.setClip(clip);
                }
            } else {
                scaled = new BufferedImage(halfWidth, halfHeight, imageType);
                g2 = scaled.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source, 0, 0, halfWidth, halfHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            sourceWidth = halfWidth;
            sourceHeight = halfHeight;
            source = scaled;
            --iterations;
        }
        return scaled;
    }

    public static BufferedImage cropBlank(BufferedImage image, Rectangle initialCrop) {
        return ImageUtils.cropBlank(image, initialCrop, image.getType());
    }

    public static BufferedImage cropBlank(BufferedImage image, Rectangle initialCrop, int imageType) {
        CropFilter filter = new CropFilter(){

            @Override
            public boolean crop(BufferedImage bufferedImage, int x, int y) {
                int rgb = bufferedImage.getRGB(x, y);
                return (rgb & 0xFF000000) == 0;
            }
        };
        return ImageUtils.crop(image, filter, initialCrop, imageType);
    }

    public static Rectangle getCropBounds(BufferedImage image, CropFilter filter, Rectangle initialCrop) {
        int y;
        int x;
        int y2;
        int x2;
        int y1;
        int x1;
        if (image == null) {
            return null;
        }
        if (initialCrop != null) {
            x1 = initialCrop.x;
            y1 = initialCrop.y;
            x2 = initialCrop.x + initialCrop.width;
            y2 = initialCrop.y + initialCrop.height;
        } else {
            x1 = 0;
            y1 = 0;
            x2 = image.getWidth();
            y2 = image.getHeight();
        }
        if (x1 == x2 || y1 == y2) {
            return null;
        }
        block0: while (y1 < y2) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y1)) break block0;
            }
            ++y1;
        }
        if (y1 == image.getHeight()) {
            return null;
        }
        block2: while (x1 < x2) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x1, y)) break block2;
            }
            ++x1;
        }
        block4: while (x2 > x1) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x2 - 1, y)) break block4;
            }
            --x2;
        }
        block6: while (y2 > y1) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y2 - 1)) break block6;
            }
            --y2;
        }
        if (x1 == x2 || y1 == y2) {
            return null;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }

    public static BufferedImage crop(BufferedImage image, CropFilter filter, Rectangle initialCrop, int imageType) {
        if (image == null) {
            return null;
        }
        Rectangle cropBounds = ImageUtils.getCropBounds(image, filter, initialCrop);
        if (cropBounds == null) {
            return null;
        }
        int x1 = cropBounds.x;
        int y1 = cropBounds.y;
        int width = cropBounds.width;
        int height = cropBounds.height;
        int x2 = x1 + width;
        int y2 = y1 + height;
        if (imageType == -1) {
            imageType = image.getType();
        }
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage cropped = new BufferedImage(width, height, imageType);
        Graphics g = cropped.getGraphics();
        g.drawImage(image, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        return cropped;
    }

    public static Image loadIcon(String path) {
        Image image = ImageLoader.loadFromResource((String)path, AndroidIcons.class);
        assert (image != null) : path;
        return image;
    }

    public static int getBrightness(int rgb) {
        if ((rgb & 0xFFFFFF) != 0) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            return (int)((299L * (long)r + (long)(587 * g) + (long)(114 * b)) / 1000L);
        }
        return 0;
    }

    public static interface CropFilter {
        public boolean crop(BufferedImage var1, int var2, int var3);
    }
}

