/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;

public class IncludeReference {
    public static final IncludeReference NONE = new IncludeReference(null, null, null);
    public static final String ATTR_RENDER_IN = "showIn";
    private final VirtualFile myFromFile;
    private final VirtualFile myToFile;
    private final Module myModule;

    private IncludeReference(Module module, VirtualFile fromFile, VirtualFile toFile) {
        this.myModule = module;
        this.myFromFile = fromFile;
        this.myToFile = toFile;
    }

    public static IncludeReference create(Module module, VirtualFile fromFile, VirtualFile toFile) {
        return new IncludeReference(module, fromFile, toFile);
    }

    public Module getModule() {
        return this.myModule;
    }

    public VirtualFile getFromFile() {
        return this.myFromFile;
    }

    public File getFromPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.myFromFile);
    }

    public VirtualFile getToFile() {
        return this.myToFile;
    }

    public File getToPath() {
        return this.myToFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myToFile) : null;
    }

    public String getFromDisplayName() {
        if (this.myToFile != null && this.myToFile.getParent() != null && this.myToFile.getParent().equals(this.myFromFile.getParent())) {
            return this.myFromFile.getName();
        }
        return this.myFromFile.getParent().getName() + '/' + this.myFromFile.getName();
    }

    public String getFromResourceName() {
        return ResourceHelper.getResourceName(this.myFromFile);
    }

    public String getFromResourceUrl() {
        return "@layout/" + this.getFromResourceName();
    }

    public static String getIncludingLayout(final XmlFile file) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return IncludeReference.getIncludingLayout(file);
                }
            });
        }
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && rootTag.isValid()) {
            return rootTag.getAttributeValue(ATTR_RENDER_IN, "http://schemas.android.com/tools");
        }
        return null;
    }

    public static void setIncludingLayout(Project project, XmlFile xmlFile, String layout) {
        XmlTag tag = xmlFile.getRootTag();
        if (tag != null) {
            SetAttributeFix fix = new SetAttributeFix(project, tag, ATTR_RENDER_IN, "http://schemas.android.com/tools", layout);
            fix.execute();
        }
    }

    public static IncludeReference get(final Module module, final XmlFile file, final RenderResources resolver) {
        VirtualFile source;
        File path;
        ResourceValue resValue;
        String layout;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (IncludeReference)ApplicationManager.getApplication().runReadAction((Computable)new Computable<IncludeReference>(){

                public IncludeReference compute() {
                    return IncludeReference.get(module, file, resolver);
                }
            });
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && (layout = rootTag.getAttributeValue(ATTR_RENDER_IN, "http://schemas.android.com/tools")) != null && (resValue = resolver.findResValue(layout, false)) != null && (path = ResourceHelper.resolveLayout(resolver, resValue)) != null && (source = LocalFileSystem.getInstance().findFileByIoFile(path)) != null) {
            VirtualFile target = file.getVirtualFile();
            return IncludeReference.create(module, source, target);
        }
        return NONE;
    }
}

