/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ParserFactory;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.LayoutFilePullParser;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.util.Pair;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ViewLoader;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutlibCallbackImpl
extends LayoutlibCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.LayoutlibCallback");
    private static final int MAX_PARSER_INCLUDES = 50;
    private static final Set<String> NOT_VIEW = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"android.support.v7.widget.RecyclerView$Adapter", "android.support.v7.widget.RecyclerView$LayoutManager", "android.support.v7.internal.app.WindowDecorActionBar"}));
    private final Module myModule;
    private final AppResourceRepository myProjectRes;
    private final LayoutLibrary myLayoutLib;
    private final Object myCredential;
    private String myNamespace;
    private RenderLogger myLogger;
    private final ViewLoader myClassLoader;
    private String myLayoutName;
    private ILayoutPullParser myLayoutEmbeddedParser;
    private ResourceResolver myResourceResolver;
    private final ActionBarHandler myActionBarHandler;
    private final RenderTask myRenderTask;
    private boolean myUsed = false;
    private Set<File> myParserFiles;
    private int myParserCount;
    private ParserFactory myParserFactory;

    public LayoutlibCallbackImpl(RenderTask renderTask, LayoutLibrary layoutLib, AppResourceRepository projectRes, Module module, AndroidFacet facet, RenderLogger logger, Object credential, ActionBarHandler actionBarHandler) {
        this.myRenderTask = renderTask;
        this.myLayoutLib = layoutLib;
        this.myProjectRes = projectRes;
        this.myModule = module;
        this.myCredential = credential;
        this.myClassLoader = new ViewLoader(this.myLayoutLib, facet, logger, credential);
        this.myActionBarHandler = actionBarHandler;
    }

    void reset() {
        this.myParserCount = 0;
        this.myParserFiles = null;
        this.myLayoutName = null;
        this.myLayoutEmbeddedParser = null;
    }

    public void setLogger(RenderLogger logger) {
        this.myLogger = logger;
        this.myClassLoader.setLogger(logger);
    }

    public LayoutLog getLogger() {
        return this.myLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadView(String className, Class[] constructorSignature, Object[] constructorParameters) throws ClassNotFoundException {
        if (className.indexOf(46) == -1 && !"fragment".equals(className) && !"include".equals(className)) {
            boolean token = RenderSecurityManager.enterSafeRegion((Object)this.myCredential);
            try {
                List<String> known;
                AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
                if (facet != null && (known = AndroidLayoutUtil.getPossibleRoots(facet)).contains(className)) {
                    throw new ClassNotFoundException(className);
                }
            }
            finally {
                RenderSecurityManager.exitSafeRegion((boolean)token);
            }
        }
        this.myUsed = true;
        if (NOT_VIEW.contains(className)) {
            return this.myClassLoader.loadClass(className, constructorSignature, constructorParameters);
        }
        return this.myClassLoader.loadView(className, constructorSignature, constructorParameters);
    }

    public Object loadClass(String name, Class[] constructorSignature, Object[] constructorArgs) throws ClassNotFoundException {
        this.myUsed = true;
        return this.myClassLoader.loadClass(name, constructorSignature, constructorArgs);
    }

    public boolean supports(int ideFeature) {
        return ideFeature <= 16;
    }

    public String getNamespace() {
        String javaPackage;
        if (this.myNamespace == null && (javaPackage = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                AndroidFacet facet = AndroidFacet.getInstance(LayoutlibCallbackImpl.this.myModule);
                if (facet == null) {
                    return null;
                }
                Manifest manifest = facet.getManifest();
                if (manifest == null) {
                    return null;
                }
                return (String)manifest.getPackage().getValue();
            }
        })) != null) {
            this.myNamespace = String.format("http://schemas.android.com/apk/res/%1$s", javaPackage);
        }
        return this.myNamespace;
    }

    public Pair<ResourceType, String> resolveResourceId(int id) {
        return this.myProjectRes.resolveResourceId(id);
    }

    public String resolveResourceId(int[] id) {
        return this.myProjectRes.resolveStyleable(id);
    }

    public Integer getResourceId(ResourceType type, String name) {
        return this.myProjectRes.getResourceId(type, name);
    }

    public boolean isUsed() {
        return this.myUsed;
    }

    public void setLayoutParser(String layoutName, ILayoutPullParser layoutParser) {
        this.myLayoutName = layoutName;
        this.myLayoutEmbeddedParser = layoutParser;
    }

    public ILayoutPullParser getLayoutEmbeddedParser() {
        return this.myLayoutEmbeddedParser;
    }

    public ILayoutPullParser getParser(String layoutName) {
        ResourceValue value;
        if (this.myResourceResolver != null && (value = this.myResourceResolver.getProjectResource(ResourceType.LAYOUT, layoutName)) != null) {
            return this.getParser(value);
        }
        return this.getParser(layoutName, false, null);
    }

    public ILayoutPullParser getParser(ResourceValue layoutResource) {
        return this.getParser(layoutResource.getName(), layoutResource.isFramework(), new File(layoutResource.getValue()));
    }

    private ILayoutPullParser getParser(String layoutName, boolean isFramework, File xml) {
        if (this.myParserFiles != null && this.myParserFiles.contains(xml)) {
            if (this.myParserCount > 50) {
                if (this.findCycles()) {
                    throw new RuntimeException("Aborting rendering");
                }
                this.myParserCount = 0;
            }
        } else {
            if (this.myParserFiles == null) {
                this.myParserFiles = Sets.newHashSet();
            }
            this.myParserFiles.add(xml);
        }
        ++this.myParserCount;
        if (layoutName.equals(this.myLayoutName) && !isFramework) {
            ILayoutPullParser parser = this.myLayoutEmbeddedParser;
            this.myLayoutEmbeddedParser = null;
            return parser;
        }
        if (xml != null && xml.isFile()) {
            PsiFile psiFile;
            VirtualFile file;
            String parentName;
            File parent = xml.getParentFile();
            if (parent != null && ((parentName = parent.getName()).startsWith("layout") || parentName.startsWith("menu")) && (file = LocalFileSystem.getInstance().findFileByIoFile(xml)) != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(this.myModule.getProject(), file)) instanceof XmlFile) {
                assert (this.myLogger != null);
                LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                if (parentName.startsWith("layout")) {
                    parser.setProvideViewCookies(this.myRenderTask != null && this.myRenderTask.getProvideCookiesForIncludedViews());
                }
                return parser;
            }
            try {
                return LayoutFilePullParser.create(this, xml);
            }
            catch (XmlPullParserException e) {
                LOG.error((Throwable)e);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private boolean findCycles() {
        HashMap fileToLayout = Maps.newHashMap();
        HashMap layoutToFile = Maps.newHashMap();
        ArrayListMultimap includeMap = ArrayListMultimap.create();
        for (File file : this.myParserFiles) {
            String layoutName = LintUtils.getLayoutName((File)file);
            layoutToFile.put(layoutName, file);
            fileToLayout.put(file, layoutName);
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) continue;
                NodeList includeNodeList = document.getElementsByTagName("include");
                int n = includeNodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element include = (Element)includeNodeList.item(i);
                    String included = include.getAttribute("layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
            }
            catch (IOException e) {
                LOG.warn("Could not check file " + file + " for cyclic dependencies", (Throwable)e);
            }
        }
        if (includeMap.size() > 0) {
            for (String from : includeMap.keySet()) {
                HashSet visiting;
                List<String> chain = LayoutlibCallbackImpl.dfs(from, visiting = Sets.newHashSetWithExpectedSize((int)includeMap.size()), (Multimap<String, String>)includeMap);
                if (chain == null) continue;
                if (this.myLogger != null) {
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    builder.add("Found cyclical <include> chain: ");
                    boolean first = true;
                    Collections.reverse(chain);
                    for (String layout : chain) {
                        if (first) {
                            first = false;
                        } else {
                            builder.add(" includes ");
                        }
                        File file = (File)layoutToFile.get(layout);
                        if (file != null) {
                            try {
                                String url = SdkUtils.fileToUrlString((File)file);
                                builder.addLink(layout, url);
                            }
                            catch (MalformedURLException e) {
                                builder.add(layout);
                            }
                            continue;
                        }
                        builder.add(layout);
                    }
                    this.myLogger.addMessage(problem);
                }
                return true;
            }
        }
        return false;
    }

    private static List<String> dfs(String from, Set<String> visiting, Multimap<String, String> includeMap) {
        visiting.add(from);
        Collection includes = includeMap.get((Object)from);
        if (includes != null && includes.size() > 0) {
            for (String include : includes) {
                if (visiting.contains(include)) {
                    LinkedList list = Lists.newLinkedList();
                    list.add(include);
                    list.add(from);
                    return list;
                }
                List<String> chain = LayoutlibCallbackImpl.dfs(include, visiting, includeMap);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    public Object getAdapterItemValue(ResourceReference adapterView, Object adapterCookie, ResourceReference itemRef, int fullPosition, int typePosition, int fullChildPosition, int typeChildPosition, ResourceReference viewRef, IProjectCallback.ViewAttribute viewAttribute, Object defaultValue) {
        if (viewAttribute == IProjectCallback.ViewAttribute.TEXT && adapterView.getName().startsWith("android_widget_")) {
            String name = adapterView.getName();
            if (viewRef.getName().equals("text2")) {
                return "Sub Item";
            }
            if (fullPosition == 0) {
                String viewName = name.substring("android_widget_".length());
                if (viewName.equals("ExpandableListView")) {
                    return "ExpandableList";
                }
                return viewName;
            }
            return "Next Item";
        }
        if (itemRef.isFramework() && viewRef.getName().equals("text2")) {
            return "Sub Item " + (fullPosition + 1);
        }
        if (viewAttribute == IProjectCallback.ViewAttribute.TEXT && ((String)defaultValue).length() == 0) {
            return "Item " + (fullPosition + 1);
        }
        return null;
    }

    public static String getListAdapterViewFqcn(Class<?> clz) {
        String fqcn = clz.getName();
        if (fqcn.endsWith("ListView") || fqcn.equals("android.widget.GridView") || fqcn.equals("android.widget.Spinner")) {
            return fqcn;
        }
        if (fqcn.startsWith("android.")) {
            return null;
        }
        Class<?> superClass = clz.getSuperclass();
        if (superClass != null) {
            return LayoutlibCallbackImpl.getListAdapterViewFqcn(superClass);
        }
        return null;
    }

    private boolean isWithinIllegalParent(Object viewObject, int depth) {
        Object parent;
        Result result;
        String fqcn = viewObject.getClass().getName();
        if (fqcn.endsWith("CalendarView") || !fqcn.startsWith("android.") && !fqcn.startsWith("com.android.internal.widget.")) {
            return true;
        }
        if (depth > 0 && (result = this.myLayoutLib.getViewParent(viewObject)).isSuccess() && (parent = result.getData()) != null) {
            return this.isWithinIllegalParent(parent, depth - 1);
        }
        return false;
    }

    public AdapterBinding getAdapterBinding(ResourceReference adapterView, Object adapterCookie, Object viewObject) {
        Map map;
        XmlTag uiNode;
        AdapterBinding binding;
        if (adapterCookie instanceof XmlTag ? (binding = LayoutMetadata.getNodeBinding(viewObject, uiNode = (XmlTag)adapterCookie)) != null : adapterCookie instanceof Map && (binding = LayoutMetadata.getNodeBinding(viewObject, map = (Map)adapterCookie)) != null) {
            return binding;
        }
        if (viewObject == null) {
            return null;
        }
        String listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass());
        if (listFqcn == null) {
            return null;
        }
        if (this.isWithinIllegalParent(viewObject, 2)) {
            return null;
        }
        int count = listFqcn.endsWith("GridView") ? 24 : 12;
        AdapterBinding binding2 = new AdapterBinding(count);
        if (listFqcn.endsWith("ExpandableListView")) {
            binding2.addItem(new DataBindingItem("simple_expandable_list_item_2", true, 1));
        } else if (listFqcn.equals("Spinner")) {
            binding2.addItem(new DataBindingItem("simple_spinner_item", true, 1));
        } else {
            binding2.addItem(new DataBindingItem("simple_list_item_2", true, 1));
        }
        return binding2;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.myResourceResolver = resolver;
    }

    public void loadAndParseRClass() {
        this.myClassLoader.loadAndParseRClassSilently();
    }

    public ActionBarCallback getActionBarCallback() {
        return this.myActionBarHandler;
    }

    public ActionBarHandler getActionBarHandler() {
        return this.myActionBarHandler;
    }

    public <T> T getFlag(SessionParams.Key<T> key) {
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_APPLICATION_PACKAGE)) {
            return (T)this.getPackage();
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT)) {
            return (T)Boolean.TRUE;
        }
        return null;
    }

    private String getPackage() {
        AndroidModuleInfo info = AndroidModuleInfo.get(this.myModule);
        return info == null ? null : info.getPackage();
    }

    public ParserFactory getParserFactory() {
        if (this.myParserFactory == null) {
            this.myParserFactory = new ParserFactoryImpl();
        }
        return this.myParserFactory;
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Class<?> aClass = this.myClassLoader.loadClass(name);
            if (aClass != null) {
                return aClass;
            }
            throw new ClassNotFoundException(name + " not found.");
        }
        catch (InconvertibleClassError e) {
            throw new ClassNotFoundException(name + " not found.", e);
        }
    }

    private static class NamedParser
    extends KXmlParser {
        private final String myName;

        public NamedParser(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }
    }

    private static class ParserFactoryImpl
    extends ParserFactory {
        private ParserFactoryImpl() {
        }

        public XmlPullParser createParser(String debugName) throws XmlPullParserException {
            return new NamedParser(debugName);
        }
    }
}

