/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.rendering.RenderedImage;
import com.intellij.openapi.Disposable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;

public abstract class Overlay
implements Disposable {
    private boolean mHiding;

    public void create() {
    }

    public void dispose() {
    }

    public void paint(Component component, Graphics2D gc, int deltaX, int deltaY) {
        assert (false);
    }

    public boolean isHiding() {
        return this.mHiding;
    }

    public void setHiding(boolean hiding) {
        this.mHiding = hiding;
    }

    public static void paintOverlays(OverlayContainer container, Component component, Graphics g, int deltaX, int deltaY) {
        Graphics2D g2 = (Graphics2D)g;
        List<Overlay> overlays = container.getOverlays();
        if (overlays != null) {
            for (Overlay overlay : overlays) {
                if (overlay.isHiding()) continue;
                overlay.paint(component, g2, deltaX, deltaY);
            }
        }
    }

    protected Shape setScreenClip(OverlayContainer container, Component component, Graphics2D gc, int deltaX, int deltaY) {
        Configuration configuration = container.getConfiguration();
        Shape clip = null;
        if (configuration != null) {
            Device device = configuration.getDevice();
            if (device != null && device.isScreenRound()) {
                Screen screen = device.getDefaultHardware().getScreen();
                int width = screen.getXDimension();
                int height = screen.getYDimension();
                Rectangle m = container.fromModel(component, new Rectangle(0, 0, width, height));
                clip = RenderedImage.getClip(device, m.x + deltaX, m.y + deltaY, m.width, m.height);
            }
            if (clip != null) {
                gc.setClip(clip);
            }
        }
        return clip;
    }
}

