/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import java.util.Map;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class PsiProjectListener
extends AbstractProjectComponent
implements PsiTreeChangeListener {
    private final Map<VirtualFile, ResourceFolderRepository> myListeners = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRoot(Project project, VirtualFile root, ResourceFolderRepository repository) {
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getInstance(project).addRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoot(Project project, VirtualFile root, ResourceFolderRepository repository) {
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getInstance(project).removeRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static PsiProjectListener getInstance(Project project) {
        return (PsiProjectListener)((Object)project.getComponent(PsiProjectListener.class));
    }

    public PsiProjectListener(Project project) {
        super(project);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this);
    }

    private void addRoot(VirtualFile root, ResourceFolderRepository repository) {
        assert (this.myListeners.get(root) == null);
        this.myListeners.put(root, repository);
    }

    private void removeRoot(VirtualFile root, ResourceFolderRepository repository) {
        assert (this.myListeners.get(root) == repository) : repository;
        this.myListeners.remove(root);
    }

    static boolean isRelevantFileType(FileType fileType) {
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        return fileType == StdFileTypes.XML || fileType.isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png");
    }

    static boolean isRelevantFile(VirtualFile file) {
        String parentName;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    static boolean isRelevantFile(PsiFile file) {
        String parentName;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    private ResourceFolderRepository findRepository(VirtualFile file) {
        if (file == null) {
            return null;
        }
        while (file != null) {
            ResourceFolderRepository repository = this.myListeners.get(file);
            if (repository != null) {
                return repository;
            }
            file = file.getParent();
        }
        return null;
    }

    public void beforeChildAddition(PsiTreeChangeEvent event) {
    }

    public void childAdded(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildAdded(event, file);
                }
            } else if (child instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)child;
                this.dispatchChildAdded(event, directory.getVirtualFile());
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            this.dispatchChildAdded(event, psiFile.getVirtualFile());
        } else if (PsiProjectListener.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
    }

    private void dispatchChildAdded(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childAdded(event);
        }
    }

    public void beforeChildRemoval(PsiTreeChangeEvent event) {
    }

    public void childRemoved(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiDirectory directory;
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildRemoved(event, file);
                }
            } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                VirtualFile file = directory.getVirtualFile();
                this.dispatchChildRemoved(event, file);
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildRemoved(event, file);
        } else if (PsiProjectListener.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
    }

    private void dispatchChildRemoved(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childRemoved(event);
        }
    }

    public void beforeChildReplacement(PsiTreeChangeEvent event) {
    }

    public void childReplaced(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildReplaced(event, psiFile.getVirtualFile());
            } else if (PsiProjectListener.isGradleFileEdit(psiFile)) {
                PsiProjectListener.notifyGradleEdit(psiFile);
            }
        } else {
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)parent;
                this.dispatchChildReplaced(event, directory.getVirtualFile());
            }
        }
    }

    private void dispatchChildReplaced(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childReplaced(event);
        }
    }

    private static boolean isGradleFileEdit(PsiFile psiFile) {
        VirtualFile virtualFile;
        return psiFile.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && (virtualFile = psiFile.getVirtualFile()) != null && "gradle".equals(virtualFile.getExtension());
    }

    private static void notifyGradleEdit(PsiFile psiFile) {
        EditorNotifications.getInstance((Project)psiFile.getProject()).updateAllNotifications();
    }

    public void beforeChildrenChange(PsiTreeChangeEvent event) {
    }

    public void childrenChanged(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildrenChanged(event, file);
        }
    }

    private void dispatchChildrenChanged(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childrenChanged(event);
        }
    }

    public void beforeChildMovement(PsiTreeChangeEvent event) {
    }

    public void childMoved(PsiTreeChangeEvent event) {
        PsiElement child = event.getChild();
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            if (child instanceof PsiFile && PsiProjectListener.isRelevantFile((PsiFile)child)) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.dispatchChildMoved(event, file);
                    return;
                }
                PsiElement oldParent = event.getOldParent();
                if (oldParent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)oldParent;
                    VirtualFile dir = directory.getVirtualFile();
                    this.dispatchChildMoved(event, dir);
                }
            }
        } else {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null && PsiProjectListener.isRelevantFile(file)) {
                this.dispatchChildMoved(event, file);
            }
        }
    }

    private void dispatchChildMoved(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        PsiDirectory sourceDir;
        ResourceFolderRepository targetRepository;
        PsiElement oldParent;
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childMoved(event);
        }
        if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory && (targetRepository = this.findRepository((sourceDir = (PsiDirectory)oldParent).getVirtualFile())) != null && targetRepository != repository) {
            targetRepository.getPsiListener().childMoved(event);
        }
    }

    public void beforePropertyChange(PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforePropertyChange(event, file);
        }
    }

    private void dispatchBeforePropertyChange(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().beforePropertyChange(event);
        }
    }

    public void propertyChanged(PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchPropertyChange(event, file);
        }
    }

    private void dispatchPropertyChange(PsiTreeChangeEvent event, VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().propertyChanged(event);
        }
    }
}

