/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.TextResourceValue;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.PsiResourceFile;
import com.google.common.base.Splitter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Collections;

public class PsiResourceItem
extends ResourceItem {
    private final XmlTag myTag;
    private PsiFile myFile;

    PsiResourceItem(String name, ResourceType type, XmlTag tag, PsiFile file) {
        super(name, type, null);
        this.myTag = tag;
        this.myFile = file;
    }

    public FolderConfiguration getConfiguration() {
        PsiResourceFile source = (PsiResourceFile)super.getSource();
        if (source == null) {
            String name;
            FolderConfiguration configuration;
            PsiDirectory parent;
            if (this.myFile != null && (parent = this.myFile.getParent()) != null && (configuration = FolderConfiguration.getConfigForFolder((String)(name = parent.getName()))) != null) {
                return configuration;
            }
            String qualifiers = this.getQualifiers();
            if (qualifiers.isEmpty()) {
                return new FolderConfiguration();
            }
            FolderConfiguration fromQualifiers = FolderConfiguration.getConfigFromQualifiers((Iterable)Splitter.on((char)'-').split((CharSequence)qualifiers));
            if (fromQualifiers == null) {
                return new FolderConfiguration();
            }
            return fromQualifiers;
        }
        return source.getFolderConfiguration();
    }

    public ResourceFile getSource() {
        PsiDirectory parent;
        ResourceFile source = (ResourceFile)super.getSource();
        if (source == null && this.myFile != null && this.myFile.getParent() != null && (parent = this.myFile.getParent()) != null) {
            String name = parent.getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
            FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)name);
            int index = name.indexOf(45);
            String qualifiers = index == -1 ? "" : name.substring(index + 1);
            source = new PsiResourceFile(this.myFile, Collections.singletonList(this), qualifiers, folderType, configuration);
            this.setSource((DataFile)source);
        }
        return source;
    }

    public ResourceValue getResourceValue(boolean isFrameworks) {
        if (this.mResourceValue == null) {
            if (this.myTag == null) {
                Density density;
                ResourceType type = this.getType();
                Object object = density = type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                this.mResourceValue = density != null ? new DensityBasedResourceValue(type, this.getName(), this.getSource().getFile().getAbsolutePath(), density, isFrameworks) : new ResourceValue(type, this.getName(), this.getSource().getFile().getAbsolutePath(), isFrameworks);
            } else {
                this.mResourceValue = this.parseXmlToResourceValue(isFrameworks);
            }
        }
        return this.mResourceValue;
    }

    private Density getFolderDensity() {
        DensityQualifier densityQualifier;
        FolderConfiguration configuration = this.getConfiguration();
        if (configuration != null && (densityQualifier = configuration.getDensityQualifier()) != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    private ResourceValue parseXmlToResourceValue(boolean isFrameworks) {
        Object value;
        assert (this.myTag != null);
        if (!this.myTag.isValid()) {
            return null;
        }
        ResourceType type = this.getType();
        String name = this.getName();
        switch (type) {
            case STYLE: {
                String parent = PsiResourceItem.getAttributeValue(this.myTag, "parent");
                value = this.parseStyleValue(new StyleResourceValue(type, name, parent, isFrameworks));
                break;
            }
            case DECLARE_STYLEABLE: {
                value = this.parseDeclareStyleable(new DeclareStyleableResourceValue(type, name, isFrameworks));
                break;
            }
            case ATTR: {
                value = this.parseAttrValue(new AttrResourceValue(type, name, isFrameworks));
                break;
            }
            case ARRAY: {
                value = this.parseArrayValue(new ArrayResourceValue(name, isFrameworks){

                    protected int getDefaultIndex() {
                        String index = PsiResourceItem.this.myTag.getAttributeValue("index", "http://schemas.android.com/tools");
                        if (index != null) {
                            return Integer.parseInt(index);
                        }
                        return super.getDefaultIndex();
                    }
                });
                break;
            }
            case PLURALS: {
                value = this.parsePluralsValue(new PluralsResourceValue(name, isFrameworks){

                    public String getValue() {
                        String value;
                        String quantity = PsiResourceItem.this.myTag.getAttributeValue("quantity", "http://schemas.android.com/tools");
                        if (quantity != null && (value = this.getValue(quantity)) != null) {
                            return value;
                        }
                        return super.getValue();
                    }
                });
                break;
            }
            case STRING: {
                value = this.parseTextValue(new PsiTextResourceValue(type, name, isFrameworks));
                break;
            }
            default: {
                value = this.parseValue(new ResourceValue(type, name, isFrameworks));
            }
        }
        return value;
    }

    private static String getAttributeValue(XmlTag tag, String attributeName) {
        return tag.getAttributeValue(attributeName);
    }

    private ResourceValue parseDeclareStyleable(DeclareStyleableResourceValue declareStyleable) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null) continue;
            boolean isFrameworkAttr = declareStyleable.isFramework();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                isFrameworkAttr = true;
            }
            AttrResourceValue attr = PsiResourceItem.parseAttrValue(child, new AttrResourceValue(ResourceType.ATTR, name, isFrameworkAttr));
            declareStyleable.addValue(attr);
        }
        return declareStyleable;
    }

    private ResourceValue parseStyleValue(StyleResourceValue styleValue) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null) continue;
            boolean isFrameworkAttr = styleValue.isFramework();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                isFrameworkAttr = true;
            }
            ItemResourceValue resValue = new ItemResourceValue(name, isFrameworkAttr, styleValue.isFramework());
            resValue.setValue(ValueXmlHelper.unescapeResourceString((String)PsiResourceItem.getTextContent(child), (boolean)true, (boolean)true));
            styleValue.addItem(resValue);
        }
        return styleValue;
    }

    private AttrResourceValue parseAttrValue(AttrResourceValue attrValue) {
        assert (this.myTag != null);
        return PsiResourceItem.parseAttrValue(this.myTag, attrValue);
    }

    private static AttrResourceValue parseAttrValue(XmlTag myTag, AttrResourceValue attrValue) {
        for (XmlTag child : myTag.getSubTags()) {
            String value;
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null || (value = PsiResourceItem.getAttributeValue(child, "value")) == null) continue;
            try {
                attrValue.addValue(name, Integer.valueOf((int)Long.decode(value).longValue()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return attrValue;
    }

    private ResourceValue parseArrayValue(ArrayResourceValue arrayValue) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String text = ValueXmlHelper.unescapeResourceString((String)PsiResourceItem.getTextContent(child), (boolean)true, (boolean)true);
            arrayValue.addElement(text);
        }
        return arrayValue;
    }

    private ResourceValue parsePluralsValue(PluralsResourceValue value) {
        assert (this.myTag != null);
        for (XmlTag child : this.myTag.getSubTags()) {
            String quantity = child.getAttributeValue("quantity");
            if (quantity == null) continue;
            String text = ValueXmlHelper.unescapeResourceString((String)PsiResourceItem.getTextContent(child), (boolean)true, (boolean)true);
            value.addPlural(quantity, text);
        }
        return value;
    }

    private ResourceValue parseValue(ResourceValue value) {
        assert (this.myTag != null);
        String text = PsiResourceItem.getTextContent(this.myTag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value.setValue(text);
        return value;
    }

    public static String getTextContent(XmlTag tag) {
        XmlTag[] subTags = tag.getSubTags();
        XmlText[] textElements = tag.getValue().getTextElements();
        if (subTags.length == 0) {
            if (textElements.length == 1) {
                return PsiResourceItem.getXmlTextValue(textElements[0]);
            }
            if (textElements.length == 0) {
                return "";
            }
        }
        StringBuilder sb = new StringBuilder(40);
        PsiResourceItem.appendText(sb, tag);
        return sb.toString();
    }

    private PsiTextResourceValue parseTextValue(PsiTextResourceValue value) {
        assert (this.myTag != null);
        String text = PsiResourceItem.getTextContent(this.myTag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value.setValue(text);
        return value;
    }

    private static String getXmlTextValue(XmlText element) {
        PsiElement current = element.getFirstChild();
        if (current != null) {
            PsiElement[] children;
            if (current.getNextSibling() != null) {
                StringBuilder sb = new StringBuilder();
                while (current != null) {
                    IElementType type = current.getNode().getElementType();
                    if (type == XmlElementType.XML_CDATA) {
                        PsiElement[] children2 = current.getChildren();
                        if (children2.length == 3) {
                            assert (children2[1].getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS);
                            sb.append(children2[1].getText());
                        }
                    } else {
                        sb.append(current.getText());
                    }
                    current = current.getNextSibling();
                }
                return sb.toString();
            }
            if (current.getNode().getElementType() == XmlElementType.XML_CDATA && (children = current.getChildren()).length == 3) {
                assert (children[1].getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS);
                return children[1].getText();
            }
        }
        return element.getText();
    }

    private static void appendText(StringBuilder sb, XmlTag tag) {
        PsiElement[] children;
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof XmlText) {
                XmlText text = (XmlText)child;
                sb.append(PsiResourceItem.getXmlTextValue(text));
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTag childTag = (XmlTag)child;
            if ("g".equals(childTag.getLocalName()) && childTag.getNamespace().startsWith("urn:oasis:names:tc:xliff:document:")) {
                String example = childTag.getAttributeValue("example");
                if (example != null) {
                    sb.append('(').append(example).append(')');
                    continue;
                }
                String id = childTag.getAttributeValue("id");
                if (id != null) {
                    sb.append('$').append('{').append(id).append('}');
                    continue;
                }
            }
            PsiResourceItem.appendText(sb, childTag);
        }
    }

    PsiFile getPsiFile() {
        return this.myFile;
    }

    public boolean recomputeValue() {
        if (this.mResourceValue != null) {
            this.mResourceValue = null;
            return true;
        }
        return false;
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return super.toString() + ": " + (this.myTag != null ? PsiResourceItem.getTextContent(this.myTag) : "null" + (this.myFile != null ? ":" + this.myFile.getName() : ""));
    }

    private class PsiTextResourceValue
    extends TextResourceValue {
        public PsiTextResourceValue(ResourceType type, String name, boolean isFramework) {
            super(type, name, isFramework);
        }

        public String getRawXmlValue() {
            if (PsiResourceItem.this.myTag != null && PsiResourceItem.this.myTag.isValid()) {
                if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                    return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            return PsiResourceItem.this.myTag.getValue().getText();
                        }
                    });
                }
                return PsiResourceItem.this.myTag.getValue().getText();
            }
            return this.getValue();
        }
    }
}

