/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.lint.detector.api.ClassContext;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    protected UrlClassLoader myJarClassLoader;
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected abstract List<URL> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clz = this.loadClassFromJar(name);
        if (clz != null) {
            return clz;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class<?> loadClassFromJar(String name) {
        if (this.myJarClassLoader == null) {
            List<URL> externalJars = this.getExternalJars();
            this.myJarClassLoader = this.createClassLoader(externalJars);
        }
        try {
            this.myInsideJarClassLoader = true;
            String relative = name.replace('.', '/').concat(".class");
            InputStream is = this.myJarClassLoader.getResourceAsStream(relative);
            if (is != null) {
                byte[] data = ByteStreams.toByteArray((InputStream)is);
                is.close();
                if (!ClassConverter.isValidClassFile(data)) {
                    throw new ClassFormatError(name);
                }
                byte[] rewritten = this.convertClass(data);
                try {
                    Class<?> clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
                    return clazz;
                }
                catch (UnsupportedClassVersionError inner) {
                    throw InconvertibleClassError.wrap(inner, name, data);
                }
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (IOException ex) {
            throw new Error("Failed to load class " + name, ex);
        }
        finally {
            this.myInsideJarClassLoader = false;
        }
    }

    protected UrlClassLoader createClassLoader(List<URL> externalJars) {
        return UrlClassLoader.build().parent((ClassLoader)this).urls(externalJars).noPreload().get();
    }

    protected Class<?> loadClassFromClassPath(String fqcn, File classPathFolder) {
        File classFile = RenderClassLoader.findClassFile(classPathFolder, fqcn);
        if (classFile == null || !classFile.exists()) {
            return null;
        }
        return this.loadClassFile(fqcn, classFile);
    }

    protected Class<?> loadClassFile(String fqcn, File classFile) {
        try {
            byte[] data = Files.toByteArray((File)classFile);
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected Class<?> loadClass(String fqcn, byte[] data) {
        if (data == null) {
            return null;
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = this.convertClass(data);
        try {
            return this.defineClassAndPackage(null, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
    }

    protected byte[] convertClass(byte[] data) {
        return ClassConverter.rewriteClass(data);
    }

    private static File findClassFile(File parent, String className) {
        if (!parent.exists()) {
            return null;
        }
        String path = ClassContext.getInternalName((String)className).replace('/', File.separatorChar);
        File file = new File(parent, path + ".class");
        if (file.exists()) {
            return file;
        }
        if (className.indexOf(36) != -1) {
            return null;
        }
        path = className.replace('.', File.separatorChar);
        while (!(file = new File(parent, path + ".class")).exists()) {
            int last = path.lastIndexOf(File.separatorChar);
            if (last == -1) {
                return null;
            }
            path = path.substring(0, last) + '$' + path.substring(last + 1);
        }
        return file;
    }

    protected Class<?> defineClassAndPackage(String name, byte[] b, int offset, int len) {
        if (name != null) {
            this.definePackage(name);
            return this.defineClass(name, b, offset, len);
        }
        Class<?> aClass = this.defineClass(null, b, offset, len);
        this.definePackage(aClass.getName());
        return aClass;
    }

    private void definePackage(String className) {
        String packageName;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i > 0 && (pkg = this.getPackage(packageName = className.substring(0, i))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }
}

