/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import java.util.List;

public abstract class RenderProblem
implements Comparable<RenderProblem> {
    public static final int PRIORITY_UNEXPECTED = 10;
    public static final int PRIORITY_MISSING_CLASSES = 20;
    public static final int PRIORITY_BROKEN_CLASSES = 30;
    public static final int PRIORITY_MISSING_ATTRIBUTE = 40;
    public static final int PRIORITY_MISSING_STYLE = 50;
    public static final int PRIORITY_NINEPATCH_RENDER_ERROR = 60;
    public static final int PRIORITY_RENDERING_FIDELITY = 1000;
    private final HighlightSeverity mySeverity;
    private final int myOrdinal;
    private int myPriority = 10;
    private Throwable myThrowable;
    private Object myClientData;
    private String myTag;
    protected boolean myIsDefaultHtml;
    private static int ourNextOrdinal;

    public static RenderProblem createPlain(HighlightSeverity severity, String message) {
        return new Plain(severity, ourNextOrdinal++, message != null ? XmlUtils.toXmlTextValue((String)message) : "");
    }

    public static RenderProblem createPlain(HighlightSeverity severity, String message, Project project, HtmlLinkManager linkManager, Throwable throwable) {
        Html problem = new Html(severity, ourNextOrdinal++);
        HtmlBuilder builder = problem.getHtmlBuilder();
        builder.add(message);
        if (throwable != null) {
            String url = linkManager.createRunnableLink(new ShowExceptionFix(project, throwable));
            builder.add(" (").addLink("Details", url).add(")");
            problem.throwable(throwable);
            if (message.equals(throwable.getMessage())) {
                problem.myIsDefaultHtml = true;
            }
        }
        return problem;
    }

    public static Html create(HighlightSeverity severity) {
        return new Html(severity, ourNextOrdinal++);
    }

    public static RenderProblem createDeferred(HighlightSeverity severity, String tag, String text, Throwable throwable) {
        return new Deferred(severity, tag, text, throwable);
    }

    private RenderProblem(HighlightSeverity severity, int ordinal) {
        this.mySeverity = severity;
        this.myOrdinal = ordinal;
    }

    public RenderProblem throwable(Throwable throwable) {
        this.myThrowable = throwable;
        return this;
    }

    public RenderProblem priority(int priority) {
        this.myPriority = priority;
        return this;
    }

    public RenderProblem tag(String tag) {
        this.myTag = tag;
        return this;
    }

    public String getTag() {
        return this.myTag;
    }

    public abstract String getHtml();

    public boolean isDefaultHtml() {
        return this.myIsDefaultHtml;
    }

    public void appendHtml(StringBuilder stringBuilder) {
        stringBuilder.append(this.getHtml());
    }

    @Override
    public int compareTo(RenderProblem other) {
        if (this.mySeverity != other.mySeverity) {
            return this.mySeverity.compareTo(other.mySeverity);
        }
        if (this.myPriority != other.myPriority) {
            return this.myPriority - other.myPriority;
        }
        return this.myOrdinal - other.myOrdinal;
    }

    public static String format(List<RenderProblem> messages) {
        StringBuilder sb = new StringBuilder();
        for (RenderProblem message : messages) {
            sb.append(message.getHtml());
            sb.append("<br/>\n");
        }
        return sb.toString();
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public Object getClientData() {
        return this.myClientData;
    }

    public void setClientData(Object clientData) {
        this.myClientData = clientData;
    }

    public static class Deferred
    extends RenderProblem {
        protected final String myTag;
        protected final String myText;

        protected Deferred(HighlightSeverity severity, String tag, String text, Throwable throwable) {
            super(severity, ourNextOrdinal++);
            this.myTag = tag;
            this.myText = text;
            this.throwable(throwable);
        }

        @Override
        public String getHtml() {
            return new HtmlBuilder().add(this.myText).getHtml();
        }
    }

    public static class Html
    extends RenderProblem {
        private final HtmlBuilder myBuilder = new HtmlBuilder();

        private Html(HighlightSeverity severity, int ordinal) {
            super(severity, ordinal);
        }

        @Override
        public String getHtml() {
            return this.myBuilder.getHtml();
        }

        public HtmlBuilder getHtmlBuilder() {
            this.myIsDefaultHtml = false;
            return this.myBuilder;
        }
    }

    public static class Plain
    extends RenderProblem {
        private final String myHtml;

        private Plain(HighlightSeverity severity, int ordinal, String text) {
            super(severity, ordinal);
            this.myHtml = text;
        }

        @Override
        public String getHtml() {
            return this.myHtml;
        }
    }
}

