/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.image.BufferedImage;
import java.util.List;

public class RenderResult {
    private final PsiFile myFile;
    private final RenderLogger myLogger;
    private final List<ViewInfo> myRootViews;
    private final RenderedImage myImage;
    private RenderedViewHierarchy myHierarchy;
    private final RenderTask myRenderTask;
    private final RenderSession mySession;
    private IncludeReference myIncludedWithin = IncludeReference.NONE;

    public RenderResult(RenderTask renderTask, RenderSession session, PsiFile file, RenderLogger logger) {
        this.myRenderTask = renderTask;
        this.mySession = session;
        this.myFile = file;
        this.myLogger = logger;
        if (session != null && session.getResult().isSuccess() && renderTask != null) {
            RenderedImage.ShadowType shadowType;
            List systemRootViews = session.getSystemRootViews();
            this.myRootViews = systemRootViews != null ? systemRootViews : session.getRootViews();
            Configuration configuration = renderTask.getConfiguration();
            BufferedImage image = session.getImage();
            boolean alphaChannelImage = session.isAlphaChannelImage() || renderTask.requiresTransparency();
            RenderedImage.ShadowType shadowType2 = shadowType = alphaChannelImage ? RenderedImage.ShadowType.NONE : RenderedImage.ShadowType.RECTANGULAR;
            if (shadowType == RenderedImage.ShadowType.NONE && renderTask.isNonRectangular()) {
                shadowType = RenderedImage.ShadowType.ARBITRARY;
            } else {
                Device device = renderTask.getConfiguration().getDevice();
                if (device != null && device.isScreenRound()) {
                    shadowType = RenderedImage.ShadowType.ARBITRARY;
                }
            }
            this.myImage = new RenderedImage(configuration, image, alphaChannelImage, shadowType);
        } else {
            this.myRootViews = null;
            this.myImage = null;
        }
    }

    public static RenderResult createBlank(PsiFile file, RenderLogger logger) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return new RenderResult(null, null, file, logger != null ? logger : new RenderLogger(null, module));
    }

    public RenderSession getSession() {
        return this.mySession;
    }

    public RenderLogger getLogger() {
        return this.myLogger;
    }

    public RenderedViewHierarchy getHierarchy() {
        if (this.myHierarchy == null && this.myRootViews != null) {
            this.myHierarchy = RenderedViewHierarchy.create(this.myFile, this.myRootViews, this.myIncludedWithin != IncludeReference.NONE);
        }
        return this.myHierarchy;
    }

    public RenderedImage getImage() {
        return this.myImage;
    }

    public BufferedImage getRenderedImage() {
        return this.myImage != null ? this.myImage.getOriginalImage() : null;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    public Module getModule() {
        Module module = this.myLogger.getModule();
        assert (module != null);
        return module;
    }

    public List<ViewInfo> getRootViews() {
        return this.myRootViews;
    }

    public IncludeReference getIncludedWithin() {
        return this.myIncludedWithin;
    }

    public void setIncludedWithin(IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
    }
}

