/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;

public class ReplaceTagFix
extends WriteCommandAction<Void> {
    private final XmlFile myFile;
    private final String myWrongTag;
    private final String myRightTag;

    public ReplaceTagFix(Project project, XmlFile file, String wrongTag, String rightTag) {
        super(project, String.format("Replace <%1$s> with <%2$s>", wrongTag, rightTag), new PsiFile[]{file});
        this.myFile = file;
        this.myWrongTag = wrongTag;
        this.myRightTag = rightTag;
    }

    protected void run(Result<Void> result) throws Throwable {
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)this.myFile, XmlTag.class);
        if (!xmlTags.isEmpty()) {
            ArrayList matching = Lists.newArrayListWithExpectedSize((int)xmlTags.size());
            for (XmlTag tag : xmlTags) {
                if (!tag.getName().equals(this.myWrongTag)) continue;
                matching.add(tag);
            }
            if (!matching.isEmpty()) {
                for (XmlTag tag : matching) {
                    tag.setName(this.myRightTag);
                }
            }
        }
    }
}

