/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.res2.DataBindingResourceType;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.PsiDataBindingResourceItem;
import com.android.tools.idea.rendering.PsiProjectListener;
import com.android.tools.idea.rendering.PsiResourceFile;
import com.android.tools.idea.rendering.PsiResourceItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;

public final class ResourceFolderRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    private final Module myModule;
    private final AndroidFacet myFacet;
    private final PsiListener myListener;
    private final VirtualFile myResourceDir;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myItems = Maps.newEnumMap(ResourceType.class);
    private final Map<PsiFile, PsiResourceFile> myResourceFiles = Maps.newHashMap();
    private Map<String, DataBindingInfo> myDataBindingResourceFiles = Maps.newHashMap();
    private long myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
    private final Object SCAN_LOCK = new Object();
    private Set<PsiFile> myPendingScans;
    static int ourFullRescans;

    private ResourceFolderRepository(AndroidFacet facet, VirtualFile resourceDir) {
        super(resourceDir.getName());
        this.myFacet = facet;
        this.myModule = facet.getModule();
        this.myListener = new PsiListener();
        this.myResourceDir = resourceDir;
        this.scan();
    }

    AndroidFacet getFacet() {
        return this.myFacet;
    }

    VirtualFile getResourceDir() {
        return this.myResourceDir;
    }

    static ResourceFolderRepository create(AndroidFacet facet, VirtualFile dir) {
        return new ResourceFolderRepository(facet, dir);
    }

    private void scan() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiDirectory directory;
                PsiManager manager = PsiManager.getInstance((Project)ResourceFolderRepository.this.myFacet.getModule().getProject());
                if (ResourceFolderRepository.this.myResourceDir.isValid() && (directory = manager.findDirectory(ResourceFolderRepository.this.myResourceDir)) != null) {
                    ResourceFolderRepository.this.scanResFolder(directory);
                }
            }
        });
    }

    private PsiFile ensureValid(PsiFile psiFile) {
        Project project;
        if (psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !(project = this.myModule.getProject()).isDisposed()) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    private void scanResFolder(PsiDirectory res) {
        for (PsiDirectory dir : res.getSubdirectories()) {
            String name = dir.getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
            if (folderType == null) continue;
            String qualifiers = ResourceFolderRepository.getQualifiers(name);
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)name);
            if (folderConfiguration == null) continue;
            if (folderType == ResourceFolderType.VALUES) {
                this.scanValueResFolder(dir, qualifiers, folderConfiguration);
                continue;
            }
            this.scanFileResourceFolder(dir, folderType, qualifiers, folderConfiguration);
        }
    }

    private static String getQualifiers(String dirName) {
        int index = dirName.indexOf(45);
        return index != -1 ? dirName.substring(index + 1) : "";
    }

    private void scanFileResourceFolder(PsiDirectory directory, ResourceFolderType folderType, String qualifiers, FolderConfiguration folderConfiguration) {
        boolean idGenerating;
        List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        assert (resourceTypes.size() >= 1) : folderType;
        ResourceType type = (ResourceType)resourceTypes.get(0);
        boolean bl = idGenerating = resourceTypes.size() > 1;
        assert (!idGenerating || resourceTypes.size() == 2 && resourceTypes.get(1) == ResourceType.ID);
        ListMultimap<String, ResourceItem> map = this.getMap(type, true);
        for (PsiFile file : directory.getFiles()) {
            FileType fileType = file.getFileType();
            if (!PsiProjectListener.isRelevantFileType(fileType) && folderType != ResourceFolderType.RAW) continue;
            this.scanFileResourceFile(qualifiers, folderType, folderConfiguration, type, idGenerating, map, file);
        }
    }

    private void scanFileResourceFile(String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration, ResourceType type, boolean idGenerating, ListMultimap<String, ResourceItem> map, PsiFile file) {
        String name = ResourceHelper.getResourceName(file);
        PsiResourceItem item = new PsiResourceItem(name, type, null, file);
        if (idGenerating) {
            ArrayList items = Lists.newArrayList();
            items.add(item);
            map.put((Object)name, (Object)item);
            this.addIds(items, file);
            PsiResourceFile resourceFile = new PsiResourceFile(file, items, qualifiers, folderType, folderConfiguration);
            this.scanDataBinding(resourceFile, this.getModificationCount());
            this.myResourceFiles.put(file, resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file, item, qualifiers, folderType, folderConfiguration);
            this.myResourceFiles.put(file, resourceFile);
            map.put((Object)name, (Object)item);
        }
    }

    @Override
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        List resourceItems = this.getResourceItem(ResourceType.LAYOUT, layoutName);
        if (resourceItems == null) {
            return null;
        }
        for (ResourceItem item : resourceItems) {
            ResourceFile source = (ResourceFile)item.getSource();
            if (!(source instanceof PsiResourceFile) || ((PsiResourceFile)source).getDataBindingInfo() == null) continue;
            return ((PsiResourceFile)source).getDataBindingInfo();
        }
        return null;
    }

    @Override
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            return this.myDataBindingResourceFiles;
        }
        HashMap selected = Maps.newHashMap();
        for (PsiResourceFile file : this.myResourceFiles.values()) {
            DataBindingInfo info = file.getDataBindingInfo();
            if (info == null) continue;
            selected.put(info.getQualifiedName(), info);
        }
        this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
        this.myDataBindingResourceFilesModificationCount = modificationCount;
        return this.myDataBindingResourceFiles;
    }

    private static XmlTag getLayoutTag(PsiElement element) {
        if (!(element instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)element).getRootTag();
        if (rootTag != null && "layout".equals(rootTag.getName())) {
            return rootTag;
        }
        return null;
    }

    private static XmlTag getDataTag(XmlTag layoutTag) {
        return layoutTag.findFirstSubTag("data");
    }

    private static void scanDataBindingDataTag(PsiResourceFile resourceFile, XmlTag dataTag, long modificationCount) {
        DataBindingInfo info = resourceFile.getDataBindingInfo();
        assert (info != null);
        ArrayList items = Lists.newArrayList();
        if (dataTag == null) {
            info.replaceItems(items, modificationCount);
            return;
        }
        HashSet usedNames = Sets.newHashSet();
        for (XmlTag tag : dataTag.findSubTags("variable")) {
            String name;
            String nameValue = tag.getAttributeValue("name");
            if (nameValue == null || !StringUtil.isNotEmpty((String)(name = StringUtil.unescapeXml((String)nameValue))) || !usedNames.add(name)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(name, DataBindingResourceType.VARIABLE, tag);
            item.setSource((DataFile)resourceFile);
            items.add(item);
        }
        HashSet usedAliases = Sets.newHashSet();
        for (XmlTag tag : dataTag.findSubTags("import")) {
            int lastIndexOfDot;
            String nameValue = tag.getAttributeValue("type");
            if (nameValue == null) continue;
            String name = StringUtil.unescapeXml((String)nameValue);
            String aliasValue = tag.getAttributeValue("alias");
            String alias = null;
            if (aliasValue != null) {
                alias = StringUtil.unescapeXml((String)aliasValue);
            }
            if (alias == null && (lastIndexOfDot = name.lastIndexOf(46)) >= 0) {
                alias = name.substring(lastIndexOfDot + 1);
            }
            if (!StringUtil.isNotEmpty((String)alias) || !usedAliases.add(name)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(name, DataBindingResourceType.IMPORT, tag);
            item.setSource((DataFile)resourceFile);
            items.add(item);
        }
        info.replaceItems(items, modificationCount);
    }

    private void scanDataBinding(PsiResourceFile resourceFile, long modificationCount) {
        String classPackage;
        String className;
        if (resourceFile.getFolderType() != ResourceFolderType.LAYOUT) {
            resourceFile.setDataBindingInfo(null);
            return;
        }
        XmlTag layout = ResourceFolderRepository.getLayoutTag((PsiElement)resourceFile.getPsiFile());
        if (layout == null) {
            resourceFile.setDataBindingInfo(null);
            return;
        }
        XmlTag dataTag = ResourceFolderRepository.getDataTag(layout);
        String modulePackage = ManifestInfo.get(this.myFacet.getModule(), false).getPackage();
        String classAttrValue = null;
        if (dataTag != null && (classAttrValue = dataTag.getAttributeValue("class")) != null) {
            classAttrValue = StringUtil.unescapeXml((String)classAttrValue);
        }
        if (StringUtil.isEmpty(classAttrValue)) {
            className = DataBindingUtil.convertToJavaClassName(resourceFile.getName()) + "Binding";
            classPackage = modulePackage + ".databinding";
        } else {
            int firstDotIndex = classAttrValue.indexOf(46);
            if (firstDotIndex < 0) {
                classPackage = modulePackage + ".databinding";
                className = classAttrValue;
            } else {
                int lastDotIndex = classAttrValue.lastIndexOf(46);
                classPackage = firstDotIndex == 0 ? modulePackage + classAttrValue.substring(0, lastDotIndex) : classAttrValue.substring(0, lastDotIndex);
                className = classAttrValue.substring(lastDotIndex + 1);
            }
        }
        if (resourceFile.getDataBindingInfo() == null) {
            resourceFile.setDataBindingInfo(new DataBindingInfo(this.myFacet, resourceFile, className, classPackage));
        } else {
            resourceFile.getDataBindingInfo().update(className, classPackage, modificationCount);
        }
        ResourceFolderRepository.scanDataBindingDataTag(resourceFile, dataTag, modificationCount);
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        return this.myItems;
    }

    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap = this.myItems.get(type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.myItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    public void clear() {
        super.clear();
        this.myResourceFiles.clear();
    }

    private void addIds(List<ResourceItem> items, PsiFile file) {
        this.addIds(items, (PsiElement)file, file);
    }

    private void addIds(List<ResourceItem> items, PsiElement element, PsiFile file) {
        HashMap pendingResourceIds = Maps.newHashMap();
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element, XmlTag.class);
        if (element instanceof XmlTag) {
            this.addId(items, file, (XmlTag)element, pendingResourceIds);
        }
        if (!xmlTags.isEmpty()) {
            for (XmlTag tag : xmlTags) {
                this.addId(items, file, tag, pendingResourceIds);
            }
        }
        if (!pendingResourceIds.isEmpty()) {
            ListMultimap<String, ResourceItem> map = this.getMap(ResourceType.ID, true);
            for (Map.Entry entry : pendingResourceIds.entrySet()) {
                String id = (String)entry.getKey();
                map.put((Object)id, (Object)new PsiResourceItem(id, ResourceType.ID, (XmlTag)entry.getValue(), file));
            }
        }
    }

    private void addId(List<ResourceItem> items, PsiFile file, XmlTag tag, Map<String, XmlTag> pendingResourceIds) {
        assert (tag.isValid());
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value;
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) || (value = attribute.getValue()) == null || !value.startsWith("@+id/") || "id".equals(attribute.getLocalName())) continue;
            ListMultimap<String, ResourceItem> map = this.myItems.get(ResourceType.ID);
            String id = value.substring("@+id/".length());
            if (map == null || map.containsKey((Object)id) || pendingResourceIds.containsKey(id)) continue;
            pendingResourceIds.put(id, tag);
        }
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null) {
            if (id.startsWith("@id/")) {
                if (!pendingResourceIds.containsKey(id = id.substring("@id/".length()))) {
                    return;
                }
            } else if (id.startsWith("@+id/")) {
                id = id.substring("@+id/".length());
            } else {
                return;
            }
            pendingResourceIds.remove(id);
            PsiResourceItem item = new PsiResourceItem(id, ResourceType.ID, tag, file);
            items.add(item);
            this.getMap(ResourceType.ID, true).put((Object)id, (Object)item);
        }
    }

    private void scanValueResFolder(PsiDirectory directory, String qualifiers, FolderConfiguration folderConfiguration) {
        assert (directory.getName().startsWith("values"));
        for (PsiFile file : directory.getFiles()) {
            this.scanValueFile(qualifiers, file, folderConfiguration);
        }
    }

    private boolean scanValueFile(String qualifiers, PsiFile file, FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            XmlFile xmlFile = (XmlFile)file;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root = document.getRootTag();
                if (root == null) {
                    return false;
                }
                if (!root.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root.getSubTags();
                ArrayList items = Lists.newArrayListWithExpectedSize((int)subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    ResourceType type;
                    String name = tag.getAttributeValue("name");
                    if (name == null || (type = ResourceFolderRepository.getType(tag)) == null) continue;
                    ListMultimap<String, ResourceItem> map = this.getMap(type, true);
                    PsiResourceItem item = new PsiResourceItem(name, type, tag, file);
                    map.put((Object)name, (Object)item);
                    items.add(item);
                    added = true;
                    if (type != ResourceType.DECLARE_STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    map = this.myItems.get(ResourceType.ATTR);
                    if (map == null) {
                        map = ArrayListMultimap.create();
                        this.myItems.put(ResourceType.ATTR, map);
                    }
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (attrName == null || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = new PsiResourceItem(attrName, ResourceType.ATTR, child, file);
                        items.add(attrItem);
                        map.put((Object)attrName, (Object)attrItem);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file, items, qualifiers, ResourceFolderType.VALUES, folderConfiguration);
                this.myResourceFiles.put(file, resourceFile);
            }
        }
        return added;
    }

    private static ResourceType getType(XmlTag node) {
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            String attribute = node.getAttributeValue("type");
            if (attribute != null) {
                typeString = attribute;
            }
        } else {
            typeString = nodeName;
        }
        if (typeString != null) {
            return ResourceType.getEnum((String)typeString);
        }
        return null;
    }

    private boolean isResourceFolder(PsiElement parent) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (parent instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)parent).getParentDirectory()) != null) {
            VirtualFile dir = parentDirectory.getVirtualFile();
            return dir.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(PsiFile psiFile) {
        return this.isResourceFolder((PsiElement)psiFile.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(PsiFile psiFile) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            return this.myPendingScans != null && this.myPendingScans.contains(psiFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescan(final PsiFile psiFile, final ResourceFolderType folderType) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.isScanPending(psiFile)) {
                return;
            }
            if (this.myPendingScans == null) {
                this.myPendingScans = Sets.newHashSet();
            }
            this.myPendingScans.add(psiFile);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean rescan;
                        Object object = ResourceFolderRepository.this.SCAN_LOCK;
                        synchronized (object) {
                            rescan = ResourceFolderRepository.this.myPendingScans != null && ResourceFolderRepository.this.myPendingScans.contains(psiFile);
                        }
                        if (rescan) {
                            ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
                            object = ResourceFolderRepository.this.SCAN_LOCK;
                            synchronized (object) {
                                ResourceFolderRepository.this.myPendingScans.remove(psiFile);
                                if (ResourceFolderRepository.this.myPendingScans.isEmpty()) {
                                    ResourceFolderRepository.this.myPendingScans = null;
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        ArrayList<PsiFile> files;
        super.sync();
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.myPendingScans == null || this.myPendingScans.isEmpty()) {
                return;
            }
            files = new ArrayList<PsiFile>(this.myPendingScans);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (PsiFile file : files) {
                    ResourceFolderType folderType;
                    if (!file.isValid() || (folderType = ResourceHelper.getFolderType(file)) == null) continue;
                    ResourceFolderRepository.this.rescanImmediately(file, folderType);
                }
            }
        });
        object = this.SCAN_LOCK;
        synchronized (object) {
            this.myPendingScans = null;
        }
    }

    private void rescanImmediately(PsiFile psiFile, ResourceFolderType folderType) {
        PsiFile file = psiFile;
        if (folderType == ResourceFolderType.VALUES) {
            ++ourFullRescans;
            PsiResourceFile resourceFile = this.myResourceFiles.get(file);
            boolean removed = false;
            if (resourceFile != null) {
                for (ResourceItem item : resourceFile) {
                    removed |= this.removeItems(resourceFile, item.getType(), item.getName(), false);
                }
                this.myResourceFiles.remove(file);
            }
            file = this.ensureValid(file);
            boolean added = false;
            if (file != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                String dirName = parent.getName();
                PsiDirectory fileParent = psiFile.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    added = this.scanValueFile(ResourceFolderRepository.getQualifiers(dirName), file, folderConfiguration);
                }
            }
            if (added || removed) {
                ++this.myGeneration;
                this.invalidateItemCaches(new ResourceType[0]);
            }
        } else {
            PsiResourceFile resourceFile = this.myResourceFiles.get(file);
            if (resourceFile != null) {
                if (folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU) {
                    ArrayList idItems;
                    ++ourFullRescans;
                    HashSet idsBefore = Sets.newHashSet();
                    HashSet idsAfter = Sets.newHashSet();
                    ListMultimap<String, ResourceItem> map = this.myItems.get(ResourceType.ID);
                    if (map != null) {
                        idItems = Lists.newArrayList();
                        for (ResourceItem item : resourceFile) {
                            if (item.getType() != ResourceType.ID) continue;
                            idsBefore.add(item.getName());
                            idItems.add(item);
                        }
                        for (String id : idsBefore) {
                            List mapItems = map.get((Object)id);
                            if (mapItems == null || mapItems.isEmpty()) continue;
                            ArrayList toDelete = Lists.newArrayListWithExpectedSize((int)mapItems.size());
                            for (ResourceItem mapItem : mapItems) {
                                if (mapItem.getSource() != resourceFile) continue;
                                toDelete.add(mapItem);
                            }
                            for (ResourceItem delete : toDelete) {
                                map.remove((Object)delete.getName(), (Object)delete);
                            }
                        }
                        resourceFile.removeItems(idItems);
                    }
                    idItems = Lists.newArrayList();
                    if ((file = this.ensureValid(file)) != null) {
                        this.addIds(idItems, file);
                    }
                    if (!idItems.isEmpty()) {
                        resourceFile.addItems(idItems);
                        for (ResourceItem item : idItems) {
                            idsAfter.add(item.getName());
                        }
                    }
                    if (!((Object)idsBefore).equals(idsAfter)) {
                        ++this.myGeneration;
                    }
                    this.scanDataBinding(resourceFile, this.myGeneration);
                    this.invalidateItemCaches(ResourceType.ID);
                }
            } else {
                boolean idGenerating;
                ++ourFullRescans;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                String dirName = parent.getName();
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                assert (resourceTypes.size() >= 1) : folderType;
                ResourceType type = (ResourceType)resourceTypes.get(0);
                boolean bl = idGenerating = resourceTypes.size() > 1;
                assert (!idGenerating || resourceTypes.size() == 2 && resourceTypes.get(1) == ResourceType.ID);
                ListMultimap<String, ResourceItem> map = this.getMap(type, true);
                if ((file = this.ensureValid(file)) != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        this.scanFileResourceFile(ResourceFolderRepository.getQualifiers(dirName), folderType, folderConfiguration, type, idGenerating, map, file);
                    }
                    ++this.myGeneration;
                    this.invalidateItemCaches(new ResourceType[0]);
                }
            }
        }
    }

    private boolean removeItems(PsiResourceFile resourceFile, ResourceType type, String name, boolean removeFromFile) {
        List mapItems;
        boolean removed = false;
        ListMultimap<String, ResourceItem> map = this.myItems.get(type);
        if (map != null && (mapItems = map.get((Object)name)) != null) {
            ListIterator iterator = mapItems.listIterator();
            while (iterator.hasNext()) {
                ResourceItem next = (ResourceItem)iterator.next();
                if (next.getSource() != resourceFile) continue;
                iterator.remove();
                if (removeFromFile) {
                    resourceFile.removeItem(next);
                }
                removed = true;
            }
        }
        return removed;
    }

    private void bitmapUpdated() {
        Module module;
        AndroidTargetData targetData;
        IAndroidTarget target;
        ConfigurationManager configurationManager = this.myFacet.getConfigurationManager(false);
        if (configurationManager != null && (target = configurationManager.getTarget()) != null && (targetData = AndroidTargetData.getTargetData(target, module = this.myFacet.getModule())) != null) {
            targetData.clearLayoutBitmapCache(module);
        }
    }

    public PsiTreeChangeListener getPsiListener() {
        return this.myListener;
    }

    private PsiResourceFile findResourceFile(String dirName, String fileName) {
        String folderTypeName;
        String qualifiers;
        int index = dirName.indexOf(45);
        if (index == -1) {
            qualifiers = "";
            folderTypeName = dirName;
        } else {
            qualifiers = dirName.substring(index + 1);
            folderTypeName = dirName.substring(0, index);
        }
        ResourceFolderType folderType = ResourceFolderType.getTypeByName((String)folderTypeName);
        for (PsiResourceFile file : this.myResourceFiles.values()) {
            String name = file.getName();
            if (folderType != file.getFolderType() || !fileName.equals(name) || !qualifiers.equals(file.getQualifiers())) continue;
            return file;
        }
        return null;
    }

    private void removeItemsFromFile(PsiResourceFile resourceFile) {
        for (ResourceItem item : resourceFile) {
            this.removeItems(resourceFile, item.getType(), item.getName(), false);
        }
    }

    private static boolean isItemElement(XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.getEnum((String)tag) != null;
    }

    private ResourceItem findValueResourceItem(XmlTag tag, PsiFile file) {
        if (!tag.isValid()) {
            PsiResourceFile resourceFile = this.myResourceFiles.get(file);
            if (resourceFile != null) {
                for (ResourceItem item : resourceFile) {
                    PsiResourceItem pri = (PsiResourceItem)item;
                    XmlTag xmlTag = pri.getTag();
                    if (xmlTag != tag) continue;
                    return item;
                }
            }
            return null;
        }
        String name = tag.getAttributeValue("name");
        return name != null ? this.findValueResourceItem(tag, file, name) : null;
    }

    private ResourceItem findValueResourceItem(XmlTag tag, PsiFile file, String name) {
        ResourceType type = ResourceFolderRepository.getType(tag);
        return this.findResourceItem(type, file, name, tag);
    }

    private ResourceItem findResourceItem(ResourceType type, PsiFile file, String name, XmlTag tag) {
        ListMultimap<String, ResourceItem> map;
        if (type != null && name != null && (map = this.myItems.get(type)) != null) {
            PsiResourceItem psiItem;
            List items = map.get((Object)name);
            assert (items != null);
            if (tag != null) {
                for (ResourceItem item : items) {
                    assert (item instanceof PsiResourceItem);
                    psiItem = (PsiResourceItem)item;
                    if (psiItem.getTag() != tag) continue;
                    return item;
                }
            }
            for (ResourceItem item : items) {
                assert (item instanceof PsiResourceItem);
                psiItem = (PsiResourceItem)item;
                PsiFile virtualFile = psiItem.getPsiFile();
                if (virtualFile != file) continue;
                return item;
            }
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    private final class PsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;
        private boolean mySeenPrePropertyChange;

        private PsiListener() {
        }

        public void childAdded(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                PsiDirectory directory;
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    psiFile = (PsiFile)child;
                    if (PsiProjectListener.isRelevantFile(psiFile)) {
                        this.addFile(psiFile);
                    }
                } else if (child instanceof PsiDirectory && ResourceFolderRepository.this.isResourceFolder((PsiElement)(directory = (PsiDirectory)child))) {
                    for (PsiFile file : directory.getFiles()) {
                        if (!PsiProjectListener.isRelevantFile(file)) continue;
                        this.addFile(file);
                    }
                }
            } else if (PsiProjectListener.isRelevantFile(psiFile)) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (folderType == ResourceFolderType.VALUES) {
                        if (child instanceof XmlTag) {
                            ResourceItem style;
                            PsiResourceFile resourceFile;
                            XmlTag tag = (XmlTag)child;
                            if (ResourceFolderRepository.isItemElement(tag) && (resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile)) != null) {
                                String name = tag.getAttributeValue("name");
                                if (name != null) {
                                    ResourceType type = ResourceFolderRepository.getType(tag);
                                    if (type == ResourceType.DECLARE_STYLEABLE) {
                                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                                        return;
                                    }
                                    if (type != null) {
                                        ListMultimap<String, ResourceItem> map = ResourceFolderRepository.this.getMap(type, true);
                                        PsiResourceItem item = new PsiResourceItem(name, type, tag, psiFile);
                                        map.put((Object)name, (Object)item);
                                        resourceFile.addItems(Collections.singletonList(item));
                                        ++ResourceFolderRepository.this.myGeneration;
                                        ResourceFolderRepository.this.invalidateItemCaches(type);
                                    }
                                }
                                return;
                            }
                            XmlTag parentTag = tag.getParentTag();
                            if (parentTag != null && ResourceType.getEnum((String)parentTag.getName()) != null && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                if (((PsiResourceItem)style).recomputeValue()) {
                                    ++ResourceFolderRepository.this.myGeneration;
                                }
                                return;
                            }
                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                        } else {
                            if (parent instanceof XmlText) {
                                XmlText text = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile);
                                return;
                            }
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU) {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                            return;
                        }
                        if (parent instanceof XmlElement && child instanceof XmlElement) {
                            if (child instanceof XmlTag) {
                                PsiResourceFile resourceFile;
                                ArrayList ids = Lists.newArrayList();
                                ResourceFolderRepository.this.addIds(ids, child, psiFile);
                                if (!ids.isEmpty() && (resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile)) != null) {
                                    resourceFile.addItems(ids);
                                    ++ResourceFolderRepository.this.myGeneration;
                                }
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent instanceof XmlAttribute) : parent;
                                XmlAttribute attribute = (XmlAttribute)parent;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (ArrayUtil.contains((String)attribute.getLocalName(), (String[])SdkConstants.ATTRS_DATA_BINDING) && ArrayUtil.contains((String)attribute.getParent().getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING)) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                }
                            }
                        }
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void childRemoved(PsiTreeChangeEvent event) {
            block24: {
                ResourceFolderType folderType;
                PsiFile psiFile;
                block26: {
                    PsiElement parent;
                    PsiElement child;
                    block27: {
                        PsiResourceFile resourceFile;
                        ResourceItem style;
                        XmlTag parentTag;
                        block25: {
                            String dirName;
                            ResourceFolderType folderType2;
                            psiFile = event.getFile();
                            if (psiFile != null) break block25;
                            PsiElement child2 = event.getChild();
                            if (child2 instanceof PsiFile) {
                                psiFile = (PsiFile)child2;
                                if (PsiProjectListener.isRelevantFile(psiFile)) {
                                    this.removeFile(psiFile);
                                }
                                break block24;
                            } else if (child2 instanceof PsiDirectory && (folderType2 = ResourceFolderType.getFolderType((String)(dirName = ((PsiDirectory)child2).getName()))) != null) {
                                PsiDirectory parentDirectory = ((PsiDirectory)child2).getParent();
                                if (parentDirectory == null) {
                                    return;
                                }
                                VirtualFile dir = parentDirectory.getVirtualFile();
                                if (!ResourceFolderRepository.this.myFacet.getLocalResourceManager().isResourceDir(dir)) {
                                    return;
                                }
                                int index = dirName.indexOf(45);
                                String qualifiers = index == -1 ? "" : dirName.substring(index + 1);
                                ArrayList resourceFiles = new ArrayList(ResourceFolderRepository.this.myResourceFiles.values());
                                for (PsiResourceFile file : resourceFiles) {
                                    if (folderType2 != file.getFolderType() || !qualifiers.equals(file.getQualifiers())) continue;
                                    this.removeFile(file);
                                }
                            }
                            break block24;
                        }
                        if (!PsiProjectListener.isRelevantFile(psiFile)) break block24;
                        if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                            return;
                        }
                        folderType = ResourceHelper.getFolderType(psiFile);
                        if (folderType == null || !ResourceFolderRepository.this.isResourceFile(psiFile)) break block24;
                        child = event.getChild();
                        parent = event.getParent();
                        if (folderType != ResourceFolderType.VALUES) break block26;
                        if (!(child instanceof XmlTag)) break block27;
                        XmlTag tag = (XmlTag)child;
                        if (parent instanceof XmlTag && ResourceType.getEnum((String)(parentTag = (XmlTag)parent).getName()) != null && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                            ResourceItem declareStyleable;
                            if (((PsiResourceItem)style).recomputeValue()) {
                                ++ResourceFolderRepository.this.myGeneration;
                            }
                            if (style.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && parentTag.getName().equals(ResourceType.DECLARE_STYLEABLE.getName()) && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                ++ResourceFolderRepository.this.myGeneration;
                            }
                            return;
                        }
                        if (ResourceFolderRepository.isItemElement(tag) && (resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile)) != null) {
                            ResourceType type;
                            String name;
                            if (!tag.isValid()) {
                                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile);
                                if (item == null) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                    return;
                                }
                                name = item.getName();
                            } else {
                                name = tag.getAttributeValue("name");
                            }
                            if (name != null && (type = ResourceFolderRepository.getType(tag)) != null) {
                                ListMultimap map = (ListMultimap)ResourceFolderRepository.this.myItems.get(type);
                                if (map == null) {
                                    return;
                                }
                                if (ResourceFolderRepository.this.removeItems(resourceFile, type, name, true)) {
                                    ++ResourceFolderRepository.this.myGeneration;
                                    ResourceFolderRepository.this.invalidateItemCaches(type);
                                }
                            }
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                        break block24;
                    }
                    if (parent instanceof XmlText) {
                        XmlText text = (XmlText)parent;
                        this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                        break block24;
                    } else if (child instanceof XmlText) {
                        this.handleValueXmlTextEdit(parent, psiFile);
                        break block24;
                    } else {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    }
                    break block24;
                }
                if (folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void removeFile(PsiResourceFile resourceFile) {
            if (resourceFile == null) {
                return;
            }
            for (Map.Entry entry : ResourceFolderRepository.this.myResourceFiles.entrySet()) {
                PsiResourceFile file = (PsiResourceFile)entry.getValue();
                if (resourceFile != file) continue;
                PsiFile psiFile = (PsiFile)entry.getKey();
                ResourceFolderRepository.this.myResourceFiles.remove(psiFile);
                break;
            }
            ++ResourceFolderRepository.this.myGeneration;
            ResourceFolderRepository.this.invalidateItemCaches(new ResourceType[0]);
            ResourceFolderType folderType = resourceFile.getFolderType();
            if (folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU) {
                ResourceFolderRepository.this.removeItemsFromFile(resourceFile);
            } else if (folderType != null) {
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : resourceTypes) {
                    if (type == ResourceType.ID) continue;
                    String name = LintUtils.getBaseName((String)resourceFile.getName());
                    ResourceFolderRepository.this.removeItems(resourceFile, type, name, false);
                }
            }
        }

        private void removeFile(PsiFile psiFile) {
            assert (!psiFile.isValid() || PsiProjectListener.isRelevantFile(psiFile));
            PsiResourceFile resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile);
            if (resourceFile == null) {
                return;
            }
            ResourceFolderRepository.this.myResourceFiles.remove(psiFile);
            ++ResourceFolderRepository.this.myGeneration;
            ResourceFolderRepository.this.invalidateItemCaches(new ResourceType[0]);
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU) {
                ResourceFolderRepository.this.removeItemsFromFile(resourceFile);
            } else if (folderType != null) {
                FileType fileType;
                if (folderType == ResourceFolderType.DRAWABLE && (fileType = psiFile.getFileType()).isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png")) {
                    ResourceFolderRepository.this.bitmapUpdated();
                }
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : resourceTypes) {
                    if (type == ResourceType.ID) continue;
                    String name = ResourceHelper.getResourceName(psiFile);
                    ResourceFolderRepository.this.removeItems(resourceFile, type, name, false);
                }
            }
        }

        private void addFile(PsiFile psiFile) {
            assert (PsiProjectListener.isRelevantFile(psiFile));
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
            }
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                if (PsiProjectListener.isRelevantFile(psiFile)) {
                    PsiElement parent;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU) {
                        PsiElement parent2 = event.getParent();
                        PsiElement child = event.getChild();
                        if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                            if (event.getOldChild() == event.getNewChild()) {
                                ResourceFolderRepository.this.rescan(psiFile, folderType);
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent2 instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    PsiResourceFile resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile);
                                    if (resourceFile != null) {
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                            ListMultimap map;
                                            String newName;
                                            XmlAttributeValue oldValue = (XmlAttributeValue)oldChild;
                                            XmlAttributeValue newValue = (XmlAttributeValue)newChild;
                                            String oldName = LintUtils.stripIdPrefix((String)oldValue.getValue());
                                            if (oldName.equals(newName = LintUtils.stripIdPrefix((String)newValue.getValue()))) {
                                                return;
                                            }
                                            ResourceItem item = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                                            if (item != null && (map = (ListMultimap)ResourceFolderRepository.this.myItems.get(item.getType())) != null) {
                                                map.remove((Object)oldName, (Object)item);
                                                PsiResourceItem newItem = new PsiResourceItem(newName, ResourceType.ID, xmlTag, psiFile);
                                                map.put((Object)newName, (Object)newItem);
                                                resourceFile.replace(item, newItem);
                                                ++ResourceFolderRepository.this.myGeneration;
                                                ResourceFolderRepository.this.invalidateItemCaches(ResourceType.ID);
                                                return;
                                            }
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                }
                            } else if (parent2 instanceof XmlAttributeValue) {
                                PsiResourceFile resourceFile;
                                assert (parent2.getParent() instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2.getParent();
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    PsiResourceFile resourceFile2 = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile);
                                    if (resourceFile2 != null) {
                                        ListMultimap map;
                                        String newName;
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        String oldName = LintUtils.stripIdPrefix((String)oldChild.getText());
                                        if (oldName.equals(newName = LintUtils.stripIdPrefix((String)newChild.getText()))) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                                        if (item != null && (map = (ListMultimap)ResourceFolderRepository.this.myItems.get(item.getType())) != null) {
                                            map.remove((Object)oldName, (Object)item);
                                            PsiResourceItem newItem = new PsiResourceItem(newName, ResourceType.ID, xmlTag, psiFile);
                                            map.put((Object)newName, (Object)newItem);
                                            resourceFile2.replace(item, newItem);
                                            ++ResourceFolderRepository.this.myGeneration;
                                            ResourceFolderRepository.this.invalidateItemCaches(ResourceType.ID);
                                            return;
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (ArrayUtil.contains((String)attribute.getLocalName(), (String[])SdkConstants.ATTRS_DATA_BINDING) && ArrayUtil.contains((String)attribute.getParent().getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING) && (resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile)) != null) {
                                    ++ResourceFolderRepository.this.myGeneration;
                                    ResourceFolderRepository.this.scanDataBinding(resourceFile, ResourceFolderRepository.this.myGeneration);
                                }
                            }
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.VALUES) {
                        PsiElement parent3 = event.getParent();
                        if (parent3 instanceof XmlElement) {
                            if (parent3 instanceof XmlTag) {
                                ResourceItem style;
                                XmlTag parentTag = (XmlTag)parent3;
                                if (ResourceType.getEnum((String)parentTag.getName()) != null && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                    if (((PsiResourceItem)style).recomputeValue()) {
                                        ++ResourceFolderRepository.this.myGeneration;
                                    }
                                    return;
                                }
                                if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                    return;
                                }
                            }
                            if (parent3 instanceof XmlText) {
                                XmlText text = (XmlText)parent3;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (parent3 instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlAttributeValue) {
                                PsiElement attribute = parent3.getParent();
                                if (attribute instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                PsiElement tag = attribute.getParent();
                                assert (attribute instanceof XmlAttribute) : attribute;
                                XmlAttribute xmlAttribute = (XmlAttribute)attribute;
                                assert (tag instanceof XmlTag) : tag;
                                XmlTag xmlTag = (XmlTag)tag;
                                String attributeName = xmlAttribute.getName();
                                if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                    ResourceType type = ResourceFolderRepository.getType(xmlTag);
                                    if (type != null) {
                                        ListMultimap map;
                                        String newName;
                                        String oldName = event.getOldChild().getText();
                                        if (oldName.equals(newName = event.getNewChild().getText())) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile, oldName, xmlTag);
                                        if (item != null && (map = (ListMultimap)ResourceFolderRepository.this.myItems.get(item.getType())) != null) {
                                            ResourceItem style;
                                            XmlTag parentTag;
                                            map.remove((Object)oldName, (Object)item);
                                            PsiResourceItem newItem = new PsiResourceItem(newName, type, xmlTag, psiFile);
                                            map.put((Object)newName, (Object)newItem);
                                            PsiResourceFile resourceFile = (PsiResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile);
                                            if (resourceFile != null) {
                                                resourceFile.replace(item, newItem);
                                            } else assert (false) : item;
                                            ++ResourceFolderRepository.this.myGeneration;
                                            ResourceFolderRepository.this.invalidateItemCaches(type);
                                            if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && parentTag.getName().equals(ResourceType.DECLARE_STYLEABLE.getName()) && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                                ((PsiResourceItem)style).recomputeValue();
                                            }
                                            return;
                                        }
                                    } else {
                                        ResourceItem style;
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && ResourceType.getEnum((String)parentTag.getName()) != null && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                            if (((PsiResourceItem)style).recomputeValue()) {
                                                ++ResourceFolderRepository.this.myGeneration;
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.COLOR && (parent = event.getParent()) instanceof XmlElement) {
                        PsiElement attribute;
                        if (parent instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlAttributeValue && (attribute = parent.getParent()) instanceof XmlProcessingInstruction) {
                            return;
                        }
                        ++ResourceFolderRepository.this.myGeneration;
                        return;
                    }
                }
            } else {
                PsiElement parent = event.getParent();
                if (ResourceFolderRepository.this.isResourceFolder(parent)) {
                    PsiFile newFile;
                    PsiFile oldFile;
                    PsiElement oldChild = event.getOldChild();
                    PsiElement newChild = event.getNewChild();
                    if (oldChild instanceof PsiFile && PsiProjectListener.isRelevantFile(oldFile = (PsiFile)oldChild)) {
                        this.removeFile(oldFile);
                    }
                    if (newChild instanceof PsiFile && PsiProjectListener.isRelevantFile(newFile = (PsiFile)newChild)) {
                        this.addFile(newFile);
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void handleValueXmlTextEdit(PsiElement parent, PsiFile psiFile) {
            XmlTag style;
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.getEnum((String)style.getName()) != null) {
                boolean cleared;
                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile);
                if (item instanceof PsiResourceItem && (cleared = ((PsiResourceItem)item).recomputeValue())) {
                    ++ResourceFolderRepository.this.myGeneration;
                }
                return;
            }
            while (parentTag != null) {
                if (ResourceFolderRepository.isItemElement(parentTag)) {
                    boolean cleared;
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                    if (!(item instanceof PsiResourceItem) || !(cleared = ((PsiResourceItem)item).recomputeValue())) break;
                    ++ResourceFolderRepository.this.myGeneration;
                    break;
                }
                parentTag = parentTag.getParentTag();
            }
        }

        public void childMoved(PsiTreeChangeEvent event) {
            PsiElement child = event.getChild();
            PsiFile psiFile = event.getFile();
            if (psiFile == null && child instanceof PsiFile) {
                boolean isResourceFolder;
                psiFile = (PsiFile)child;
                if (!PsiProjectListener.isRelevantFile(psiFile)) {
                    return;
                }
                String name = psiFile.getName();
                PsiElement oldParent = event.getOldParent();
                if (!(oldParent instanceof PsiDirectory)) {
                    this.addFile(psiFile);
                    return;
                }
                PsiDirectory oldParentDir = (PsiDirectory)oldParent;
                String oldDirName = oldParentDir.getName();
                ResourceFolderType oldFolderType = ResourceFolderType.getFolderType((String)oldDirName);
                ResourceFolderType newFolderType = ResourceHelper.getFolderType(psiFile);
                boolean wasResourceFolder = oldFolderType != null && ResourceFolderRepository.this.isResourceFolder((PsiElement)oldParentDir);
                boolean bl = isResourceFolder = newFolderType != null && ResourceFolderRepository.this.isResourceFile(psiFile);
                if (wasResourceFolder == isResourceFolder) {
                    if (!isResourceFolder) {
                        return;
                    }
                    PsiResourceFile resourceFile = ResourceFolderRepository.this.findResourceFile(oldDirName, name);
                    if (resourceFile != null) {
                        if (oldFolderType != newFolderType) {
                            this.removeFile(resourceFile);
                            this.addFile(psiFile);
                        } else {
                            ResourceFolderRepository.this.myResourceFiles.remove(resourceFile.getPsiFile());
                            ResourceFolderRepository.this.myResourceFiles.put(psiFile, resourceFile);
                            PsiDirectory newParent = psiFile.getParent();
                            assert (newParent != null);
                            String newDirName = newParent.getName();
                            resourceFile.setPsiFile(psiFile, ResourceFolderRepository.getQualifiers(newDirName));
                            ++ResourceFolderRepository.this.myGeneration;
                            for (ResourceItem item : resourceFile) {
                                if (!(item instanceof PsiResourceItem)) continue;
                                ((PsiResourceItem)item).recomputeValue();
                            }
                            ResourceFolderRepository.this.invalidateItemCaches(new ResourceType[0]);
                        }
                    } else {
                        this.addFile(psiFile);
                    }
                } else if (isResourceFolder) {
                    this.addFile(psiFile);
                } else {
                    assert (wasResourceFolder);
                    String dirName = oldParentDir.getName();
                    PsiResourceFile resourceFile = ResourceFolderRepository.this.findResourceFile(dirName, name);
                    if (resourceFile != null) {
                        this.removeFile(resourceFile);
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        public final void beforeChildrenChange(PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            if (this.myIgnoreChildrenChanged ? event.getParent() != event.getChild() : event.getNewChild() == null && event.getOldChild() == null && event.getOldParent() == null && event.getNewParent() == null && event.getParent() instanceof PsiFile) {
                return;
            }
            PsiFile psiFile = event.getFile();
            if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
                ResourceFolderType folderType;
                VirtualFile file = psiFile.getVirtualFile();
                if (file != null && (folderType = ResourceHelper.getFolderType(psiFile)) != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            } else {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
        }

        public final void beforePropertyChange(PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child) && ResourceFolderRepository.this.isResourceFolder(event.getParent())) {
                this.removeFile(psiFile);
            }
            this.mySeenPrePropertyChange = true;
        }

        public void propertyChanged(PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if ("fileName" == event.getPropertyName() && ResourceFolderRepository.this.isResourceFolder(event.getParent()) && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child) && ResourceFolderRepository.this.isResourceFolder(event.getParent())) {
                Object oldValue;
                if (!this.mySeenPrePropertyChange && (oldValue = event.getOldValue()) instanceof String) {
                    PsiDirectory parent = psiFile.getParent();
                    String oldName = (String)oldValue;
                    if (parent != null && parent.findFile(oldName) == null) {
                        this.removeFile(ResourceFolderRepository.this.findResourceFile(parent.getName(), oldName));
                    }
                }
                this.addFile(psiFile);
            }
            this.mySeenPrePropertyChange = false;
        }
    }
}

