/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.lang.databinding.DbUtil;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;

public class ResourceHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.ResourceHelper");
    public static final String STATE_NAME_PREFIX = "state_";

    public static boolean isProjectStyle(String style) {
        assert (style.startsWith("@style/") || style.startsWith("@android:style/")) : style;
        return style.startsWith("@style/");
    }

    public static String styleToTheme(String style) {
        int index;
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        } else if (style.startsWith("@") && (index = style.indexOf(47)) != -1) {
            style = style.substring(index + 1);
        }
        return style;
    }

    public static boolean isValueBasedResourceType(ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType != ResourceFolderType.VALUES) continue;
            return true;
        }
        return false;
    }

    public static String getResourceName(VirtualFile file) {
        return LintUtils.getBaseName((String)file.getName());
    }

    public static String getResourceName(PsiFile file) {
        return LintUtils.getBaseName((String)file.getName());
    }

    public static String getResourceUrl(VirtualFile file) {
        ResourceFolderType type = ResourceFolderType.getFolderType((String)file.getParent().getName());
        assert (type != null && type != ResourceFolderType.VALUES);
        return "@" + type.getName() + '/' + ResourceHelper.getResourceName(file);
    }

    public static boolean isFileBasedResourceType(ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    public static ResourceFolderType getFolderType(final PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

                    public ResourceFolderType compute() {
                        return ResourceHelper.getFolderType(file);
                    }
                });
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderType(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return ResourceFolderType.getFolderType((String)parent.getName());
            }
        }
        return null;
    }

    public static ResourceFolderType getFolderType(VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return ResourceFolderType.getFolderType((String)parent.getName());
        }
        return null;
    }

    public static FolderConfiguration getFolderConfiguration(final PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (FolderConfiguration)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FolderConfiguration>(){

                    public FolderConfiguration compute() {
                        return ResourceHelper.getFolderConfiguration(file);
                    }
                });
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderConfiguration(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return FolderConfiguration.getConfigForFolder((String)parent.getName());
            }
        }
        return null;
    }

    public static FolderConfiguration getFolderConfiguration(VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return FolderConfiguration.getConfigForFolder((String)parent.getName());
        }
        return null;
    }

    public static List<VirtualFile> getResourceVariations(VirtualFile file, boolean includeSelf) {
        VirtualFile resFolder;
        if (file == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> variations = new ArrayList<VirtualFile>();
        String name = file.getName();
        VirtualFile parent = file.getParent();
        if (parent != null && (resFolder = parent.getParent()) != null) {
            String parentName = parent.getName();
            String prefix = parentName;
            int qualifiers = prefix.indexOf(45);
            if (qualifiers != -1) {
                parentName = prefix.substring(0, qualifiers);
                prefix = prefix.substring(0, qualifiers + 1);
            } else {
                prefix = prefix + '-';
            }
            for (VirtualFile resource : resFolder.getChildren()) {
                VirtualFile variation;
                String n = resource.getName();
                if (!n.startsWith(prefix) && !n.equals(parentName) || !resource.isDirectory() || (variation = resource.findChild(name)) == null || !includeSelf && file.equals(variation)) continue;
                variations.add(variation);
            }
        }
        return variations;
    }

    public static boolean viewNeedsPackage(String fqcn) {
        return !fqcn.startsWith("android.widget.") && !fqcn.startsWith("android.view.") && !fqcn.startsWith("android.webkit.");
    }

    public static Color resolveColor(RenderResources resources, ResourceValue colorValue, Project project) {
        if (colorValue != null) {
            colorValue = resources.resolveResValue(colorValue);
        }
        if (colorValue == null) {
            return null;
        }
        StateList stateList = ResourceHelper.resolveStateList(resources, colorValue, project);
        if (stateList != null) {
            List<StateListState> states = stateList.getStates();
            StateListState state = states.get(states.size() - 1);
            Color stateColor = ResourceHelper.parseColor(state.getValue());
            if (stateColor == null) {
                stateColor = ResourceHelper.resolveColor(resources, resources.findResValue(state.getValue(), false), project);
            }
            if (stateColor == null) {
                return null;
            }
            try {
                return ResourceHelper.makeColorWithAlpha(resources, stateColor, state.getAlpha());
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("The alpha attribute in %s/%s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                return stateColor;
            }
        }
        return ResourceHelper.parseColor(colorValue.getValue());
    }

    public static List<Color> resolveMultipleColors(RenderResources resources, ResourceValue value, Project project) {
        if (value != null) {
            value = resources.resolveResValue(value);
        }
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<Color> result = new ArrayList<Color>();
        StateList stateList = ResourceHelper.resolveStateList(resources, value, project);
        if (stateList != null) {
            for (StateListState state : stateList.getStates()) {
                Color color;
                ResourceValue resolvedStateResource = resources.findResValue(state.getValue(), false);
                ImmutableList stateColors = resolvedStateResource != null ? ResourceHelper.resolveMultipleColors(resources, resolvedStateResource, project) : ((color = ResourceHelper.parseColor(state.getValue())) == null ? Collections.emptyList() : ImmutableList.of((Object)color));
                for (Color color2 : stateColors) {
                    try {
                        result.add(ResourceHelper.makeColorWithAlpha(resources, color2, state.getAlpha()));
                    }
                    catch (NumberFormatException e) {
                        result.add(color2);
                        LOG.warn(String.format("The alpha attribute in %s/%s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                    }
                }
            }
        } else {
            Color color = ResourceHelper.parseColor(value.getValue());
            if (color != null) {
                result.add(color);
            }
        }
        return result;
    }

    public static String resolveStringValue(RenderResources resources, String value) {
        ResourceValue resValue = resources.findResValue(value, false);
        if (resValue == null) {
            return value;
        }
        ResourceValue finalValue = resources.resolveResValue(resValue);
        if (finalValue == null || finalValue.getValue() == null) {
            return value;
        }
        return finalValue.getValue();
    }

    private static Color makeColorWithAlpha(RenderResources resources, Color color, String alphaValue) throws NumberFormatException {
        int combinedAlpha;
        float alpha = 1.0f;
        if (alphaValue != null) {
            alpha = Float.parseFloat(ResourceHelper.resolveStringValue(resources, alphaValue));
        }
        if ((combinedAlpha = (int)((float)color.getAlpha() * alpha)) < 0) {
            combinedAlpha = 0;
        }
        if (combinedAlpha > 255) {
            combinedAlpha = 255;
        }
        return ColorUtil.toAlpha((Color)color, (int)combinedAlpha);
    }

    public static StateList resolveStateList(RenderResources renderResources, ResourceValue value, Project project) {
        if (value.getValue().startsWith("@")) {
            ResourceValue resValue = renderResources.findResValue(value.getValue(), value.isFramework());
            if (resValue != null) {
                return ResourceHelper.resolveStateList(renderResources, resValue, project);
            }
        } else {
            XmlTag rootTag;
            PsiFile psiFile;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(value.getValue());
            if (virtualFile != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(project, virtualFile)) instanceof XmlFile && (rootTag = ((XmlFile)psiFile).getRootTag()) != null && "selector".equals(rootTag.getName())) {
                StateList stateList = new StateList(psiFile.getName(), psiFile.getContainingDirectory().getName());
                for (XmlTag subTag : rootTag.findSubTags("item")) {
                    StateListState stateListState = ResourceHelper.createStateListState(subTag, value.isFramework());
                    if (stateListState == null) {
                        return null;
                    }
                    stateList.addState(stateListState);
                }
                return stateList;
            }
        }
        return null;
    }

    private static StateListState createStateListState(XmlTag tag, boolean isFramework) {
        XmlAttribute[] attributes;
        String stateValue = null;
        String alphaValue = null;
        HashMap<String, Boolean> stateAttributes = new HashMap<String, Boolean>();
        for (XmlAttribute attr : attributes = tag.getAttributes()) {
            ResourceUrl url;
            String name = attr.getLocalName();
            String value = attr.getValue();
            if (value == null) continue;
            if ("color".equals(name) || "drawable".equals(name)) {
                url = ResourceUrl.parse((String)value, (boolean)isFramework);
                stateValue = url != null ? url.toString() : value;
                continue;
            }
            if ("alpha".equals(name)) {
                url = ResourceUrl.parse((String)value, (boolean)isFramework);
                alphaValue = url != null ? url.toString() : value;
                continue;
            }
            if (!name.startsWith(STATE_NAME_PREFIX)) continue;
            stateAttributes.put(name, Boolean.valueOf(value));
        }
        if (stateValue == null) {
            return null;
        }
        return new StateListState(stateValue, stateAttributes, alphaValue);
    }

    public static Color parseColor(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        if (s.charAt(0) == '#') {
            long longColor;
            try {
                longColor = Long.parseLong(s.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (s.length() == 4 || s.length() == 5) {
                long a = s.length() == 4 ? 255L : ResourceHelper.extend((longColor & 0xF000L) >> 12);
                long r = ResourceHelper.extend((longColor & 0xF00L) >> 8);
                long g = ResourceHelper.extend((longColor & 0xF0L) >> 4);
                long b = ResourceHelper.extend(longColor & 0xFL);
                longColor = a << 24 | r << 16 | g << 8 | b;
                return new Color((int)longColor, true);
            }
            if (s.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (s.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    public static String colorToString(Color color) {
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            return String.format("#%08x", longColor |= (long)color.getAlpha() << 24);
        }
        return String.format("#%06x", longColor);
    }

    private static long extend(long nibble) {
        return nibble | nibble << 4;
    }

    public static File resolveDrawable(RenderResources resources, ResourceValue drawable, Project project) {
        File file;
        List<StateListState> states;
        if (drawable != null) {
            drawable = resources.resolveResValue(drawable);
        }
        if (drawable == null) {
            return null;
        }
        String result = drawable.getValue();
        StateList stateList = ResourceHelper.resolveStateList(resources, drawable, project);
        if (stateList != null && !(states = stateList.getStates()).isEmpty()) {
            StateListState state = states.get(states.size() - 1);
            result = state.getValue();
        }
        return (file = new File(result)).isFile() ? file : null;
    }

    public static File resolveLayout(RenderResources resources, ResourceValue layout) {
        if (layout != null) {
            layout = resources.resolveResValue(layout);
        }
        if (layout == null) {
            return null;
        }
        String value = layout.getValue();
        for (int depth = 0; value != null && depth < 50; ++depth) {
            if (value.startsWith("@{") && (value = DbUtil.getBindingExprDefault(value)) == null) {
                return null;
            }
            if (value.startsWith("@")) {
                boolean isFramework = layout.isFramework();
                if ((layout = resources.findResValue(value, isFramework)) == null) break;
            } else {
                File file = new File(value);
                if (file.exists()) {
                    return file;
                }
                return null;
            }
            value = layout.getValue();
        }
        return null;
    }

    public static String prependResourcePrefix(Module module, String name) {
        String resourcePrefix;
        AndroidGradleModel androidModel;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidGradleModel.get(facet)) != null && (resourcePrefix = LintUtils.computeResourcePrefix((AndroidProject)androidModel.getAndroidProject())) != null) {
            if (name != null) {
                return name.startsWith(resourcePrefix) ? name : LintUtils.computeResourceName((String)resourcePrefix, (String)name);
            }
            return resourcePrefix;
        }
        return name;
    }

    public static class StateListState {
        private String myValue;
        private String myAlpha;
        private final Map<String, Boolean> myAttributes;

        public StateListState(String value, Map<String, Boolean> attributes, String alpha) {
            this.myValue = value;
            this.myAttributes = attributes;
            this.myAlpha = alpha;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public void setAlpha(String alpha) {
            this.myAlpha = alpha;
        }

        public String getValue() {
            return this.myValue;
        }

        public String getAlpha() {
            return this.myAlpha;
        }

        public Map<String, Boolean> getAttributes() {
            return this.myAttributes;
        }
    }

    public static class StateList {
        private final String myFileName;
        private final String myDirName;
        private final List<StateListState> myStates;

        public StateList(String fileName, String dirName) {
            this.myFileName = fileName;
            this.myDirName = dirName;
            this.myStates = new ArrayList<StateListState>();
        }

        public String getFileName() {
            return this.myFileName;
        }

        public String getDirName() {
            return this.myDirName;
        }

        public ResourceFolderType getType() {
            return ResourceFolderType.getFolderType((String)this.myDirName);
        }

        public List<StateListState> getStates() {
            return this.myStates;
        }

        public void addState(StateListState state) {
            this.myStates.add(state);
        }
    }
}

