/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;

public class ResourceNotificationManager
implements ProjectComponent {
    private final Project myProject;
    private final Map<Module, ModuleEventObserver> myModuleToObserverMap = Maps.newHashMap();
    private final Map<PsiFile, FileEventObserver> myFileToObserverMap = Maps.newHashMap();
    private final Map<Configuration, ConfigurationEventObserver> myConfigurationToObserverMap = Maps.newHashMap();
    private ProjectEventObserver myProjectEventObserver;
    private boolean myPendingNotify;
    private long myModificationCount;
    private EnumSet<Reason> myEvents = EnumSet.noneOf(Reason.class);
    private final Object CHANGE_PENDING_LOCK = new Object();

    public ResourceNotificationManager(Project project) {
        this.myProject = project;
    }

    public static ResourceNotificationManager getInstance(Project project) {
        return (ResourceNotificationManager)project.getComponent(ResourceNotificationManager.class);
    }

    public ResourceVersion getCurrentVersion(AndroidFacet facet, PsiFile file, Configuration configuration) {
        AppResourceRepository repository = AppResourceRepository.getAppResources(facet, true);
        if (file != null) {
            long fileStamp = file.getModificationStamp();
            if (configuration != null) {
                return new ResourceVersion(repository.getModificationCount(), fileStamp, configuration.getModificationCount(), configuration.getConfigurationManager().getStateVersion(), this.myModificationCount);
            }
            return new ResourceVersion(repository.getModificationCount(), fileStamp, 0L, 0L, this.myModificationCount);
        }
        return new ResourceVersion(repository.getModificationCount(), 0L, 0L, 0L, this.myModificationCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceVersion addListener(ResourceChangeListener listener, AndroidFacet facet, PsiFile file, Configuration configuration) {
        ResourceNotificationManager resourceNotificationManager = this;
        synchronized (resourceNotificationManager) {
            Module module = facet.getModule();
            ModuleEventObserver moduleEventObserver = this.myModuleToObserverMap.get(module);
            if (moduleEventObserver == null) {
                if (this.myModuleToObserverMap.isEmpty()) {
                    if (this.myProjectEventObserver == null) {
                        this.myProjectEventObserver = new ProjectEventObserver();
                    }
                    this.myProjectEventObserver.registerListeners();
                }
                moduleEventObserver = new ModuleEventObserver(facet);
                this.myModuleToObserverMap.put(module, moduleEventObserver);
            }
            moduleEventObserver.addListener(listener);
            if (file != null) {
                FileEventObserver fileEventObserver = this.myFileToObserverMap.get(file);
                if (fileEventObserver == null) {
                    fileEventObserver = new FileEventObserver();
                    this.myFileToObserverMap.put(file, fileEventObserver);
                }
                fileEventObserver.addListener(listener);
                if (configuration != null) {
                    ConfigurationEventObserver configurationEventObserver = this.myConfigurationToObserverMap.get(configuration);
                    if (configurationEventObserver == null) {
                        configurationEventObserver = new ConfigurationEventObserver(configuration);
                        this.myConfigurationToObserverMap.put(configuration, configurationEventObserver);
                    }
                    configurationEventObserver.addListener(listener);
                }
            } else assert (configuration == null) : configuration;
            return this.getCurrentVersion(facet, file, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ResourceChangeListener listener, AndroidFacet facet, PsiFile file, Configuration configuration) {
        ResourceNotificationManager resourceNotificationManager = this;
        synchronized (resourceNotificationManager) {
            if (file != null) {
                FileEventObserver fileEventObserver;
                ConfigurationEventObserver configurationEventObserver;
                if (configuration != null && (configurationEventObserver = this.myConfigurationToObserverMap.get(configuration)) != null) {
                    configurationEventObserver.removeListener(listener);
                    if (!configurationEventObserver.hasListeners()) {
                        this.myConfigurationToObserverMap.remove(configuration);
                    }
                }
                if ((fileEventObserver = this.myFileToObserverMap.get(file)) != null) {
                    fileEventObserver.removeListener(listener);
                    if (!fileEventObserver.hasListeners()) {
                        this.myFileToObserverMap.remove(file);
                    }
                }
            } else assert (configuration == null) : configuration;
            Module module = facet.getModule();
            ModuleEventObserver moduleEventObserver = this.myModuleToObserverMap.get(module);
            if (moduleEventObserver != null) {
                moduleEventObserver.removeListener(listener);
                if (!moduleEventObserver.hasListeners()) {
                    this.myModuleToObserverMap.remove(module);
                    if (this.myModuleToObserverMap.isEmpty() && this.myProjectEventObserver != null) {
                        this.myProjectEventObserver.unregisterListeners();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notice(Reason reason) {
        this.myEvents.add(reason);
        Object object = this.CHANGE_PENDING_LOCK;
        synchronized (object) {
            if (this.myPendingNotify) {
                return;
            }
            this.myPendingNotify = true;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ResourceNotificationManager.this.CHANGE_PENDING_LOCK;
                synchronized (object) {
                    if (!ResourceNotificationManager.this.myPendingNotify) {
                        return;
                    }
                    ResourceNotificationManager.this.myPendingNotify = false;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnumSet reason = ResourceNotificationManager.this.myEvents;
                        ResourceNotificationManager.this.myEvents = EnumSet.noneOf(Reason.class);
                        ResourceNotificationManager.this.notifyListeners(reason);
                        ResourceNotificationManager.this.myEvents.clear();
                    }
                });
            }
        });
    }

    private void notifyListeners(EnumSet<Reason> reason) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ModuleEventObserver moduleEventObserver : this.myModuleToObserverMap.values()) {
            moduleEventObserver.notifyListeners(reason);
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getComponentName() {
        return "ResourceNotificationManager";
    }

    public static enum Reason {
        RESOURCE_EDIT,
        EDIT,
        CONFIGURATION_CHANGED,
        SDK_CHANGED,
        VARIANT_CHANGED,
        GRADLE_SYNC,
        PROJECT_BUILD;

    }

    public static class ResourceVersion {
        private final long myResourceGeneration;
        private final long myFileGeneration;
        private final long myConfigurationGeneration;
        private final long myProjectConfigurationGeneration;
        private final long myOtherGeneration;

        private ResourceVersion(long resourceGeneration, long fileGeneration, long configurationGeneration, long projectConfigurationGeneration, long otherGeneration) {
            this.myResourceGeneration = resourceGeneration;
            this.myFileGeneration = fileGeneration;
            this.myConfigurationGeneration = configurationGeneration;
            this.myProjectConfigurationGeneration = projectConfigurationGeneration;
            this.myOtherGeneration = otherGeneration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceVersion version = (ResourceVersion)o;
            if (this.myResourceGeneration != version.myResourceGeneration) {
                return false;
            }
            if (this.myFileGeneration != version.myFileGeneration) {
                return false;
            }
            if (this.myConfigurationGeneration != version.myConfigurationGeneration) {
                return false;
            }
            if (this.myProjectConfigurationGeneration != version.myProjectConfigurationGeneration) {
                return false;
            }
            return this.myOtherGeneration == version.myOtherGeneration;
        }

        public int hashCode() {
            int result = (int)(this.myResourceGeneration ^ this.myResourceGeneration >>> 32);
            result = 31 * result + (int)(this.myFileGeneration ^ this.myFileGeneration >>> 32);
            result = 31 * result + (int)(this.myConfigurationGeneration ^ this.myConfigurationGeneration >>> 32);
            result = 31 * result + (int)(this.myProjectConfigurationGeneration ^ this.myProjectConfigurationGeneration >>> 32);
            result = 31 * result + (int)(this.myOtherGeneration ^ this.myOtherGeneration >>> 32);
            return result;
        }

        public String toString() {
            return "ResourceVersion{resource=" + this.myResourceGeneration + ", file=" + this.myFileGeneration + ", configuration=" + this.myConfigurationGeneration + ", projectConfiguration=" + this.myProjectConfigurationGeneration + ", other=" + this.myOtherGeneration + '}';
        }
    }

    public static interface ResourceChangeListener {
        public void resourcesChanged(Set<Reason> var1);
    }

    private class ConfigurationEventObserver
    implements ConfigurationListener {
        private final Configuration myConfiguration;
        private List<ResourceChangeListener> myListeners = Lists.newArrayListWithExpectedSize((int)2);

        public ConfigurationEventObserver(Configuration configuration) {
            this.myConfiguration = configuration;
        }

        private void addListener(ResourceChangeListener listener) {
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener);
        }

        private void removeListener(ResourceChangeListener listener) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }

        private void registerListeners() {
            this.myConfiguration.addListener(this);
        }

        private void unregisterListeners() {
            this.myConfiguration.removeListener(this);
        }

        @Override
        public boolean changed(int flags) {
            if ((flags & 0xFE) != 0) {
                ResourceNotificationManager.this.notice(Reason.CONFIGURATION_CHANGED);
            }
            return true;
        }
    }

    private static class FileEventObserver {
        private List<ResourceChangeListener> myListeners = Lists.newArrayListWithExpectedSize((int)2);

        private void addListener(ResourceChangeListener listener) {
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener);
        }

        private void removeListener(ResourceChangeListener listener) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private void registerListeners() {
        }

        private void unregisterListeners() {
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }
    }

    private class ProjectEventObserver
    implements PsiTreeChangeListener,
    AndroidProjectBuildNotifications.AndroidProjectBuildListener {
        private boolean myAlreadyAddedBuildListener;
        private boolean myIgnoreBuildEvents;
        boolean myIgnoreChildrenChanged;

        private ProjectEventObserver() {
        }

        private void registerListeners() {
            if (!this.myAlreadyAddedBuildListener) {
                this.myAlreadyAddedBuildListener = true;
                AndroidProjectBuildNotifications.subscribe(ResourceNotificationManager.this.myProject, this);
            }
            this.myIgnoreBuildEvents = false;
            PsiManager.getInstance((Project)ResourceNotificationManager.this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this);
        }

        private void unregisterListeners() {
            PsiManager.getInstance((Project)ResourceNotificationManager.this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this);
            this.myIgnoreBuildEvents = true;
        }

        @Override
        public void buildComplete(AndroidProjectBuildNotifications.BuildContext context) {
            if (!this.myIgnoreBuildEvents) {
                ResourceNotificationManager.this.myModificationCount++;
                ResourceNotificationManager.this.notice(Reason.PROJECT_BUILD);
            }
        }

        public void beforeChildAddition(PsiTreeChangeEvent event) {
        }

        public void beforeChildRemoval(PsiTreeChangeEvent event) {
        }

        public void beforeChildReplacement(PsiTreeChangeEvent event) {
        }

        public void beforeChildMovement(PsiTreeChangeEvent event) {
        }

        public void beforeChildrenChange(PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = false;
        }

        public void beforePropertyChange(PsiTreeChangeEvent event) {
        }

        public void childAdded(PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event)) {
                String text;
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (child instanceof XmlAttribute && parent instanceof XmlTag) {
                    if (((XmlAttribute)child).getValueElement() == null) {
                        return;
                    }
                } else if (parent instanceof XmlAttribute && child instanceof XmlAttributeValue) {
                    XmlAttributeValue attributeValue = (XmlAttributeValue)child;
                    if (attributeValue.getValue() == null || attributeValue.getValue().isEmpty()) {
                        return;
                    }
                } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() == null && (text = child.getText()).startsWith("@") && !text.startsWith("@{")) {
                    if (text.equals("@") || text.equals("@android:")) {
                        return;
                    }
                    ResourceUrl url = ResourceUrl.parse((String)text);
                    if (url != null && url.name.isEmpty()) {
                        return;
                    }
                }
                ResourceNotificationManager.this.notice(Reason.EDIT);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        public void childRemoved(PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event)) {
                XmlAttributeValue valueElement;
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (parent instanceof XmlAttribute && child instanceof XmlToken && ((valueElement = ((XmlAttribute)parent).getValueElement()) == null || valueElement.getValue() == null || valueElement.getValue().isEmpty())) {
                    return;
                }
                ResourceNotificationManager.this.notice(Reason.EDIT);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event)) {
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (parent instanceof XmlAttribute && child instanceof XmlToken) {
                    XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                    if (valueElement == null || valueElement.getValue() == null || valueElement.getValue().isEmpty()) {
                        return;
                    }
                } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() != null) {
                    String newText = child.getText();
                    String prevText = event.getOldChild().getText();
                    if (newText.startsWith("@") && !newText.startsWith("@{")) {
                        ResourceUrl prevUrl = ResourceUrl.parse((String)prevText);
                        ResourceUrl newUrl = ResourceUrl.parse((String)newText);
                        if (prevUrl != null && prevUrl.name.isEmpty()) {
                            prevUrl = null;
                        }
                        if (newUrl != null && newUrl.name.isEmpty()) {
                            newUrl = null;
                        }
                        if (prevUrl == null && newUrl == null) {
                            return;
                        }
                    }
                }
                ResourceNotificationManager.this.notice(Reason.EDIT);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        public void childMoved(PsiTreeChangeEvent event) {
            this.check(event);
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            if (this.myIgnoreChildrenChanged) {
                return;
            }
            this.check(event);
        }

        public void propertyChanged(PsiTreeChangeEvent event) {
        }

        private boolean isRelevantFile(PsiTreeChangeEvent event) {
            PsiFile file;
            return !ResourceNotificationManager.this.myFileToObserverMap.isEmpty() && (file = event.getFile()) != null && ResourceNotificationManager.this.myFileToObserverMap.containsKey(file);
        }

        private boolean isIgnorable(PsiTreeChangeEvent event) {
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            if (child instanceof PsiErrorElement || child instanceof XmlComment || parent instanceof XmlComment) {
                return true;
            }
            return (child instanceof PsiWhiteSpace || child instanceof XmlText || parent instanceof XmlText) && ResourceHelper.getFolderType(event.getFile()) != ResourceFolderType.VALUES;
        }

        private void check(PsiTreeChangeEvent event) {
            PsiFile file;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event) && (file = event.getFile()) != null) {
                ResourceNotificationManager.this.notice(Reason.EDIT);
                return;
            }
            ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
        }
    }

    private class ModuleEventObserver
    implements ModificationTracker,
    ResourceFolderManager.ResourceFolderListener {
        private final AndroidFacet myFacet;
        private long myGeneration;
        private final List<ResourceChangeListener> myListeners = Lists.newArrayListWithExpectedSize((int)4);

        private ModuleEventObserver(AndroidFacet facet) {
            this.myFacet = facet;
            this.myGeneration = AppResourceRepository.getAppResources(facet, true).getModificationCount();
        }

        public long getModificationCount() {
            return this.myGeneration;
        }

        private void addListener(ResourceChangeListener listener) {
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener);
        }

        private void removeListener(ResourceChangeListener listener) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private void registerListeners() {
            if (this.myFacet.requiresAndroidModel()) {
                ModuleResourceRepository.getModuleResources(this.myFacet, true);
                this.myFacet.getResourceFolderManager().addListener(this);
            }
        }

        private void unregisterListeners() {
            if (this.myFacet.requiresAndroidModel()) {
                this.myFacet.getResourceFolderManager().removeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(EnumSet<Reason> reason) {
            ArrayList listeners;
            long generation = this.myFacet.getAppResources(true).getModificationCount();
            if (reason.size() == 1 && reason.contains((Object)Reason.RESOURCE_EDIT) && generation == this.myGeneration) {
                return;
            }
            this.myGeneration = generation;
            ApplicationManager.getApplication().assertIsDispatchThread();
            ModuleEventObserver moduleEventObserver = this;
            synchronized (moduleEventObserver) {
                listeners = Lists.newArrayList(this.myListeners);
            }
            for (ResourceChangeListener listener : listeners) {
                listener.resourcesChanged(reason);
            }
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }

        @Override
        public void resourceFoldersChanged(AndroidFacet facet, List<VirtualFile> folders, Collection<VirtualFile> added, Collection<VirtualFile> removed) {
            ResourceNotificationManager.this.myModificationCount++;
            ResourceNotificationManager.this.notice(Reason.GRADLE_SYNC);
        }
    }
}

