/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TagSnapshot {
    public final String namespace;
    public final String tagName;
    public final XmlTag tag;
    public final String prefix;
    private TagSnapshot myNext;
    public List<TagSnapshot> children;
    public List<AttributeSnapshot> attributes;

    private TagSnapshot(XmlTag tag, String tagName, String prefix, String namespace, List<AttributeSnapshot> attributes, List<TagSnapshot> children) {
        this.tagName = tagName != null ? tagName : "?";
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.namespace = namespace;
        this.tag = tag;
        this.attributes = attributes;
        this.children = children;
    }

    public static TagSnapshot createSyntheticTag(XmlTag tag, String tagName, String prefix, String namespace, List<AttributeSnapshot> attributes, List<TagSnapshot> children) {
        return new TagSnapshot(tag, tagName, prefix, namespace, attributes, children);
    }

    public static TagSnapshot createTagSnapshot(XmlTag tag) {
        ArrayList children;
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length > 0) {
            TagSnapshot last = null;
            children = Lists.newArrayListWithExpectedSize((int)subTags.length);
            for (XmlTag subTag : subTags) {
                TagSnapshot child = TagSnapshot.createTagSnapshot(subTag);
                children.add(child);
                if (last != null) {
                    last.myNext = child;
                }
                last = child;
            }
        } else {
            children = Collections.emptyList();
        }
        return new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children);
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public String getAttribute(String name, String namespace) {
        for (AttributeSnapshot attribute : this.attributes) {
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute.value;
        }
        return null;
    }

    public void setAttribute(String name, String namespace, String prefix, String value) {
        for (AttributeSnapshot attribute : this.attributes) {
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            this.attributes.remove(attribute);
            break;
        }
        if (value != null) {
            if (this.attributes.isEmpty()) {
                this.attributes = Lists.newArrayList();
            }
            this.attributes.add(new AttributeSnapshot(namespace, prefix, name, value));
        }
    }

    public TagSnapshot getNextSibling() {
        return this.myNext;
    }

    public String toString() {
        return "TagSnapshot{" + this.tagName + ", attributes=" + this.attributes + ", children=\n" + this.children + "\n}";
    }
}

