/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.multi.RenderPreview;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PreviewRowLayout {
    private final List<RenderPreview> myPreviews;
    private final RenderContext myRenderContext;
    private final boolean myFixedOrder;
    private int myLayoutHeight;

    public PreviewRowLayout(List<RenderPreview> previews, RenderContext renderContext, boolean fixedOrder) {
        this.myPreviews = previews;
        this.myRenderContext = renderContext;
        this.myFixedOrder = fixedOrder;
    }

    public void performLayout() {
        List<RenderPreview> aspectOrder;
        Rectangle clientArea = this.myRenderContext.getClientArea();
        Dimension scaledImageSize = this.myRenderContext.getScaledImageSize();
        int scaledImageWidth = scaledImageSize.width;
        int scaledImageHeight = scaledImageSize.height;
        int availableWidth = clientArea.width;
        int availableHeight = clientArea.height;
        int maxVisibleY = clientArea.y + clientArea.height;
        int bottomBorder = scaledImageHeight + 20;
        int rightHandSide = scaledImageWidth + 12 + 20;
        int nextY = 0;
        int x = rightHandSide;
        int y = 0;
        boolean wrapped = false;
        int vgap = 18;
        for (RenderPreview preview : this.myPreviews) {
            if (!preview.isForked()) continue;
            vgap *= 2;
            break;
        }
        if (!this.myFixedOrder) {
            aspectOrder = new ArrayList<RenderPreview>(this.myPreviews);
            Collections.sort(aspectOrder, RenderPreview.INCREASING_ASPECT_RATIO);
        } else {
            aspectOrder = this.myPreviews;
        }
        for (RenderPreview preview : aspectOrder) {
            if (x > 0 && x + preview.getLayoutWidth() > availableWidth) {
                x = rightHandSide;
                int prevY = y;
                y = nextY;
                if ((prevY <= bottomBorder || y <= bottomBorder) && Math.max(nextY, y + preview.getLayoutHeight()) > bottomBorder && bottomBorder < availableHeight - 40 && preview.getScale() < 1.2) {
                    if (bottomBorder - y > y + preview.getLayoutHeight() - bottomBorder) {
                        rightHandSide = 0;
                        wrapped = true;
                    } else if (!wrapped) {
                        y = nextY = Math.max(nextY, bottomBorder + vgap);
                        rightHandSide = 0;
                        x = 0;
                        wrapped = true;
                    }
                }
            }
            if (x > 0 && y <= bottomBorder && Math.max(nextY, y + preview.getLayoutHeight()) > bottomBorder && clientArea.height - bottomBorder >= preview.getLayoutHeight() && preview.getScale() < 1.2) {
                if (bottomBorder - y > y + preview.getLayoutHeight() - bottomBorder) {
                    rightHandSide = 0;
                    wrapped = true;
                } else {
                    y = nextY = Math.max(nextY, bottomBorder + vgap);
                    rightHandSide = 0;
                    x = 0;
                    wrapped = true;
                }
            }
            preview.setPosition(x, y);
            if (y > maxVisibleY && maxVisibleY > 0) {
                preview.setVisible(false);
            } else if (!preview.isVisible()) {
                preview.setVisible(true);
            }
            x += preview.getLayoutWidth();
            x += 12;
            nextY = Math.max(nextY, y + preview.getLayoutHeight() + vgap);
        }
        this.myLayoutHeight = nextY;
    }

    public int getLayoutHeight() {
        return this.myLayoutHeight;
    }
}

