/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.CloudConfigurationProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CloudTestingConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final String ENABLE_CLOUD_TESTING_PROPERTY = "com.google.gct.testing.enable";
    private JPanel panel;
    private JCheckBox enableCloudTesting = new JCheckBox();

    public String getDisplayName() {
        return "Cloud Test Lab";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.panel = new JPanel(new BorderLayout(5, 10));
        JPanel content = new JPanel(new BorderLayout());
        this.panel.add((Component)content, "North");
        JEditorPane warningPane = new JEditorPane("text/html", "<html>Google Cloud Test Lab provides a wide array of virtual and physical devices, to use for running tests and debugging. Use it to run your tests against a matrix of device combinations with a single click.<br><br><a href='https://developers.google.com/cloud-test-lab'>More about Google Cloud Test Lab</a><br><br><a href='https://cloud.google.com/pricing'>Pricing information</a><br><br></html>");
        if (!CloudConfigurationProvider.canEnable()) {
            warningPane.setText("<html>This feature is coming soon. Stay tuned!<br><br>For more information, please visit <a href='https://developers.google.com/cloud-test-lab'>Google Cloud Test Lab</a>.<br><br></html>");
        }
        warningPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        warningPane.setFont(this.enableCloudTesting.getFont());
        warningPane.setEditable(false);
        warningPane.setBackground(this.panel.getBackground());
        HyperlinkListener hyperlinkListener = this.getHyperlinkListener();
        warningPane.addHyperlinkListener(hyperlinkListener);
        content.add((Component)warningPane, "North");
        if (CloudConfigurationProvider.canEnable()) {
            this.enableCloudTesting.setText("Enable testing and debugging in the cloud");
            content.add((Component)this.enableCloudTesting, "West");
            JEditorPane legalDisclaimer = new JEditorPane("text/html", "<html><br><br><br>The Google Cloud Platform Terms of Service notwithstanding, your use of Google Cloud Test Lab is governed by the <a href='https://drive.google.com/open?id=0B9D68w_vPl-dX01mQzF2SEM4VE0'>Trusted Testers Agreement</a> and by using Google Cloud Test Lab, you agree to its terms.");
            legalDisclaimer.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            legalDisclaimer.setFont(this.enableCloudTesting.getFont().deriveFont(2));
            legalDisclaimer.setEditable(false);
            legalDisclaimer.setBackground(this.panel.getBackground());
            legalDisclaimer.addHyperlinkListener(hyperlinkListener);
            this.panel.add((Component)legalDisclaimer, "South");
        }
        return this.panel;
    }

    private HyperlinkListener getHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(final HyperlinkEvent linkEvent) {
                if (linkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Desktop.getDesktop().browse(linkEvent.getURL().toURI());
                            }
                            catch (IOException e) {
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        };
    }

    public boolean isModified() {
        return CloudTestingConfigurable.getPersistedEnableProperty() != this.enableCloudTesting.isSelected();
    }

    public void apply() throws ConfigurationException {
        PropertiesComponent.getInstance().setValue(ENABLE_CLOUD_TESTING_PROPERTY, String.valueOf(this.enableCloudTesting.isSelected()));
    }

    public void reset() {
        this.enableCloudTesting.setSelected(CloudTestingConfigurable.getPersistedEnableProperty());
    }

    public static boolean getPersistedEnableProperty() {
        return PropertiesComponent.getInstance().getBoolean(ENABLE_CLOUD_TESTING_PROPERTY, false);
    }

    public void disposeUIResources() {
        this.panel = null;
        this.enableCloudTesting = null;
    }

    public String getId() {
        return "cloud.testing";
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

