/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class InstalledApks
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Map<String, Map<String, InstallState>> myCache = Maps.newHashMap();
    private String myDiagnosticOutput;

    public InstalledApks() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public boolean isInstalled(IDevice device, File apk, String pkgName) throws IOException {
        String serial = device.getSerialNumber();
        Map<String, InstallState> cache = this.myCache.get(serial);
        if (cache == null) {
            return false;
        }
        InstallState state = cache.get(pkgName);
        if (state == null) {
            return false;
        }
        String lastUpdateTime = this.getLastUpdateTime(device, pkgName);
        return lastUpdateTime != null && lastUpdateTime.equals(state.lastUpdateTime) && state.hash.equals((Object)InstalledApks.hash(apk));
    }

    public void setInstalled(IDevice device, File apk, String pkgName) throws IOException {
        String lastUpdateTime;
        String serial = device.getSerialNumber();
        HashMap cache = this.myCache.get(serial);
        if (cache == null) {
            cache = Maps.newHashMap();
            this.myCache.put(serial, cache);
        }
        if ((lastUpdateTime = this.getLastUpdateTime(device, pkgName)) == null) {
            String msg = String.format("Unexpected error: package manager reports that package %1$s has not been installed: %2$s", pkgName, StringUtil.notNullize((String)this.myDiagnosticOutput));
            Logger.getInstance(InstalledApks.class).warn(msg);
            return;
        }
        cache.put(pkgName, new InstallState(InstalledApks.hash(apk), lastUpdateTime));
    }

    private static HashCode hash(File apk) throws IOException {
        return Files.hash((File)apk, (HashFunction)Hashing.goodFastHash((int)32));
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        this.myCache.remove(device.getSerialNumber());
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    String getLastUpdateTime(IDevice device, String pkgName) {
        String output;
        boolean deviceHasPackage = false;
        this.myDiagnosticOutput = null;
        try {
            output = this.executeShellCommand(device, "dumpsys package " + pkgName, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.myDiagnosticOutput = String.format("Error executing 'dumpsys package %1$s:\n%2$s'", pkgName, e.getMessage());
            return null;
        }
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)output);
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("Package [")) continue;
            int startIndex = line.indexOf(91);
            int endIndex = line.indexOf(93);
            if (startIndex <= 0 || endIndex <= startIndex) break;
            deviceHasPackage = pkgName.equals(line.substring(startIndex + 1, endIndex));
            break;
        }
        if (!deviceHasPackage) {
            this.myDiagnosticOutput = String.format("Expected string 'Package [%1$s]' not found in output: %2$s", pkgName, output);
            return null;
        }
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("lastUpdateTime")) continue;
            return line;
        }
        return "";
    }

    protected String executeShellCommand(IDevice device, String cmd, long timeout, TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        device.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        latch.await(timeout, timeUnit);
        return receiver.getOutput();
    }

    private static class InstallState {
        public final HashCode hash;
        public final String lastUpdateTime;

        public InstallState(HashCode hash, String lastUpdateTime) {
            this.hash = hash;
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

