/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.google.common.base.Objects;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class LaunchCompatibility {
    @NonNls
    private static final String GOOGLE_APIS_TARGET_NAME = "Google APIs";
    private final ThreeState myCompatible;
    private final String myReason;
    private static final LaunchCompatibility YES = new LaunchCompatibility(ThreeState.YES, null);

    public LaunchCompatibility(ThreeState compatible, String reason) {
        this.myCompatible = compatible;
        this.myReason = reason;
    }

    public ThreeState isCompatible() {
        return this.myCompatible;
    }

    public String getReason() {
        return this.myReason;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("compatible", (Object)this.myCompatible).add("reason", (Object)this.myReason).toString();
    }

    public boolean equals(Object o) {
        return o instanceof LaunchCompatibility && this.myCompatible == ((LaunchCompatibility)o).myCompatible && Objects.equal((Object)this.myReason, (Object)((LaunchCompatibility)o).myReason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myCompatible, this.myReason});
    }

    public static LaunchCompatibility canRunOnDevice(AndroidVersion minSdkVersion, IAndroidTarget projectTarget, EnumSet<IDevice.HardwareFeature> requiredFeatures, IDevice device, IAndroidTarget avdTarget) {
        AndroidVersion deviceVersion = DevicePropertyUtil.getDeviceVersion(device);
        if (!deviceVersion.canRun(minSdkVersion)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion, deviceVersion, minSdkVersion.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        for (IDevice.HardwareFeature feature : requiredFeatures) {
            if (device.supportsFeature(feature)) continue;
            return new LaunchCompatibility(ThreeState.NO, "missing feature: " + feature);
        }
        if (device.supportsFeature(IDevice.HardwareFeature.WATCH) && !requiredFeatures.contains(IDevice.HardwareFeature.WATCH)) {
            return new LaunchCompatibility(ThreeState.NO, "missing uses-feature watch, non-watch apks cannot be launched on a watch");
        }
        if (projectTarget.isPlatform()) {
            return YES;
        }
        List additionaLibs = projectTarget.getAdditionalLibraries();
        if (additionaLibs.isEmpty()) {
            return YES;
        }
        if (avdTarget == null) {
            String targetName = projectTarget.getName();
            if (GOOGLE_APIS_TARGET_NAME.equals(targetName)) {
                return YES;
            }
            return new LaunchCompatibility(ThreeState.UNSURE, "unsure if device supports addon: " + targetName);
        }
        return LaunchCompatibility.isCompatibleAddonAvd(projectTarget, avdTarget);
    }

    private static LaunchCompatibility isCompatibleAddonAvd(IAndroidTarget projectTarget, IAndroidTarget avdTarget) {
        if (!StringUtil.equals((CharSequence)projectTarget.getVendor(), (CharSequence)avdTarget.getVendor())) {
            String reason = String.format("AVD vendor (%1$s) != AVD target (%2$s)", avdTarget.getVendor(), projectTarget.getVendor());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        if (!StringUtil.equals((CharSequence)projectTarget.getName(), (CharSequence)avdTarget.getName())) {
            String reason = String.format("AVD target name (%1$s) != Project target name (%2$s)", avdTarget.getName(), projectTarget.getName());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        return YES;
    }

    public static LaunchCompatibility canRunOnAvd(AndroidVersion minSdkVersion, IAndroidTarget projectTarget, IAndroidTarget avdTarget) {
        AndroidVersion avdVersion = avdTarget.getVersion();
        if (!avdVersion.canRun(minSdkVersion)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion, avdVersion, minSdkVersion.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        return projectTarget.isPlatform() ? YES : LaunchCompatibility.isCompatibleAddonAvd(projectTarget, avdTarget);
    }
}

