/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;

public final class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";

    private IdeSdks() {
    }

    public static File getAndroidSdkPath() {
        File candidate;
        String sdkHome = null;
        Sdk sdk = IdeSdks.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null) {
            return new File(FileUtil.toSystemDependentName((String)sdkHome));
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && IdeSdks.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    public static File getAndroidNdkPath() {
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (data == null) {
            return null;
        }
        LocalPkgInfo[] ndk = data.getLocalSdk().getPkgsInfos(PkgType.PKG_NDK);
        if (ndk.length == 0) {
            return null;
        }
        return ndk[0].getLocalDir();
    }

    public static File getJdkPath() {
        List<Sdk> androidSdks = IdeSdks.getEligibleAndroidSdks();
        if (androidSdks.isEmpty()) {
            String jdkPath;
            Sdk jdk = Jdks.chooseOrCreateJavaSdk();
            if (jdk != null && (jdkPath = jdk.getHomePath()) != null) {
                return new File(FileUtil.toSystemDependentName((String)jdkPath));
            }
        } else {
            for (Sdk sdk : androidSdks) {
                String jdkHomePath;
                AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
                assert (data != null);
                Sdk jdk = data.getJavaSdk();
                if (jdk == null || (jdkHomePath = jdk.getHomePath()) == null) continue;
                return new File(FileUtil.toSystemDependentName((String)jdkHomePath));
            }
        }
        return null;
    }

    private static Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = IdeSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public static void setJdkPath(File path) {
        if (JavaSdk.checkForJdk((File)path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            File canonicalPath = IdeSdks.resolvePath(path);
            Sdk chosenJdk = null;
            if (AndroidStudioInitializer.isAndroidStudio()) {
                List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                for (Sdk jdk : jdks) {
                    ProjectJdkTable.getInstance().removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.getPath())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (canonicalPath.isDirectory()) {
                    Project[] openProjects;
                    chosenJdk = IdeSdks.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path.getPath() + "'");
                    }
                    IdeSdks.updateAndroidSdks(chosenJdk);
                    ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
                    for (Project project : openProjects = projectManager.getOpenProjects()) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath.getPath() + "' was not found");
                }
            }
        }
    }

    public static List<Sdk> setAndroidSdkPath(File path, Project currentProject) {
        return IdeSdks.setAndroidSdkPath(path, null, currentProject);
    }

    private static void updateAndroidSdks(Sdk jdk) {
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    public static List<Sdk> setAndroidSdkPath(File path, Sdk javaSdk, Project currentProject) {
        if (IdeSdks.isValidAndroidSdkPath(path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path);
            AndroidSdkUtils.setSdkData(oldSdkData);
            ArrayList sdksToDelete = Lists.newArrayList();
            File resolved = IdeSdks.resolvePath(path);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved, true);
            if (sdkData != null) {
                for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = IdeSdks.createAndroidSdkPerAndroidTarget(resolved, javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved);
            return sdks;
        }
        return Collections.emptyList();
    }

    private static void afterAndroidSdkPathUpdate(File androidSdkPath) {
        ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            return;
        }
        AndroidSdkEventListener[] eventListeners = (AndroidSdkEventListener[])AndroidSdkEventListener.EP_NAME.getExtensions();
        for (Project project : openProjects) {
            if (!Projects.requiresAndroidModel(project)) continue;
            for (AndroidSdkEventListener listener : eventListeners) {
                listener.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public static boolean isValidAndroidSdkPath(File path) {
        return SdkPaths.validateAndroidSdk((File)path, (boolean)false).success;
    }

    public static List<Sdk> createAndroidSdkPerAndroidTarget(File androidSdkPath) {
        List<Sdk> sdks = IdeSdks.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        RunAndroidSdkManagerAction.updateInWelcomePage(null);
        return sdks;
    }

    private static List<Sdk> createAndroidSdkPerAndroidTarget(File androidSdkPath, Sdk javaSdk) {
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(androidSdkPath);
        if (sdkData == null) {
            return Collections.emptyList();
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            return Collections.emptyList();
        }
        ArrayList sdks = Lists.newArrayList();
        Sdk ideSdk = javaSdk != null ? javaSdk : IdeSdks.getJdk();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() || IdeSdks.doesIdeAndroidSdkExist(target)) continue;
            String name = AndroidSdkUtils.chooseNameForNewLibrary(target);
            Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, sdkData.getLocation().getPath(), name, ideSdk, true);
            if (sdk == null) continue;
            sdks.add(sdk);
        }
        return sdks;
    }

    private static boolean doesIdeAndroidSdkExist(IAndroidTarget target) {
        for (Sdk sdk : IdeSdks.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version)) continue;
            return true;
        }
        return false;
    }

    private static IAndroidTarget getTarget(Sdk sdk) {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        return androidPlatform.getTarget();
    }

    private static File resolvePath(File path) {
        try {
            String resolvedPath = FileUtil.resolveShortWindowsName((String)path.getPath());
            return new File(resolvedPath);
        }
        catch (IOException iOException) {
            return path;
        }
    }

    public static Sdk getJdk() {
        return IdeSdks.getJdk(null);
    }

    public static Sdk getJdk(JavaSdkVersion preferredVersion) {
        List<Sdk> androidSdks = IdeSdks.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            Sdk jdk = data.getJavaSdk();
            if (IdeSdks.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            for (Sdk jdk : jdks) {
                if (!IdeSdks.isJdkCompatible(jdk, preferredVersion)) continue;
                return jdk;
            }
        }
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            if (JavaSdk.checkForJdk((File)jdkPath)) {
                Sdk jdk = IdeSdks.createJdk(jdkPath);
                return IdeSdks.isJdkCompatible(jdk, preferredVersion) ? jdk : null;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk;
                if (!child.isDirectory() || !JavaSdk.checkForJdk((File)child) || !IdeSdks.isJdkCompatible(jdk = Jdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk;
            }
        }
        return null;
    }

    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        return virtualFiles;
    }

    private static boolean isJdkCompatible(Sdk jdk, JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        return JavaSdk.getInstance().isOfVersionOrHigher(jdk, preferredVersion);
    }

    public static List<Sdk> getEligibleAndroidSdks() {
        ArrayList sdks = Lists.newArrayList();
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        return sdks;
    }

    private static Sdk createJdk(File homeDirectory) {
        return Jdks.createJdk(homeDirectory.getPath());
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(File var1, Project var2);
    }
}

