/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class SdkPackages {
    private final Set<UpdatablePkgInfo> myUpdatedPkgs = Sets.newTreeSet();
    private final Set<RemotePkgInfo> myNewPkgs = Sets.newTreeSet();
    private final long myTimestampMs;
    private Map<String, UpdatablePkgInfo> myConsolidatedPkgs = Maps.newTreeMap();
    private LocalPkgInfo[] myLocalPkgInfos = new LocalPkgInfo[0];
    private Multimap<PkgType, RemotePkgInfo> myRemotePkgInfos = TreeMultimap.create();

    SdkPackages() {
        this.myTimestampMs = System.currentTimeMillis();
    }

    public SdkPackages(LocalPkgInfo[] localPkgs, Multimap<PkgType, RemotePkgInfo> remotePkgs) {
        this();
        this.setLocalPkgInfos(localPkgs);
        this.setRemotePkgInfos(remotePkgs);
    }

    public long getTimestampMs() {
        return this.myTimestampMs;
    }

    public Set<UpdatablePkgInfo> getUpdatedPkgs() {
        return this.myUpdatedPkgs;
    }

    public Set<RemotePkgInfo> getNewPkgs() {
        return this.myNewPkgs;
    }

    public Map<String, UpdatablePkgInfo> getConsolidatedPkgs() {
        return this.myConsolidatedPkgs;
    }

    public LocalPkgInfo[] getLocalPkgInfos() {
        return this.myLocalPkgInfos;
    }

    public Multimap<PkgType, RemotePkgInfo> getRemotePkgInfos() {
        return this.myRemotePkgInfos;
    }

    void setLocalPkgInfos(LocalPkgInfo[] packages) {
        this.myLocalPkgInfos = packages;
        this.computeUpdates();
    }

    void setRemotePkgInfos(Multimap<PkgType, RemotePkgInfo> packages) {
        this.myRemotePkgInfos = Multimaps.filterValues(packages, (Predicate)new Predicate<RemotePkgInfo>(){

            public boolean apply(RemotePkgInfo input) {
                return input.hasCompatibleArchive();
            }
        });
        this.computeUpdates();
    }

    private void computeUpdates() {
        TreeMap newConsolidatedPkgs = Maps.newTreeMap();
        UpdatablePkgInfo[] updatablePkgInfos = new UpdatablePkgInfo[this.myLocalPkgInfos.length];
        for (int i = 0; i < this.myLocalPkgInfos.length; ++i) {
            updatablePkgInfos[i] = new UpdatablePkgInfo(this.myLocalPkgInfos[i]);
        }
        TreeSet updates = Sets.newTreeSet();
        for (UpdatablePkgInfo info : updatablePkgInfos) {
            IPkgDesc localDesc = info.getLocalInfo().getDesc();
            for (RemotePkgInfo remote : this.myRemotePkgInfos.get((Object)localDesc.getType())) {
                if (!remote.getPkgDesc().isUpdateFor(localDesc, FullRevision.PreviewComparison.IGNORE)) continue;
                info.addRemote(remote);
                this.myUpdatedPkgs.add(info);
                updates.add(remote);
            }
            newConsolidatedPkgs.put(info.getPkgDesc(true).getBaseInstallId(), info);
        }
        block3: for (RemotePkgInfo remote : this.myRemotePkgInfos.values()) {
            if (updates.contains(remote)) continue;
            IPkgDesc remoteDesc = remote.getPkgDesc();
            for (UpdatablePkgInfo info : updatablePkgInfos) {
                IPkgDesc localDesc = info.getLocalInfo().getDesc();
                if (remoteDesc.compareTo((Object)localDesc) == 0 || remoteDesc.isUpdateFor(localDesc, FullRevision.PreviewComparison.IGNORE) || localDesc.isUpdateFor(remoteDesc, FullRevision.PreviewComparison.IGNORE)) continue block3;
            }
            this.myNewPkgs.add(remote);
            String key = remoteDesc.getBaseInstallId();
            UpdatablePkgInfo existing = (UpdatablePkgInfo)newConsolidatedPkgs.get(key);
            if (existing != null) {
                existing.addRemote(remote);
                continue;
            }
            newConsolidatedPkgs.put(key, new UpdatablePkgInfo(remote));
        }
        this.myConsolidatedPkgs = newConsolidatedPkgs;
    }
}

