/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.SdkLoadedCallback;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.RemoteSdk;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.Semaphore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.sdk.AndroidSdkData;

public class SdkState {
    public static final long DEFAULT_EXPIRATION_PERIOD_MS = TimeUnit.DAYS.toMillis(1L);
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.sdk.SdkState");
    private static final Set<SoftReference<SdkState>> sSdkStates = new HashSet<SoftReference<SdkState>>();
    private final AndroidSdkData mySdkData;
    private final RemoteSdk myRemoteSdk;
    private SdkPackages myPackages = new SdkPackages();
    private long myLastRefreshMs;
    private LoadTask myTask;
    private final Object myTaskLock = new Object();

    private SdkState(AndroidSdkData sdkData) {
        this.mySdkData = sdkData;
        if (this.mySdkData == null) {
            this.myPackages = new SdkPackages();
        }
        this.myRemoteSdk = new RemoteSdk();
    }

    public RemoteSdk getRemoteSdk() {
        return this.myRemoteSdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SdkState getInstance(AndroidSdkData sdkData) {
        Set<SoftReference<SdkState>> set = sSdkStates;
        synchronized (set) {
            Iterator<SoftReference<SdkState>> it = sSdkStates.iterator();
            while (it.hasNext()) {
                SoftReference<SdkState> ref = it.next();
                SdkState s = (SdkState)ref.get();
                if (s == null) {
                    it.remove();
                    continue;
                }
                if (!Objects.equal((Object)s.mySdkData, (Object)sdkData)) continue;
                return s;
            }
            SdkState s = new SdkState(sdkData);
            sSdkStates.add((SoftReference<SdkState>)new SoftReference((Object)s));
            return s;
        }
    }

    public AndroidSdkData getSdkData() {
        return this.mySdkData;
    }

    public SdkPackages getPackages() {
        return this.myPackages;
    }

    public boolean loadAsync(long timeoutMs, boolean canBeCancelled, SdkLoadedCallback onLocalComplete, SdkLoadedCallback onSuccess, Runnable onError, boolean forceRefresh) {
        return this.load(timeoutMs, canBeCancelled, SdkState.createList(onLocalComplete), SdkState.createList(onSuccess), SdkState.createList(onError), forceRefresh, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(long timeoutMs, boolean canBeCancelled, List<SdkLoadedCallback> onLocalComplete, List<SdkLoadedCallback> onSuccess, List<Runnable> onError, boolean forceRefresh, boolean sync) {
        if (!forceRefresh && System.currentTimeMillis() - this.myLastRefreshMs < timeoutMs) {
            for (SdkLoadedCallback localComplete : onLocalComplete) {
                localComplete.run(this.myPackages);
            }
            for (SdkLoadedCallback success : onSuccess) {
                success.run(this.myPackages);
            }
            return false;
        }
        Object object = this.myTaskLock;
        synchronized (object) {
            if (this.myTask != null) {
                this.myTask.addCallbacks(onLocalComplete, onSuccess, onError);
                return false;
            }
            this.myTask = new LoadTask(canBeCancelled, onLocalComplete, onSuccess, onError, forceRefresh, sync);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            this.myTask.run((ProgressIndicator)new EmptyProgressIndicator());
            return true;
        }
        ProgressManager.getInstance().run((Task)this.myTask);
        return true;
    }

    public boolean loadSynchronously(long timeoutMs, boolean canBeCancelled, SdkLoadedCallback onLocalComplete, SdkLoadedCallback onSuccess, final Runnable onError, boolean forceRefresh) {
        final Semaphore completed = new Semaphore();
        completed.down();
        List<SdkLoadedCallback> onLocalCompletes = SdkState.createList(onLocalComplete);
        List<SdkLoadedCallback> onSuccesses = SdkState.createList(onSuccess);
        List<Runnable> onErrors = SdkState.createList(onError);
        onSuccesses.add(new SdkLoadedCallback(false){

            @Override
            public void doRun(SdkPackages packages) {
                completed.up();
            }
        });
        onErrors.add(new Runnable(){

            @Override
            public void run() {
                completed.up();
            }
        });
        boolean result = this.load(timeoutMs, canBeCancelled, onLocalCompletes, onSuccesses, onErrors, forceRefresh, true);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            if (result) {
                return true;
            }
            try {
                completed.waitForUnsafe();
            }
            catch (InterruptedException e) {
                if (onError != null) {
                    onError.run();
                }
                return false;
            }
            return true;
        }
        ProgressManager pm = ProgressManager.getInstance();
        ProgressIndicator indicator = pm.getProgressIndicator();
        boolean startedProgress = indicator == null;
        Object object = indicator = startedProgress ? new ProgressWindow(false, false, null) : indicator;
        if (startedProgress) {
            indicator.start();
        }
        pm.executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                boolean success = false;
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                try {
                    completed.waitForUnsafe();
                    success = true;
                }
                catch (InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
                if (!success && onError != null) {
                    onError.run();
                }
            }
        }, indicator);
        if (startedProgress) {
            indicator.stop();
        }
        return result;
    }

    private static <T> List<T> createList(T r) {
        if (r == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new Object[]{r});
    }

    private class LoadTask
    extends Task.ConditionalModal {
        private final List<SdkLoadedCallback> myOnSuccesses;
        private final List<Runnable> myOnErrors;
        private final List<SdkLoadedCallback> myOnLocalCompletes;
        private final boolean myForceRefresh;
        private ProgressWindow myProgress;

        public LoadTask(boolean canBeCancelled, List<SdkLoadedCallback> onLocalComplete, List<SdkLoadedCallback> onSuccess, List<Runnable> onError, boolean forceRefresh, boolean modal) {
            super(null, "Loading Android SDK", canBeCancelled, modal ? PerformInBackgroundOption.DEAF : PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.myOnSuccesses = Lists.newArrayList();
            this.myOnErrors = Lists.newArrayList();
            this.myOnLocalCompletes = Lists.newArrayList();
            this.addCallbacks(onLocalComplete, onSuccess, onError);
            this.myForceRefresh = forceRefresh;
        }

        public void setProgress(ProgressWindow progress) {
            assert (this.myProgress == null);
            this.myProgress = progress;
        }

        public void addCallbacks(List<SdkLoadedCallback> onLocalComplete, List<SdkLoadedCallback> onSuccess, List<Runnable> onError) {
            this.myOnLocalCompletes.addAll(onLocalComplete);
            this.myOnSuccesses.addAll(onSuccess);
            this.myOnErrors.addAll(onError);
        }

        public ProgressWindow getProgress() {
            return this.myProgress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ProgressIndicator indicator) {
            boolean success;
            block63: {
                Object object;
                block62: {
                    SdkSources sources;
                    SdkPackages packages;
                    IndicatorLogger logger;
                    block61: {
                        block60: {
                            success = false;
                            logger = new IndicatorLogger(indicator);
                            packages = new SdkPackages();
                            if (SdkState.this.mySdkData != null) {
                                indicator.setText("Loading local SDK...");
                                indicator.setText2("");
                                if (this.myForceRefresh) {
                                    SdkState.this.mySdkData.getLocalSdk().clearLocalPkg(PkgType.PKG_ALL);
                                }
                                packages.setLocalPkgInfos(SdkState.this.mySdkData.getLocalSdk().getPkgsInfos(PkgType.PKG_ALL));
                                indicator.setFraction(0.25);
                            }
                            if (!indicator.isCanceled()) break block60;
                            SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                            Object object2 = SdkState.this.myTaskLock;
                            synchronized (object2) {
                                SdkState.this.myTask = null;
                                if (success) {
                                    for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                                        onLocalComplete.run(SdkState.this.myPackages);
                                    }
                                    for (SdkLoadedCallback onSuccess : this.myOnSuccesses) {
                                        onSuccess.run(SdkState.this.myPackages);
                                    }
                                } else {
                                    for (Runnable onError : this.myOnErrors) {
                                        onError.run();
                                    }
                                }
                            }
                            return;
                        }
                        Object object3 = SdkState.this.myTaskLock;
                        synchronized (object3) {
                            for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                                onLocalComplete.run(packages);
                            }
                            this.myOnLocalCompletes.clear();
                        }
                        indicator.setText("Find SDK Repository...");
                        indicator.setText2("");
                        sources = SdkState.this.myRemoteSdk.fetchSources(this.myForceRefresh ? 0L : 86400000L, logger);
                        indicator.setFraction(0.5);
                        if (!indicator.isCanceled()) break block61;
                        SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                        Object i$ = SdkState.this.myTaskLock;
                        synchronized (i$) {
                            SdkState.this.myTask = null;
                            if (success) {
                                for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                                    onLocalComplete.run(SdkState.this.myPackages);
                                }
                                for (SdkLoadedCallback onSuccess : this.myOnSuccesses) {
                                    onSuccess.run(SdkState.this.myPackages);
                                }
                            } else {
                                for (Runnable onError : this.myOnErrors) {
                                    onError.run();
                                }
                            }
                        }
                        return;
                    }
                    indicator.setText("Check SDK Repository...");
                    indicator.setText2("");
                    Multimap<PkgType, RemotePkgInfo> remotes = SdkState.this.myRemoteSdk.fetch(sources, logger);
                    indicator.setText("Compute SDK updates...");
                    indicator.setFraction(0.75);
                    packages.setRemotePkgInfos(remotes);
                    SdkState.this.myPackages = packages;
                    if (!indicator.isCanceled()) break block62;
                    SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                    object = SdkState.this.myTaskLock;
                    synchronized (object) {
                        SdkState.this.myTask = null;
                        if (success) {
                            for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                                onLocalComplete.run(SdkState.this.myPackages);
                            }
                            for (SdkLoadedCallback onSuccess : this.myOnSuccesses) {
                                onSuccess.run(SdkState.this.myPackages);
                            }
                        } else {
                            for (Runnable onError : this.myOnErrors) {
                                onError.run();
                            }
                        }
                    }
                    return;
                }
                indicator.setText2("");
                indicator.setFraction(1.0);
                if (!indicator.isCanceled()) break block63;
                SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                object = SdkState.this.myTaskLock;
                synchronized (object) {
                    SdkState.this.myTask = null;
                    if (success) {
                        for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                            onLocalComplete.run(SdkState.this.myPackages);
                        }
                        for (SdkLoadedCallback onSuccess : this.myOnSuccesses) {
                            onSuccess.run(SdkState.this.myPackages);
                        }
                    } else {
                        for (Runnable onError : this.myOnErrors) {
                            onError.run();
                        }
                    }
                }
                return;
            }
            try {
                success = true;
                SdkState.this.myLastRefreshMs = System.currentTimeMillis();
            }
            catch (Throwable throwable) {
                SdkState.this.myLastRefreshMs = System.currentTimeMillis();
                Object object = SdkState.this.myTaskLock;
                synchronized (object) {
                    SdkState.this.myTask = null;
                    if (success) {
                        for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                            onLocalComplete.run(SdkState.this.myPackages);
                        }
                        for (SdkLoadedCallback onSuccess : this.myOnSuccesses) {
                            onSuccess.run(SdkState.this.myPackages);
                        }
                    } else {
                        for (Runnable onError : this.myOnErrors) {
                            onError.run();
                        }
                    }
                }
                throw throwable;
            }
            SdkState.this.myLastRefreshMs = System.currentTimeMillis();
            Object object = SdkState.this.myTaskLock;
            synchronized (object) {
                SdkState.this.myTask = null;
                if (success) {
                    for (SdkLoadedCallback onLocalComplete : this.myOnLocalCompletes) {
                        onLocalComplete.run(SdkState.this.myPackages);
                    }
                    for (SdkLoadedCallback onSuccess : this.myOnSuccesses) {
                        onSuccess.run(SdkState.this.myPackages);
                    }
                } else {
                    for (Runnable onError : this.myOnErrors) {
                        onError.run();
                    }
                }
            }
        }
    }

    private static class IndicatorLogger
    implements ILogger {
        private final ProgressIndicator myIndicator;

        public IndicatorLogger(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        public void error(Throwable t, String msgFormat, Object ... args) {
            if (msgFormat == null && t != null) {
                this.myIndicator.setText2(t.toString());
            } else if (msgFormat != null) {
                this.myIndicator.setText2(String.format(msgFormat, args));
            }
        }

        public void warning(String msgFormat, Object ... args) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }

        public void info(String msgFormat, Object ... args) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }

        public void verbose(String msgFormat, Object ... args) {
        }
    }
}

