/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.SdkConstants;
import com.android.sdklib.repository.FullRevision;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionCheck {
    private static final Logger LOG = Logger.getInstance(VersionCheck.class);
    public static final FullRevision MIN_TOOLS_REV = new FullRevision(24, 0, 2, 0);
    private static final Pattern SOURCE_PROPERTY_PATTERN = Pattern.compile("^Pkg.Revision=(.*)$");

    private VersionCheck() {
    }

    public static boolean isCompatibleVersion(File sdkDir) {
        if (!sdkDir.isDirectory()) {
            return false;
        }
        return VersionCheck.isCompatibleVersion(sdkDir.getAbsolutePath());
    }

    public static boolean isCompatibleVersion(String sdkPath) {
        if (sdkPath == null) {
            return false;
        }
        return VersionCheck.checkVersion(sdkPath).isCompatibleVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static VersionCheckResult checkVersion(String sdkPath) {
        FullRevision toolsRevision;
        block13: {
            String line;
            File toolsDir = new File(sdkPath, SdkConstants.OS_SDK_TOOLS_FOLDER);
            toolsRevision = new FullRevision(Integer.MAX_VALUE);
            BufferedReader reader = null;
            File sourceProperties = new File(toolsDir, "source.properties");
            reader = new BufferedReader(new FileReader(sourceProperties));
            while ((line = reader.readLine()) != null) {
                Matcher m = SOURCE_PROPERTY_PATTERN.matcher(line);
                if (!m.matches()) continue;
                try {
                    toolsRevision = FullRevision.parseRevision((String)m.group(1));
                }
                catch (NumberFormatException ignore) {}
                break;
            }
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException e) {}
            break block13;
            catch (IOException e) {
                try {
                    String msg = String.format("Failed to read file: '%1$s' for Android SDK at '%2$s'", "source.properties", sdkPath);
                    LOG.info(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e3) {}
            }
        }
        return new VersionCheckResult(toolsRevision);
    }

    public static class VersionCheckResult {
        private final FullRevision myRevision;
        private final boolean myCompatibleVersion;

        VersionCheckResult(FullRevision revision) {
            this.myRevision = revision;
            this.myCompatibleVersion = VersionCheckResult.isCompatible(revision);
        }

        private static boolean isCompatible(FullRevision revision) {
            if (revision.getMajor() == Integer.MAX_VALUE) {
                return false;
            }
            return revision.compareTo(MIN_TOOLS_REV, FullRevision.PreviewComparison.IGNORE) >= 0;
        }

        public FullRevision getRevision() {
            return this.myRevision;
        }

        public boolean isCompatibleVersion() {
            return this.myCompatibleVersion;
        }
    }
}

